/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.viewers.AsynchronousSchedulingRuleFactory;
import org.eclipse.debug.internal.ui.views.ViewContextManager;
import org.eclipse.debug.internal.ui.views.ViewContextService;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;
import org.eclipse.debug.ui.contexts.ISuspendTriggerListener;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PerspectiveManager
implements ILaunchListener,
ISuspendTriggerListener,
ISaveParticipant {
    private Set<PerspectiveContext> fPerspectiveContexts = null;
    public static final String ATTR_DELEGATE_ID = "delegate";
    private boolean fPrompting;
    private final Map<ILaunch, IContextActivation[]> fLaunchToContextActivations = new HashMap<ILaunch, IContextActivation[]>();

    public void startup() {
        this.initPerspectives();
        DebugUIPlugin.getDefault().addSaveParticipant(this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
    }

    public void shutdown() {
        DebugUIPlugin.getDefault().removeSaveParticipant(this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
    }

    public synchronized void launchRemoved(ILaunch launch) {
        ISuspendTrigger trigger = (ISuspendTrigger)launch.getAdapter(ISuspendTrigger.class);
        if (trigger != null) {
            trigger.removeSuspendTriggerListener(this);
        }
        Runnable r = () -> {
            IContextActivation[] activations = this.fLaunchToContextActivations.remove(launch);
            if (activations != null) {
                IContextActivation[] iContextActivationArray = activations;
                int n = activations.length;
                int n2 = 0;
                while (n2 < n) {
                    IContextActivation activation = iContextActivationArray[n2];
                    activation.getContextService().deactivateContext(activation);
                    ++n2;
                }
            }
        };
        this.async(r);
    }

    public void launchChanged(ILaunch launch) {
    }

    public synchronized void launchAdded(ILaunch launch) {
        ISuspendTrigger trigger = (ISuspendTrigger)launch.getAdapter(ISuspendTrigger.class);
        if (trigger != null) {
            trigger.addSuspendTriggerListener(this);
        }
        String perspectiveId = null;
        try {
            perspectiveId = this.getPerspectiveId(launch);
        }
        catch (CoreException e) {
            String name = DebugUIPlugin.getModelPresentation().getText(launch);
            this.switchFailed(e, name);
        }
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        if (configuration != null && !LaunchConfigurationManager.isVisible(configuration)) {
            perspectiveId = null;
        }
        final String id = perspectiveId;
        MyUIJob switchJob = new MyUIJob(this, "Perspective Switch Job"){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow window = this.getWindowForPerspective(id);
                if (id != null && window != null && this.shouldSwitchPerspective(window, id, "org.eclipse.debug.ui.switch_to_perspective")) {
                    this.switchToPerspective(window, id);
                }
                return Status.OK_STATUS;
            }
        };
        switchJob.setSystem(true);
        switchJob.setPriority(10);
        switchJob.schedule();
    }

    protected void switchToPerspective(IWorkbenchWindow window, String id) {
        try {
            Shell dialog = this.getModalDialogOpen(window.getShell());
            window.getWorkbench().showPerspective(id, window);
            if (dialog != null) {
                dialog.setFocus();
            }
        }
        catch (WorkbenchException e) {
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), LaunchConfigurationsMessages.PerspectiveManager_Error_1, MessageFormat.format(LaunchConfigurationsMessages.PerspectiveManager_Unable_to_switch_to_perspective___0__2, id), e);
        }
    }

    protected void async(Runnable r) {
        Display d = DebugUIPlugin.getStandardDisplay();
        if (d != null && !d.isDisposed()) {
            d.asyncExec(r);
        }
    }

    protected void sync(Runnable r) {
        Display d = DebugUIPlugin.getStandardDisplay();
        if (d != null && !d.isDisposed()) {
            d.syncExec(r);
        }
    }

    protected void switchFailed(Throwable t, String launchName) {
        this.sync(() -> DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), LaunchConfigurationsMessages.PerspectiveManager_Error_1, MessageFormat.format(LaunchConfigurationsMessages.PerspectiveManager_Unable_to_switch_perpsectives_as_specified_by_launch___0__4, launchName), t));
    }

    private void handleBreakpointHit(final ILaunch launch) {
        String perspectiveId = null;
        try {
            perspectiveId = this.getPerspectiveId(launch);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        final String targetId = perspectiveId;
        MyUIJob switchJob = new MyUIJob(this, "Perspective Switch Job"){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow window = null;
                if (targetId != null) {
                    ILaunchConfiguration launchConfiguration;
                    IContextActivation[] ca;
                    Shell shell;
                    window = this.getWindowForPerspective(targetId);
                    if (window == null) {
                        return Status.OK_STATUS;
                    }
                    if (this.shouldSwitchPerspective(window, targetId, "org.eclipse.debug.ui.switch_perspective_on_suspend")) {
                        this.switchToPerspective(window, targetId);
                        window = this.getWindowForPerspective(targetId);
                        if (window == null) {
                            return Status.OK_STATUS;
                        }
                    }
                    if ((shell = window.getShell()) != null && DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.activate_workbench")) {
                        Shell dialog = this.getModalDialogOpen(shell);
                        if (shell.getMinimized()) {
                            shell.setMinimized(false);
                            if (dialog != null) {
                                dialog.setFocus();
                            }
                        }
                        if (dialog == null) {
                            shell.forceActive();
                        }
                    }
                    if ((ca = fLaunchToContextActivations.get(launch)) == null && (launchConfiguration = launch.getLaunchConfiguration()) != null) {
                        try {
                            String type = launchConfiguration.getType().getIdentifier();
                            ViewContextService service = ViewContextManager.getDefault().getService(window);
                            if (service != null) {
                                IContextService contextServce = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
                                String[] ids = service.getEnabledPerspectives();
                                IContextActivation[] activations = new IContextActivation[ids.length];
                                int i = 0;
                                while (i < ids.length) {
                                    IContextActivation activation;
                                    Context context = contextServce.getContext(type + ".internal." + ids[i]);
                                    if (!context.isDefined()) {
                                        context.define(context.getId(), null, null);
                                    }
                                    activations[i] = activation = contextServce.activateContext(context.getId());
                                    ++i;
                                }
                                fLaunchToContextActivations.put(launch, activations);
                            }
                        }
                        catch (CoreException e) {
                            DebugUIPlugin.log(e);
                        }
                    }
                }
                if (window != null && DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.activate_debug_view")) {
                    ViewContextService service = ViewContextManager.getDefault().getService(window);
                    service.showViewQuiet("org.eclipse.debug.ui.DebugView");
                }
                return Status.OK_STATUS;
            }
        };
        switchJob.setSystem(true);
        switchJob.setPriority(10);
        switchJob.setRule(AsynchronousSchedulingRuleFactory.getDefault().newSerialPerObjectRule(this));
        switchJob.schedule();
    }

    private Shell getModalDialogOpen(Shell shell) {
        Shell[] shells;
        Shell[] shellArray = shells = shell.getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell dialog = shellArray[n2];
            if ((dialog.getStyle() & 0x38000) > 0) {
                return dialog;
            }
            ++n2;
        }
        return null;
    }

    private IWorkbenchWindow getWindowForPerspective(String perspectiveId) {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (this.isWindowShowingPerspective(window, perspectiveId)) {
            return window;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            window = w;
            if (this.isWindowShowingPerspective(window, perspectiveId)) {
                return window;
            }
            ++n2;
        }
        window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window;
        }
        if (windows.length > 0) {
            return windows[0];
        }
        return null;
    }

    private boolean isWindowShowingPerspective(IWorkbenchWindow window, String perspectiveId) {
        IPerspectiveDescriptor perspectiveDescriptor;
        IWorkbenchPage page;
        return window != null && (page = window.getActivePage()) != null && (perspectiveDescriptor = page.getPerspective()) != null && perspectiveDescriptor.getId().equals(perspectiveId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldSwitchPerspective(IWorkbenchWindow window, String perspectiveId, String preferenceKey) {
        if (this.isCurrentPerspective(window, perspectiveId)) {
            return false;
        }
        String perspectiveName = this.getPerspectiveLabel(perspectiveId);
        if (perspectiveName == null) {
            return false;
        }
        String perspectiveDesc = this.getPerspectiveDescription(perspectiveId);
        Object[] args = perspectiveDesc != null ? new String[]{perspectiveName, perspectiveDesc} : new String[]{perspectiveName};
        String switchPerspective = DebugUIPlugin.getDefault().getPreferenceStore().getString(preferenceKey);
        if ("always".equals(switchPerspective)) {
            return true;
        }
        if ("never".equals(switchPerspective)) {
            return false;
        }
        Shell shell = window.getShell();
        if (shell == null || this.fPrompting) {
            return false;
        }
        this.fPrompting = true;
        Shell modal = this.getModalDialogOpen(shell);
        if (shell.getMinimized()) {
            shell.setMinimized(false);
            if (modal != null) {
                modal.setFocus();
            }
        }
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.activate_workbench") && modal == null) {
            shell.forceActive();
        }
        String message = "";
        if ("org.eclipse.debug.ui.switch_perspective_on_suspend".equals(preferenceKey)) {
            message = this.getPerspectiveDescription(perspectiveId) != null ? LaunchConfigurationsMessages.PerspectiveManager_suspend_description : LaunchConfigurationsMessages.PerspectiveManager_13;
        } else if ("org.eclipse.debug.ui.switch_to_perspective".equals(preferenceKey)) {
            message = this.getPerspectiveDescription(perspectiveId) != null ? LaunchConfigurationsMessages.PerspectiveManager_launch_description : LaunchConfigurationsMessages.PerspectiveManager_15;
        }
        LinkedHashMap<String, Integer> buttonLabelToId = new LinkedHashMap<String, Integer>();
        buttonLabelToId.put(LaunchConfigurationsMessages.PerspectiveManager_switch, 2);
        buttonLabelToId.put(IDialogConstants.NO_LABEL, 3);
        MessageDialogWithToggle dialog = MessageDialogWithToggle.open((int)3, (Shell)shell, (String)LaunchConfigurationsMessages.PerspectiveManager_12, (String)MessageFormat.format(message, args), null, (boolean)false, (IPreferenceStore)DebugUIPlugin.getDefault().getPreferenceStore(), (String)preferenceKey, (int)0, buttonLabelToId);
        boolean answer = dialog.getReturnCode() == 2;
        PerspectiveManager perspectiveManager = this;
        synchronized (perspectiveManager) {
            this.fPrompting = false;
            this.notifyAll();
        }
        if (this.isCurrentPerspective(window, perspectiveId)) {
            answer = false;
        }
        return answer;
    }

    protected boolean isCurrentPerspective(IWorkbenchWindow window, String perspectiveId) {
        IPerspectiveDescriptor perspectiveDescriptor;
        IWorkbenchPage page;
        boolean isCurrent = false;
        if (window != null && (page = window.getActivePage()) != null && (perspectiveDescriptor = page.getPerspective()) != null) {
            isCurrent = perspectiveId.equals(perspectiveDescriptor.getId());
        }
        return isCurrent;
    }

    protected String getPerspectiveLabel(String perspectiveId) {
        IPerspectiveDescriptor newPerspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (newPerspective == null) {
            return null;
        }
        return newPerspective.getLabel();
    }

    protected String getPerspectiveDescription(String perspectiveId) {
        IPerspectiveDescriptor newPerspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (newPerspective == null) {
            return null;
        }
        return newPerspective.getDescription();
    }

    protected String getPerspectiveId(ILaunch launch) throws CoreException {
        if (launch == null) {
            return null;
        }
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        if (config == null) {
            return null;
        }
        Set modes = launch.getLaunchConfiguration().getModes();
        modes.add(launch.getLaunchMode());
        String perspectiveId = this.getLaunchPerspective(config.getType(), modes, this.resolveLaunchDelegate(launch));
        if (perspectiveId != null && perspectiveId.equals("perspective_none")) {
            perspectiveId = null;
        }
        return perspectiveId;
    }

    public String getLaunchPerspective(ILaunchConfigurationType type, Set<String> modes, ILaunchDelegate delegate) {
        String id = null;
        PerspectiveContext context = this.findContext(new PerspectiveContext(type, delegate, modes));
        if ((context == null || context != null && !context.getPersepctiveMap().containsKey(modes)) && ((context = this.findContext(new PerspectiveContext(type, null, modes))) == null || context != null && !context.getPersepctiveMap().containsKey(modes))) {
            return this.getDefaultLaunchPerspective(type, delegate, modes);
        }
        if (context != null) {
            id = context.getPerspective(modes);
        }
        return id;
    }

    public String getLaunchPerspective(ILaunchConfigurationType type, String mode) {
        HashSet<String> modes = new HashSet<String>();
        modes.add(mode);
        return this.getLaunchPerspective(type, modes, null);
    }

    public void setLaunchPerspective(ILaunchConfigurationType type, String mode, String perspective) {
        HashSet<String> modes = new HashSet<String>();
        modes.add(mode);
        this.setLaunchPerspective(type, modes, null, perspective);
    }

    public void setLaunchPerspective(ILaunchConfigurationType type, Set<String> modes, ILaunchDelegate delegate, String perspectiveid) {
        PerspectiveContext item;
        PerspectiveContext context = new PerspectiveContext(type, delegate, modes);
        String id = null;
        if (!"perspective_none".equals(perspectiveid)) {
            id = "perspective_default".equals(perspectiveid) ? this.getDefaultLaunchPerspective(type, delegate, modes) : perspectiveid;
        }
        if ((item = this.findContext(context)) != null) {
            item.setPerspective(modes, id);
        } else {
            context.setPerspective(modes, id);
            item = context;
        }
        this.fPerspectiveContexts.add(item);
    }

    private PerspectiveContext findContext(PerspectiveContext context) {
        for (PerspectiveContext c : this.fPerspectiveContexts) {
            if (!context.equals(c)) continue;
            return c;
        }
        return null;
    }

    private String generatePerspectiveXML() throws ParserConfigurationException, CoreException {
        Document doc = DebugUIPlugin.getDocument();
        Element root = doc.createElement("launchPerspectives");
        doc.appendChild(root);
        Map<Set<String>, String> modesets = null;
        Element element = null;
        String id = null;
        ILaunchConfigurationType type = null;
        ILaunchDelegate delegate = null;
        for (PerspectiveContext context : this.fPerspectiveContexts) {
            modesets = context.getPersepctiveMap();
            type = context.getLaunchConfigurationType();
            delegate = context.getLaunchDelegate();
            for (Set<String> modes : modesets.keySet()) {
                id = context.getPerspective(modes);
                String defaultId = this.getDefaultLaunchPerspective(type, delegate, modes);
                if (id == null && defaultId != null) {
                    id = "perspective_none";
                }
                if (id == null || id.equals(defaultId)) continue;
                element = doc.createElement("launchPerspective");
                element.setAttribute("mode", this.createModesetString(modes));
                if (delegate != null) {
                    element.setAttribute(ATTR_DELEGATE_ID, delegate.getId());
                }
                element.setAttribute("configurationType", type.getIdentifier());
                element.setAttribute("perspective", id);
                root.appendChild(element);
            }
        }
        return DebugPlugin.serializeDocument((Document)doc);
    }

    public String getDefaultLaunchPerspective(ILaunchConfigurationType type, ILaunchDelegate delegate, Set<String> modes) {
        LaunchConfigurationTabGroupExtension extension;
        String id = null;
        if (delegate != null) {
            id = delegate.getPerspectiveId(modes);
        }
        if (id == null && (extension = LaunchConfigurationPresentationManager.getDefault().getExtension(type.getIdentifier(), modes)) != null && (id = extension.getPerspective(modes)) == null && modes.contains("debug")) {
            id = "org.eclipse.debug.ui.DebugPerspective";
        }
        return id;
    }

    private ILaunchDelegate resolveLaunchDelegate(ILaunch launch) throws CoreException {
        Set modes = launch.getLaunchConfiguration().getModes();
        modes.add(launch.getLaunchMode());
        ILaunchConfigurationType type = launch.getLaunchConfiguration().getType();
        ILaunchDelegate[] delegates = LaunchConfigurationManager.filterLaunchDelegates(type, modes);
        ILaunchDelegate delegate = null;
        if (delegates.length == 1) {
            delegate = delegates[0];
        } else if (delegates.length > 1 && (delegate = launch.getLaunchConfiguration().getPreferredDelegate(modes)) == null) {
            delegate = type.getPreferredDelegate(modes);
        }
        return delegate;
    }

    private void initPerspectives() {
        if (this.fPerspectiveContexts == null) {
            this.fPerspectiveContexts = new HashSet<PerspectiveContext>();
            String xml = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.PREF_LAUNCH_PERSPECTIVES");
            if (xml != null && xml.length() > 0) {
                try {
                    Element root = DebugPlugin.parseDocument((String)xml);
                    NodeList list = root.getChildNodes();
                    LaunchManager lm = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
                    ILaunchConfigurationType lctype = null;
                    ILaunchDelegate ldelegate = null;
                    Set<String> modes = null;
                    Node node = null;
                    Element element = null;
                    int i = 0;
                    while (i < list.getLength()) {
                        String nodeName;
                        node = list.item(i);
                        if (node.getNodeType() == 1 && (nodeName = (element = (Element)node).getNodeName()).equalsIgnoreCase("launchPerspective")) {
                            String type = element.getAttribute("configurationType");
                            String mode = element.getAttribute("mode");
                            String perspective = element.getAttribute("perspective");
                            String delegate = element.getAttribute(ATTR_DELEGATE_ID);
                            lctype = lm.getLaunchConfigurationType(type);
                            ldelegate = lm.getLaunchDelegate(delegate);
                            modes = this.parseModes(mode);
                            if (lctype != null && !modes.isEmpty() && !"".equals(perspective)) {
                                this.setLaunchPerspective(lctype, modes, ldelegate, perspective);
                            }
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
    }

    private Set<String> parseModes(String modes) {
        String[] ms;
        HashSet<String> modeset = new HashSet<String>();
        String[] stringArray = ms = modes.split(",");
        int n = ms.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            modeset.add(m.trim());
            ++n2;
        }
        return modeset;
    }

    private String createModesetString(Set<String> modes) {
        Object str = "";
        if (modes != null) {
            Iterator<String> iter = modes.iterator();
            while (iter.hasNext()) {
                str = (String)str + iter.next();
                if (!iter.hasNext()) continue;
                str = (String)str + ",";
            }
        }
        return str;
    }

    public void schedulePostSwitch(Job job) {
        job.setRule(AsynchronousSchedulingRuleFactory.getDefault().newSerialPerObjectRule(this));
        job.schedule();
    }

    @Override
    public void suspended(ILaunch launch, Object context) {
        this.handleBreakpointHit(launch);
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        try {
            DebugUIPlugin.getDefault().getPreferenceStore().putValue("org.eclipse.debug.ui.PREF_LAUNCH_PERSPECTIVES", this.generatePerspectiveXML());
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(DebugUIPlugin.newErrorStatus("Exception occurred while generating launch perspectives preference XML", e));
        }
    }

    private abstract class MyUIJob
    extends Job {
        public MyUIJob(String name) {
            super(name);
            this.setSystem(true);
            this.setPriority(10);
            this.setRule(AsynchronousSchedulingRuleFactory.getDefault().newSerialPerObjectRule((Object)this));
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Display asyncDisplay = DebugUIPlugin.getStandardDisplay();
            if (asyncDisplay == null || asyncDisplay.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            asyncDisplay.asyncExec(() -> {
                block8: {
                    IStatus result = null;
                    Throwable throwable = null;
                    try {
                        try {
                            if (monitor.isCanceled()) {
                                result = Status.CANCEL_STATUS;
                                break block8;
                            }
                            result = this.runInUIThread(monitor);
                        }
                        catch (Throwable t) {
                            throwable = t;
                            if (result == null) {
                                result = new Status(4, "org.eclipse.ui", 4, LaunchConfigurationsMessages.PerspectiveManager_Error_1, throwable);
                            }
                            this.done(result);
                        }
                    }
                    finally {
                        if (result == null) {
                            result = new Status(4, "org.eclipse.ui", 4, LaunchConfigurationsMessages.PerspectiveManager_Error_1, throwable);
                        }
                        this.done(result);
                    }
                }
            });
            return Job.ASYNC_FINISH;
        }

        public abstract IStatus runInUIThread(IProgressMonitor var1);
    }

    class PerspectiveContext {
        private ILaunchConfigurationType fType = null;
        private ILaunchDelegate fDelegate = null;
        private Map<Set<String>, String> fPerspectives = null;

        public PerspectiveContext(ILaunchConfigurationType type, ILaunchDelegate delegate, Set<String> modes) {
            this.fType = type;
            this.fDelegate = delegate;
            this.fPerspectives = new HashMap<Set<String>, String>();
            this.fPerspectives.put(modes, null);
        }

        public boolean equals(Object object) {
            ILaunchDelegate delegate = null;
            ILaunchConfigurationType type = null;
            if (object instanceof ILaunch) {
                try {
                    ILaunch launch = (ILaunch)object;
                    type = launch.getLaunchConfiguration().getType();
                    delegate = PerspectiveManager.this.resolveLaunchDelegate(launch);
                }
                catch (CoreException e) {
                    return false;
                }
            } else if (object instanceof PerspectiveContext) {
                PerspectiveContext context = (PerspectiveContext)object;
                type = context.getLaunchConfigurationType();
                delegate = context.getLaunchDelegate();
            }
            if (this.fType != null && type != null && this.fType.getIdentifier().equals(type.getIdentifier())) {
                if (this.fDelegate == null) {
                    return delegate == null;
                }
                return this.fDelegate.equals(delegate);
            }
            return super.equals(object);
        }

        public int hashCode() {
            if (this.fType != null) {
                int hash = this.fType.getIdentifier().hashCode();
                if (this.fDelegate != null) {
                    hash += this.fDelegate.hashCode();
                }
                return hash;
            }
            return super.hashCode();
        }

        public ILaunchConfigurationType getLaunchConfigurationType() {
            return this.fType;
        }

        public ILaunchDelegate getLaunchDelegate() {
            return this.fDelegate;
        }

        public Map<Set<String>, String> getPersepctiveMap() {
            return this.fPerspectives;
        }

        public void setPerspective(Set<String> modes, String pid) {
            if (this.fPerspectives == null) {
                this.fPerspectives = new HashMap<Set<String>, String>();
            }
            this.fPerspectives.put(modes, pid);
        }

        public String getPerspective(Set<String> modes) {
            if (this.fPerspectives != null) {
                return this.fPerspectives.get(modes);
            }
            return null;
        }
    }
}

