/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.file;

import java.io.IOException;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PcapFileEndiannessTest {
    @Test
    public void EndiannessTest() throws IOException, BadPcapFileException, BadPacketException {
        PcapPacket littleEndianPacket;
        PcapTestTrace trace = PcapTestTrace.SHORT_LITTLE_ENDIAN;
        Assume.assumeTrue((boolean)trace.exists());
        PcapFile littleEndian = trace.getTrace();
        trace = PcapTestTrace.SHORT_BIG_ENDIAN;
        Assume.assumeTrue((boolean)trace.exists());
        PcapFile bigEndian = trace.getTrace();
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)bigEndian.getByteOrder());
        Assert.assertEquals((Object)ByteOrder.LITTLE_ENDIAN, (Object)littleEndian.getByteOrder());
        do {
            littleEndianPacket = littleEndian.parseNextPacket();
            PcapPacket bigEndianPacket = bigEndian.parseNextPacket();
            Assert.assertEquals((Object)littleEndianPacket, (Object)bigEndianPacket);
        } while (littleEndianPacket != null);
    }
}

