/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.util.numbers.impl;

import org.eclipse.uomo.util.internal.Messages;
import org.eclipse.uomo.util.numbers.ISpeller;
import org.eclipse.uomo.util.numbers.SpellException;

public class IndianNumberSpeller
implements ISpeller {
    private static IndianNumberSpeller INSTANCE;
    private String string;
    private final String[] mySingleText = new String[]{"", Messages.Speller_22, Messages.Speller_23, Messages.Speller_24, Messages.Speller_25, Messages.Speller_26, Messages.Speller_27, Messages.Speller_28, Messages.Speller_29, Messages.Speller_30};
    private final String[] myTeenText = new String[]{Messages.Speller_104, Messages.Speller_106, Messages.Speller_108, Messages.Speller_110, Messages.Speller_112, Messages.Speller_114, Messages.Speller_116, Messages.Speller_118, Messages.Speller_120, Messages.Speller_122};
    private final String[] myCentText = new String[]{"Twenty", "Thirty", "Fourty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninty"};
    private final String[] myCroreText = new String[]{Messages.Speller_140, "Thousand", Messages.Speller_Lakh, Messages.Speller_Crore};

    private IndianNumberSpeller() {
    }

    public static final IndianNumberSpeller of() {
        if (INSTANCE == null) {
            INSTANCE = new IndianNumberSpeller();
        }
        return INSTANCE;
    }

    @Override
    public String spell(long number) throws SpellException {
        if (number < Integer.MIN_VALUE || number < -2147483647L || number > Integer.MAX_VALUE) {
            throw new SpellException(String.valueOf(number) + " exceeds allowed value for this algorithm.");
        }
        int numToConvert = (int)number;
        int in = 1;
        int num = -1;
        this.string = "";
        while (numToConvert != 0) {
            switch (in) {
                case 1: {
                    num = numToConvert % 100;
                    this.passString(num);
                    if (numToConvert > 100 && numToConvert % 100 != 0) {
                        this.displayOutput(Messages.Speller_7);
                    }
                    numToConvert /= 100;
                    break;
                }
                case 2: {
                    num = numToConvert % 10;
                    if (num != 0) {
                        this.displayOutput(" ");
                        this.displayOutput(this.myCroreText[0]);
                        this.displayOutput(" ");
                        this.passString(num);
                    }
                    numToConvert /= 10;
                    break;
                }
                case 3: {
                    num = numToConvert % 100;
                    if (num != 0) {
                        this.displayOutput(" ");
                        this.displayOutput(this.myCroreText[1]);
                        this.displayOutput(" ");
                        this.passString(num);
                    }
                    numToConvert /= 100;
                    break;
                }
                case 4: {
                    num = numToConvert % 100;
                    if (num != 0) {
                        this.displayOutput(" ");
                        this.displayOutput(this.myCroreText[2]);
                        this.displayOutput(" ");
                        this.passString(num);
                    }
                    numToConvert /= 100;
                    break;
                }
                case 5: {
                    num = numToConvert % 100;
                    if (num != 0) {
                        this.displayOutput(" ");
                        this.displayOutput(this.myCroreText[3]);
                        this.displayOutput(" ");
                        this.passString(num);
                    }
                    numToConvert /= 100;
                }
            }
            ++in;
        }
        return this.string.trim();
    }

    @Override
    public Long parse(String text) throws SpellException {
        return null;
    }

    private void passString(int number) {
        if (number < 10) {
            this.displayOutput(this.mySingleText[number]);
        }
        if (number > 9 && number < 20) {
            this.displayOutput(this.myTeenText[number - 10]);
        }
        if (number > 19) {
            int num = number % 10;
            if (num == 0) {
                int q = number / 10;
                this.displayOutput(this.myCentText[q - 2]);
            } else {
                int q = number / 10;
                this.displayOutput(this.mySingleText[num]);
                this.displayOutput(" ");
                this.displayOutput(this.myCentText[q - 2]);
            }
        }
    }

    private void displayOutput(String s) {
        StringBuilder sb = new StringBuilder(s);
        sb.append(this.string);
        this.string = sb.toString();
    }
}

