/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.html;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.CommandResources;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.dom.html.TableUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;

public class TableDeleteRowCommand
extends DesignerCommand {
    Element _tableEle;
    int _rowIndex;

    public TableDeleteRowCommand(IHTMLGraphicalViewer viewer, Element table, int index) {
        super(CommandResources.getString("TableDeleteRowCommand.Label.DeleteRow"), viewer);
        this._tableEle = table;
        this._rowIndex = index;
    }

    public boolean canExecute() {
        if (this._rowIndex < 0) {
            return false;
        }
        ArrayList list = new ArrayList();
        TableUtil.getTrElements(this._tableEle, list);
        int index = this._rowIndex;
        Element tr = (Element)list.get(index);
        boolean hasRowSpan = TableUtil.hasRowSpanElement(tr);
        boolean isAffectedByRowSpan = TableUtil.isAffectedByRowSpan(list, tr, index);
        if (hasRowSpan || isAffectedByRowSpan) {
            return false;
        }
        return super.canExecute();
    }

    @Override
    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._tableEle);
    }

    @Override
    protected void doExecute() {
        ArrayList list = new ArrayList();
        TableUtil.getTrElements(this._tableEle, list);
        int index = this._rowIndex;
        Element tr = (Element)list.get(index);
        tr.getParentNode().removeChild(tr);
        this.formatNode(this._tableEle);
    }
}

