/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.internal.http;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.internet.monitor.core.internal.Monitor;
import org.eclipse.wst.internet.monitor.core.internal.Trace;
import org.eclipse.wst.internet.monitor.core.internal.http.HTTPRequest;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;

public class HTTPConnection {
    protected IMonitor monitor;
    protected int req = -1;
    protected int resp = -1;
    protected List<Request> requests = new ArrayList<Request>();

    public HTTPConnection(IMonitor monitor) {
        this.monitor = monitor;
        if (Trace.PARSING) {
            Trace.trace("/parsing", "TCP/IP monitor connection opened " + monitor);
        }
    }

    public void addRequest(byte[] b, boolean isNew) {
        if (isNew) {
            ++this.req;
        }
        HTTPRequest request = (HTTPRequest)this.getRequestResponse(this.req);
        request.addToRequest(b);
    }

    public void addResponse(byte[] b, boolean isNew) {
        if (isNew) {
            ++this.resp;
        }
        HTTPRequest request = (HTTPRequest)this.getRequestResponse(this.resp);
        request.addToResponse(b);
    }

    public void addProperty(String key, Object value) {
        Request request = this.getRequestResponse(this.req);
        request.setProperty(key, value);
    }

    public Request getRequestResponse(boolean isRequest) {
        if (isRequest) {
            return this.getRequestResponse(this.req);
        }
        return this.getRequestResponse(this.resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Request getRequestResponse(int i) {
        HTTPConnection hTTPConnection = this;
        synchronized (hTTPConnection) {
            if (i >= this.requests.size()) {
                HTTPRequest request = new HTTPRequest((Monitor)this.monitor, this.monitor.getLocalPort(), this.monitor.getRemoteHost(), this.monitor.getRemotePort());
                this.requests.add(request);
                return request;
            }
            return this.requests.get(i);
        }
    }

    public void setLabel(String title, boolean isNew) {
        if (isNew) {
            ++this.req;
        }
        HTTPRequest request = (HTTPRequest)this.getRequestResponse(this.req);
        request.setName(title);
    }
}

