/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings;

public class JptResourceModelPropertyTester
extends PropertyTester {
    public static final String IS_LATEST_SUPPORTED_VERSION = "isLatestSupportedVersion";
    public static final String IS_NOT_LATEST_SUPPORTED_VERSION = "isNotLatestSupportedVersion";
    public static final String IS_GENERIC_MAPPING_FILE = "isGenericMappingFile";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof JptResourceModel) {
            return this.test((JptResourceModel)receiver, property, expectedValue);
        }
        return false;
    }

    private boolean test(JptResourceModel resourceModel, String property, Object expectedValue) {
        if (property.equals(IS_NOT_LATEST_SUPPORTED_VERSION)) {
            return !this.test(resourceModel, IS_LATEST_SUPPORTED_VERSION, expectedValue);
        }
        if (property.equals(IS_LATEST_SUPPORTED_VERSION)) {
            boolean expected = expectedValue == null ? true : (Boolean)expectedValue;
            boolean actual = this.isLatestSupportedVersion(resourceModel);
            return actual == expected;
        }
        if (property.equals(IS_GENERIC_MAPPING_FILE)) {
            boolean expected = expectedValue == null ? true : (Boolean)expectedValue;
            boolean actual = this.isGenericMappingFile(resourceModel);
            return actual == expected;
        }
        return false;
    }

    private boolean isLatestSupportedVersion(JptResourceModel resourceModel) {
        JpaProject jpaProject = this.getJpaProject(resourceModel.getFile().getProject());
        if (jpaProject == null) {
            return true;
        }
        JptResourceType resourceType = resourceModel.getResourceType();
        if (resourceType == null) {
            return true;
        }
        String latestVersion = jpaProject.getJpaPlatform().getMostRecentSupportedResourceType(resourceType.getContentType()).getVersion();
        return ObjectTools.equals((Object)resourceType.getVersion(), (Object)latestVersion);
    }

    private boolean isGenericMappingFile(JptResourceModel resourceModel) {
        JpaProject jpaProject = this.getJpaProject(resourceModel.getFile().getProject());
        if (jpaProject == null) {
            return true;
        }
        JptResourceType resourceType = resourceModel.getResourceType();
        if (resourceType == null) {
            return true;
        }
        IContentType contentType = resourceType.getContentType();
        return ObjectTools.equals((Object)contentType, (Object)XmlEntityMappings.CONTENT_TYPE);
    }

    private JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }
}

