/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

class FindExportableNodes
extends NodeTraversal.AbstractPostOrderCallback {
    static final DiagnosticType NON_GLOBAL_ERROR = DiagnosticType.error("JSC_NON_GLOBAL_ERROR", "@export only applies to symbols/properties defined in the global scope.");
    static final DiagnosticType EXPORT_ANNOTATION_NOT_ALLOWED = DiagnosticType.error("JSC_EXPORT_ANNOTATION_NOT_ALLOWED", "@export is not supported on this expression.");
    private final AbstractCompiler compiler;
    private final LinkedHashMap<String, Node> exports = new LinkedHashMap();
    private final LinkedHashSet<String> localExports = new LinkedHashSet();
    private final boolean allowLocalExports;

    FindExportableNodes(AbstractCompiler compiler, boolean allowLocalExports) {
        this.compiler = compiler;
        this.allowLocalExports = allowLocalExports;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo docInfo = n.getJSDocInfo();
        if (docInfo != null && docInfo.isExport()) {
            JSDocInfo parentInfo;
            if (parent.isAssign() && (n.isFunction() || n.isClass()) && (parentInfo = parent.getJSDocInfo()) != null && parentInfo.isExport()) {
                return;
            }
            Mode mode = null;
            String export = null;
            Node context = null;
            switch (n.getType()) {
                case 105: 
                case 158: {
                    if (!parent.isScript()) break;
                    export = NodeUtil.getName(n);
                    context = n;
                    mode = Mode.EXPORT;
                    break;
                }
                case 160: {
                    export = n.getString();
                    context = n;
                    mode = Mode.EXPORT;
                    break;
                }
                case 86: {
                    Node grandparent = parent.getParent();
                    if (!parent.isExprResult() || n.getLastChild().isAssign()) break;
                    if (grandparent != null && grandparent.isScript() && n.getFirstChild().isQualifiedName()) {
                        export = n.getFirstChild().getQualifiedName();
                        context = n;
                        mode = Mode.EXPORT;
                        break;
                    }
                    if (!this.allowLocalExports || !n.getFirstChild().isGetProp()) break;
                    Node target = n.getFirstChild();
                    export = target.getLastChild().getString();
                    mode = Mode.EXTERN;
                    break;
                }
                case 118: 
                case 149: 
                case 162: {
                    if (!parent.isScript() || !n.getFirstChild().hasChildren() || n.getFirstFirstChild().isAssign()) break;
                    export = n.getFirstChild().getString();
                    context = n;
                    mode = Mode.EXPORT;
                    break;
                }
                case 33: {
                    if (!this.allowLocalExports || !parent.isExprResult()) break;
                    mode = Mode.EXTERN;
                    export = n.getLastChild().getString();
                    mode = Mode.EXTERN;
                    break;
                }
                case 147: 
                case 148: 
                case 154: {
                    if (!this.allowLocalExports) break;
                    export = n.getString();
                    mode = Mode.EXTERN;
                }
            }
            if (export != null) {
                if (mode == Mode.EXPORT) {
                    Preconditions.checkNotNull((Object)context);
                    this.exports.put(export, context);
                } else {
                    Preconditions.checkState((context == null ? 1 : 0) != 0);
                    Preconditions.checkState((mode == Mode.EXTERN ? 1 : 0) != 0);
                    Preconditions.checkState((!export.isEmpty() ? 1 : 0) != 0);
                    this.localExports.add(export);
                }
            } else if (!n.isFunction() || !NodeUtil.isObjectLitKey(parent)) {
                if (this.allowLocalExports) {
                    this.compiler.report(t.makeError(n, EXPORT_ANNOTATION_NOT_ALLOWED, new String[0]));
                } else {
                    this.compiler.report(t.makeError(n, NON_GLOBAL_ERROR, new String[0]));
                }
            }
        }
    }

    LinkedHashMap<String, Node> getExports() {
        return this.exports;
    }

    LinkedHashSet<String> getLocalExports() {
        return this.localExports;
    }

    static enum Mode {
        EXPORT,
        EXTERN;

    }
}

