/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.reference;

import java.io.Serializable;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.predicate.IntPredicate;
import org.eclipse.jpt.common.utility.reference.IntReference;
import org.eclipse.jpt.common.utility.reference.ModifiableIntReference;

public final class SimpleIntReference
implements ModifiableIntReference,
Cloneable,
Serializable {
    private volatile int value = 0;
    private static final long serialVersionUID = 1L;

    public SimpleIntReference(int count) {
        this.value = count;
    }

    public SimpleIntReference() {
        this(0);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public boolean equals(int i) {
        return this.value == i;
    }

    @Override
    public boolean notEqual(int i) {
        return this.value != i;
    }

    @Override
    public boolean isZero() {
        return this.value == 0;
    }

    @Override
    public boolean isNotZero() {
        return this.value != 0;
    }

    @Override
    public boolean isGreaterThan(int i) {
        return this.value > i;
    }

    @Override
    public boolean isGreaterThanOrEqual(int i) {
        return this.value >= i;
    }

    @Override
    public boolean isLessThan(int i) {
        return this.value < i;
    }

    @Override
    public boolean isLessThanOrEqual(int i) {
        return this.value <= i;
    }

    @Override
    public boolean isPositive() {
        return this.value > 0;
    }

    @Override
    public boolean isNotPositive() {
        return this.value <= 0;
    }

    @Override
    public boolean isNegative() {
        return this.value < 0;
    }

    @Override
    public boolean isNotNegative() {
        return this.value >= 0;
    }

    @Override
    public boolean isMemberOf(IntPredicate predicate) {
        return predicate.evaluate(this.value);
    }

    @Override
    public boolean isNotMemberOf(IntPredicate predicate) {
        return !predicate.evaluate(this.value);
    }

    @Override
    public int setValue(int value) {
        int old = this.value;
        this.value = value;
        return old;
    }

    @Override
    public int setZero() {
        return this.setValue(0);
    }

    @Override
    public int increment() {
        return ++this.value;
    }

    @Override
    public int incrementExact() {
        this.value = Math.incrementExact(this.value);
        return this.value;
    }

    @Override
    public int decrement() {
        return --this.value;
    }

    @Override
    public int decrementExact() {
        this.value = Math.decrementExact(this.value);
        return this.value;
    }

    @Override
    public int halve() {
        this.value = BitTools.half(this.value);
        return this.value;
    }

    @Override
    public int twice() {
        this.value = BitTools.twice(this.value);
        return this.value;
    }

    @Override
    public int twiceExact() {
        this.value = Math.multiplyExact(this.value, 2);
        return this.value;
    }

    @Override
    public int abs() {
        this.value = Math.abs(this.value);
        return this.value;
    }

    @Override
    public int negate() {
        this.value = -this.value;
        return this.value;
    }

    @Override
    public int negateExact() {
        this.value = Math.negateExact(this.value);
        return this.value;
    }

    @Override
    public int add(int i) {
        this.value += i;
        return this.value;
    }

    @Override
    public int addExact(int i) {
        this.value = Math.addExact(this.value, i);
        return this.value;
    }

    @Override
    public int subtract(int i) {
        this.value -= i;
        return this.value;
    }

    @Override
    public int subtractExact(int i) {
        this.value = Math.subtractExact(this.value, i);
        return this.value;
    }

    @Override
    public int multiply(int i) {
        this.value *= i;
        return this.value;
    }

    @Override
    public int multiplyExact(int i) {
        this.value = Math.multiplyExact(this.value, i);
        return this.value;
    }

    @Override
    public int divide(int i) {
        this.value /= i;
        return this.value;
    }

    @Override
    public int floorDivide(int i) {
        this.value = Math.floorDiv(this.value, i);
        return this.value;
    }

    @Override
    public int remainder(int i) {
        this.value %= i;
        return this.value;
    }

    @Override
    public int floorRemainder(int i) {
        this.value = Math.floorMod(this.value, i);
        return this.value;
    }

    @Override
    public int min(int i) {
        this.value = Math.min(this.value, i);
        return this.value;
    }

    @Override
    public int max(int i) {
        this.value = Math.max(this.value, i);
        return this.value;
    }

    @Override
    public boolean commit(int newValue, int expectedValue) {
        if (this.value == expectedValue) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    @Override
    public int swap(ModifiableIntReference other) {
        if (other == this) {
            return this.value;
        }
        int otherValue = other.getValue();
        if (otherValue == this.value) {
            return this.value;
        }
        other.setValue(this.value);
        this.value = otherValue;
        return otherValue;
    }

    @Override
    public int compareTo(IntReference other) {
        int otherValue = other.getValue();
        return this.value < otherValue ? -1 : (this.value == otherValue ? 0 : 1);
    }

    public SimpleIntReference clone() {
        try {
            return (SimpleIntReference)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.value) + ']';
    }
}

