/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.templates;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.templates.AbstractTemplatesPage;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.xpath.ui.internal.XPathUIPlugin;
import org.eclipse.wst.xml.xpath.ui.internal.templates.TemplateContextTypeIdsXPath;
import org.eclipse.wst.xsl.ui.internal.editor.XSLEditor;
import org.eclipse.wst.xsl.ui.provisional.contentassist.CustomCompletionProposal;

public class XSLTemplatesPage
extends AbstractTemplatesPage {
    private static final String PREFERENCE_PAGE_ID = "org.eclipse.wst.xsl.ui.XPath";
    private static final TemplateStore TEMPLATE_STORE = XPathUIPlugin.getDefault().getXPathTemplateStore();
    private static final IPreferenceStore PREFERENCE_STORE = XPathUIPlugin.getDefault().getPreferenceStore();
    private static final ContextTypeRegistry TEMPLATE_CONTEXT_REGISTRY = XPathUIPlugin.getDefault().getXPathTemplateContextRegistry();
    private XSLEditor fTextEditor;

    public XSLTemplatesPage(XSLEditor xslTextEditor) {
        super((ITextEditor)xslTextEditor, (ISourceViewer)xslTextEditor.getTextViewer());
        this.fTextEditor = xslTextEditor;
    }

    protected String[] getContextTypeIds(IDocument document, int offset) {
        return new String[]{TemplateContextTypeIdsXPath.XPATH, TemplateContextTypeIdsXPath.AXIS, TemplateContextTypeIdsXPath.OPERATOR};
    }

    protected ContextTypeRegistry getContextTypeRegistry() {
        return TEMPLATE_CONTEXT_REGISTRY;
    }

    protected String getPreferencePageId() {
        return PREFERENCE_PAGE_ID;
    }

    protected IPreferenceStore getTemplatePreferenceStore() {
        return PREFERENCE_STORE;
    }

    public TemplateStore getTemplateStore() {
        return TEMPLATE_STORE;
    }

    protected void insertTemplate(Template template, IDocument document) {
        String savedText;
        StructuredTextViewer contextViewer = this.fTextEditor.getTextViewer();
        ITextSelection textSelection = (ITextSelection)contextViewer.getSelectionProvider().getSelection();
        if (!this.isValidTemplate(document, template, textSelection.getOffset(), textSelection.getLength())) {
            return;
        }
        this.beginCompoundChange((ISourceViewer)contextViewer);
        try {
            savedText = document.get(textSelection.getOffset(), textSelection.getLength());
            if (savedText.length() == 0) {
                String prefix = this.getIdentifierPart(document, template, textSelection.getOffset(), textSelection.getLength());
                if (prefix.length() > 0 && !template.getName().startsWith(prefix)) {
                    return;
                }
                if (prefix.length() > 0) {
                    contextViewer.setSelectedRange(textSelection.getOffset() - prefix.length(), prefix.length());
                    textSelection = (ITextSelection)contextViewer.getSelectionProvider().getSelection();
                }
            }
            document.replace(textSelection.getOffset(), textSelection.getLength(), template.getName().substring(0, 1));
        }
        catch (BadLocationException badLocationException) {
            this.endCompoundChange((ISourceViewer)contextViewer);
            return;
        }
        Region region = new Region(textSelection.getOffset() + 1, 0);
        contextViewer.getSelectionProvider().setSelection((ISelection)new TextSelection(textSelection.getOffset(), 1));
        DocumentTemplateContext context = this.getContext(document, template, textSelection.getOffset(), textSelection.getLength());
        context.setVariable("selection", savedText);
        if (context.getKey().length() == 0) {
            try {
                document.replace(textSelection.getOffset(), 1, savedText);
            }
            catch (BadLocationException badLocationException) {
                this.endCompoundChange((ISourceViewer)contextViewer);
                return;
            }
        }
        StructuredTextViewer viewer = this.fTextEditor.getTextViewer();
        int offset = viewer.getTextWidget().getCaretOffset();
        int startLength = offset - region.getOffset();
        String pattern = template.getPattern().replace("${cursor}", "");
        CustomCompletionProposal proposal = new CustomCompletionProposal(pattern, offset, 0, startLength + pattern.length(), this.getImage(template), template.getName(), null, null, 0);
        this.fTextEditor.getSite().getPage().activate((IWorkbenchPart)this.fTextEditor);
        proposal.apply((ITextViewer)this.fTextEditor.getTextViewer(), ' ', 0, offset);
        viewer.getTextWidget().setCaretOffset(offset + pattern.length() - 1);
        this.endCompoundChange((ISourceViewer)contextViewer);
    }

    protected boolean isValidTemplate(IDocument document, Template template, int offset, int length) {
        String[] contextIds = this.getContextTypeIds(document, offset);
        int i = 0;
        while (i < contextIds.length) {
            if (contextIds[i].equals(template.getContextTypeId())) {
                DocumentTemplateContext context = this.getContext(document, template, offset, length);
                return context.canEvaluate(template);
            }
            ++i;
        }
        return false;
    }

    private void endCompoundChange(ISourceViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)viewer).getRewriteTarget().endCompoundChange();
        }
    }

    private void beginCompoundChange(ISourceViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)viewer).getRewriteTarget().beginCompoundChange();
        }
    }

    private DocumentTemplateContext getContext(IDocument document, Template template, int offset, int length) {
        TemplateContextType contextType = XPathUIPlugin.getDefault().getXPathTemplateContextRegistry().getContextType(template.getContextTypeId());
        return new DocumentTemplateContext(contextType, document, offset, length);
    }

    private String getIdentifierPart(IDocument document, Template template, int offset, int length) throws BadLocationException {
        return this.getContext(document, template, offset, length).getKey();
    }
}

