/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.jsp;

import java.util.List;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.base.ELAssert;
import org.eclipse.jst.jsf.validation.el.tests.base.SingleJSPTestCase;

public class ArithmeticMinusTestCase
extends SingleJSPTestCase {
    public ArithmeticMinusTestCase() {
        super("/testdata/jsps/arithmeticMinus.jsp.data", "/WEB-INF/arithmeticMinus.jsp", JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void testSanity() {
        super.testSanity();
        ArithmeticMinusTestCase.assertEquals((String)"myBean.integerProperty - 3", (String)ELAssert.getELText(this._structuredDocument, 828));
        ArithmeticMinusTestCase.assertEquals((String)"myBean.stringProperty - 3", (String)ELAssert.getELText(this._structuredDocument, 887));
        ArithmeticMinusTestCase.assertEquals((String)"myBean.integerProperty - myBean.integerProperty", (String)ELAssert.getELText(this._structuredDocument, 945));
        ArithmeticMinusTestCase.assertEquals((String)"myBean.bigIntegerProperty - 4", (String)ELAssert.getELText(this._structuredDocument, 1025));
        ArithmeticMinusTestCase.assertEquals((String)"myBean.bigIntegerProperty - 5.5", (String)ELAssert.getELText(this._structuredDocument, 1087));
        ArithmeticMinusTestCase.assertEquals((String)"myBean.bigDoubleProperty - 5.5", (String)ELAssert.getELText(this._structuredDocument, 1151));
        ArithmeticMinusTestCase.assertEquals((String)"myBean.doubleProperty - 5", (String)ELAssert.getELText(this._structuredDocument, 1214));
        ArithmeticMinusTestCase.assertEquals((String)"5 - 3", (String)ELAssert.getELText(this._structuredDocument, 1302));
        ArithmeticMinusTestCase.assertEquals((String)"5.5 - 4", (String)ELAssert.getELText(this._structuredDocument, 1337));
        ArithmeticMinusTestCase.assertEquals((String)"5.5 - null", (String)ELAssert.getELText(this._structuredDocument, 1374));
        ArithmeticMinusTestCase.assertEquals((String)"'5' - '4'", (String)ELAssert.getELText(this._structuredDocument, 1417));
        ArithmeticMinusTestCase.assertEquals((String)"null - null", (String)ELAssert.getELText(this._structuredDocument, 1459));
        ArithmeticMinusTestCase.assertEquals((String)"5.5 - 3.5", (String)ELAssert.getELText(this._structuredDocument, 1504));
        ArithmeticMinusTestCase.assertEquals((String)"5 - true", (String)ELAssert.getELText(this._structuredDocument, 1564));
        ArithmeticMinusTestCase.assertEquals((String)"myBean.integerProperty - myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 1602));
        ArithmeticMinusTestCase.assertEquals((String)"myBean.stringArrayProperty - myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 1679));
        ArithmeticMinusTestCase.assertEquals((String)"myBean.integerProperty - true ", (String)ELAssert.getELText(this._structuredDocument, 1763));
        ArithmeticMinusTestCase.assertEquals((String)"'a' - 'b'", (String)ELAssert.getELText(this._structuredDocument, 1826));
        ArithmeticMinusTestCase.assertEquals((String)"myBean.bigIntegerProperty - true", (String)ELAssert.getELText(this._structuredDocument, 1868));
    }

    @Override
    public void testNoErrorExprs() {
        this.assertNoError(828, "J");
        this.assertNoError(887, "J");
        this.assertNoError(945, "J");
        this.assertNoError(1025, "Ljava.math.BigInteger;");
        this.assertNoError(1087, "Ljava.math.BigDecimal;");
        this.assertNoError(1151, "Ljava.math.BigDecimal;");
        this.assertNoError(1214, "D");
    }

    @Override
    public void testWarningExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticWarning(1302, "J", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1337, "D", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1374, "D", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1417, "J", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1459, "J", 1);
        ELAssert.assertContainsProblem(list, 0);
        list = this.assertSemanticWarning(1504, "D", 1);
        ELAssert.assertContainsProblem(list, 3);
    }

    @Override
    public void testErrorExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticError(1564, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1602, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1679, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1763, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1826, null, 1);
        ELAssert.assertContainsProblem(list, 9);
        list = this.assertSemanticError(1868, null, 1);
        ELAssert.assertContainsProblem(list, 2);
    }
}

