"use strict";
/// <reference types="@volar/typescript" />
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createVueLanguageServicePlugins = createVueLanguageServicePlugins;
__exportStar(require("@volar/language-service"), exports);
// for @vue/language-server usage
__exportStar(require("@volar/language-service/lib/utils/featureWorkers"), exports);
const volar_service_emmet_1 = require("volar-service-emmet");
const volar_service_json_1 = require("volar-service-json");
const volar_service_pug_beautify_1 = require("volar-service-pug-beautify");
const docCommentTemplate_1 = require("volar-service-typescript/lib/plugins/docCommentTemplate");
const syntactic_1 = require("volar-service-typescript/lib/plugins/syntactic");
const css_1 = require("./lib/plugins/css");
const typescript_semantic_tokens_1 = require("./lib/plugins/typescript-semantic-tokens");
const vue_autoinsert_dotvalue_1 = require("./lib/plugins/vue-autoinsert-dotvalue");
const vue_autoinsert_space_1 = require("./lib/plugins/vue-autoinsert-space");
const vue_compiler_dom_errors_1 = require("./lib/plugins/vue-compiler-dom-errors");
const vue_component_semantic_tokens_1 = require("./lib/plugins/vue-component-semantic-tokens");
const vue_directive_comments_1 = require("./lib/plugins/vue-directive-comments");
const vue_document_drop_1 = require("./lib/plugins/vue-document-drop");
const vue_document_highlights_1 = require("./lib/plugins/vue-document-highlights");
const vue_extract_file_1 = require("./lib/plugins/vue-extract-file");
const vue_global_types_error_1 = require("./lib/plugins/vue-global-types-error");
const vue_inlayhints_1 = require("./lib/plugins/vue-inlayhints");
const vue_missing_props_hints_1 = require("./lib/plugins/vue-missing-props-hints");
const vue_scoped_class_links_1 = require("./lib/plugins/vue-scoped-class-links");
const vue_sfc_1 = require("./lib/plugins/vue-sfc");
const vue_suggest_define_assignment_1 = require("./lib/plugins/vue-suggest-define-assignment");
const vue_template_1 = require("./lib/plugins/vue-template");
const vue_template_ref_links_1 = require("./lib/plugins/vue-template-ref-links");
const vue_twoslash_queries_1 = require("./lib/plugins/vue-twoslash-queries");
const noop = () => { };
function createVueLanguageServicePlugins(ts, client = new Proxy({}, {
    get() {
        return noop;
    },
})) {
    return [
        (0, volar_service_json_1.create)(),
        (0, volar_service_pug_beautify_1.create)(),
        (0, vue_autoinsert_space_1.create)(),
        (0, vue_compiler_dom_errors_1.create)(),
        (0, vue_directive_comments_1.create)(),
        (0, vue_global_types_error_1.create)(),
        (0, vue_scoped_class_links_1.create)(),
        (0, vue_sfc_1.create)(),
        (0, vue_suggest_define_assignment_1.create)(),
        (0, vue_template_ref_links_1.create)(),
        (0, volar_service_emmet_1.create)({
            mappedLanguages: {
                'vue-root-tags': 'html',
                'postcss': 'scss',
            },
        }),
        // TS related plugins
        (0, docCommentTemplate_1.create)(ts),
        (0, syntactic_1.create)(ts),
        (0, vue_inlayhints_1.create)(ts),
        // type aware plugins
        (0, css_1.create)(client),
        (0, typescript_semantic_tokens_1.create)(client),
        (0, vue_autoinsert_dotvalue_1.create)(ts, client),
        (0, vue_component_semantic_tokens_1.create)(client),
        (0, vue_document_drop_1.create)(ts, client),
        (0, vue_document_highlights_1.create)(client),
        (0, vue_extract_file_1.create)(ts, client),
        (0, vue_missing_props_hints_1.create)(client),
        (0, vue_template_1.create)('html', client),
        (0, vue_template_1.create)('jade', client),
        (0, vue_twoslash_queries_1.create)(client),
    ];
}
//# sourceMappingURL=index.js.map