/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.snowflake.ui;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ext.snowflake.ui.internal.SnowflakeMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class SnowflakeConnectionPageAdvanced
extends ConnectionPageAbstract {
    private Combo sqlDollarQuoteBehaviorCombo;

    public SnowflakeConnectionPageAdvanced() {
        this.setTitle("Snowflake");
    }

    public void createControl(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        Group sqlGroup = new Group(group, 0);
        sqlGroup.setText(SnowflakeMessages.dialog_setting_sql);
        sqlGroup.setLayoutData((Object)new GridData(32));
        sqlGroup.setLayout((Layout)new GridLayout(2, false));
        this.sqlDollarQuoteBehaviorCombo = UIUtils.createLabelCombo((Composite)sqlGroup, (String)SnowflakeMessages.dialog_setting_sql_dd_label, (int)12);
        this.sqlDollarQuoteBehaviorCombo.add(SnowflakeMessages.dialog_setting_sql_dd_string);
        this.sqlDollarQuoteBehaviorCombo.add(SnowflakeMessages.dialog_setting_sql_dd_code_block);
        this.setControl((Control)group);
        this.loadSettings();
    }

    public void loadSettings() {
        DBPConnectionConfiguration config = this.getSite().getActiveDataSource().getConnectionConfiguration();
        DBPPreferenceStore store = this.getSite().getActiveDataSource().getPreferenceStore();
        boolean useDollarQuote = CommonUtils.getBoolean((String)config.getProviderProperty("ddString"), (boolean)store.getBoolean("ddString"));
        this.sqlDollarQuoteBehaviorCombo.select(useDollarQuote ? 0 : 1);
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        dataSource.getConnectionConfiguration().setProviderProperty("ddString", CommonUtils.toString((Object)(this.sqlDollarQuoteBehaviorCombo.getSelectionIndex() == 0 ? 1 : 0)));
    }

    public boolean isComplete() {
        return true;
    }
}

