#ifndef main_data_h
#define main_data_h

#include <gtk/gtk.h>

#include <map>
#include <string>
#include <vector>

enum CommonEncoderType
{
    NO_TYPE = -1,
    CD,
    WAV,
    MP3,
    OGG,
    FLAC,
    MP2,
    MUSE,
    OPUS,
};

struct EncoderTypeConfig
{
    std::string name;
    std::string extension;
};

const std::map<CommonEncoderType, EncoderTypeConfig> encoder_type_config_map =
{
    {NO_TYPE, EncoderTypeConfig{"Loading",  ""}},
    {CD,      EncoderTypeConfig{"CD",       ""}},
    {WAV,     EncoderTypeConfig{"WAV",      ".wav"}},
    {MP3,     EncoderTypeConfig{"MP3",      ".mp3"}},
    {OGG,     EncoderTypeConfig{"OGG",      ".ogg"}},
    {FLAC,    EncoderTypeConfig{"FLAC",     ".flac"}},
    {MP2,     EncoderTypeConfig{"MP2",      ".mp2"}},
    {MUSE,    EncoderTypeConfig{"Musepack", ".mpc"}},
    {OPUS,    EncoderTypeConfig{"Opus",     ".opus"}},
};

struct EncodingFiles
{
	CommonEncoderType type;
    int encoded_file_exist;
};

class MainData
{
    /**
     * Main data structure
     * All length is in cd sector unit
     **/
    public:
        enum Lengths
        {
            MAX_ARTIST_LENGTH = 50,        //1024,
            MAX_YEAR_LENGTH = 50,
            MAX_ALBUMARTIST_LENGTH = 50,    //1024,
        };

        int total_length;
        std::string disc_artist;
        std::string disc_title;
        std::string disc_year;
        std::string disc_category;

        struct Track
        {
            Track() : title(""), artist(""), begin(0), length(0), make_wav(0), wav_exist(0),
                make_encoding(0), current_type(NO_TYPE), current_file(0) {}
            std::string title;
            std::string artist;
            unsigned begin;
            unsigned length;
            int make_wav;
            int wav_exist;
            int make_encoding;
            CommonEncoderType current_type;
            int current_file;

	        std::vector<EncodingFiles> encoding_files;
        };
        std::vector<Track> track;

        int find_next_job(int cur_track, CommonEncoderType cur_type,
		int *next_track, CommonEncoderType *next_type) const;
        void finish_job();
  
        MainData()
        {
            Clear();
        };
  
        void Clear();
        void Dump();

        void add_track(const Track& t)
        {
            track.push_back(t);
        };
  
        Track &back_track ()
        {
            return track[num_tracks() - 1];
        };

        int num_tracks() const
        {
            return track.size();
        }
 };

#endif
