/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinConstructorStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinSecondaryConstructorStubImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0011\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00032\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00122\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtSecondaryConstructorElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinSecondaryConstructorStubImpl;", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "debugName", "", "<init>", "(Ljava/lang/String;)V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "psi-impl"})
public final class KtSecondaryConstructorElementType
extends KtStubElementType<KotlinSecondaryConstructorStubImpl, KtSecondaryConstructor> {
    public KtSecondaryConstructorElementType(@NonNls @NotNull String debugName) {
        Intrinsics.checkNotNullParameter(debugName, "debugName");
        super(debugName, KtSecondaryConstructor.class, KotlinConstructorStub.class);
    }

    @Override
    @NotNull
    public KotlinSecondaryConstructorStubImpl createStub(@NotNull KtSecondaryConstructor psi, @NotNull StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter(psi, "psi");
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        boolean hasBody = psi.hasBody();
        KtConstructorDelegationCall ktConstructorDelegationCall = psi.getDelegationCallOrNull();
        boolean isDelegatedCallToThis = ktConstructorDelegationCall != null ? ktConstructorDelegationCall.isCallToThis() : true;
        KtConstructorDelegationCall ktConstructorDelegationCall2 = psi.getDelegationCallOrNull();
        boolean isExplicitDelegationCall = ktConstructorDelegationCall2 != null ? !ktConstructorDelegationCall2.isImplicit() : false;
        boolean mayHaveContract = KtPsiUtilKt.isLegacyContractPresentPsiCheck(psi);
        return new KotlinSecondaryConstructorStubImpl(parentStub, StringRef.fromString(psi.getName()), hasBody, isDelegatedCallToThis, isExplicitDelegationCall, mayHaveContract);
    }

    @Override
    public void serialize(@NotNull KotlinSecondaryConstructorStubImpl stub, @NotNull StubOutputStream dataStream) throws IOException {
        Intrinsics.checkNotNullParameter(stub, "stub");
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.getHasBody());
        dataStream.writeBoolean(stub.isDelegatedCallToThis());
        dataStream.writeBoolean(stub.isExplicitDelegationCall());
        dataStream.writeBoolean(stub.getMayHaveContract());
    }

    @Override
    @NotNull
    public KotlinSecondaryConstructorStubImpl deserialize(@NotNull StubInputStream dataStream, @NotNull StubElement<?> parentStub) throws IOException {
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        StringRef name2 = dataStream.readName();
        boolean hasBody = dataStream.readBoolean();
        boolean isDelegatedCallToThis = dataStream.readBoolean();
        boolean isExplicitDelegationCall = dataStream.readBoolean();
        boolean mayHaveContract = dataStream.readBoolean();
        return new KotlinSecondaryConstructorStubImpl(parentStub, name2, hasBody, isDelegatedCallToThis, isExplicitDelegationCall, mayHaveContract);
    }
}

