// RUN: rm -rf %t && mkdir -p %t
// RUN: clang-doc --extra-arg -std=c++20 --output=%t --format=html --executor=standalone %s
// RUN: FileCheck %s < %t/json/GlobalNamespace/index.json

// Requires that T suports post and pre-incrementing.
template<typename T>
concept Incrementable = requires(T x) {
  ++x;
  x++;
};

// CHECK:       {
// CHECK-NEXT:    "Concepts": [
// CHECK-NEXT:      {
// CHECK-NEXT:        "ConstraintExpression": "requires (T x) { ++x; x++; }",
// CHECK-NEXT:        "Description": {
// CHECK-NEXT:        "HasParagraphComments": true,
// CHECK-NEXT:        "ParagraphComments": [
// CHECK-NEXT:          [
// CHECK-NEXT:            {
// CHECK-NEXT:              "TextComment": " Requires that T suports post and pre-incrementing."
// CHECK:             "End": true,
// CHECK-NEXT:        "InfoType": "concept",
// CHECK-NEXT:        "IsType": true,
// CHECK-NEXT:        "Location": {
// CHECK-NEXT:          "Filename": "{{.*}}concept.cpp",
// CHECK-NEXT:          "LineNumber": 6
// CHECK-NEXT:        },
// CHECK-NEXT:        "Name": "Incrementable",
// CHECK-NEXT:        "Template": {
// CHECK-NEXT:          "Parameters": [
// CHECK-NEXT:            {
// CHECK-NEXT:              "End": true,
// CHECK-NEXT:              "Param": "typename T"
// CHECK-NEXT:            }
// CHECK-NEXT:          ]
// CHECK-NEXT:        "VerticalDisplay": false
// CHECK-NEXT:        },
// CHECK-NEXT:        "USR": "{{[0-9A-F]*}}"
// CHECK-NEXT:      }
// CHECK-NEXT:    ],
// CHECK:        "Name": "Global Namespace",
// CHECK:        "USR": "0000000000000000000000000000000000000000"
// CHECK:      }
