// RUN: %check_clang_tidy -std=c++20 %s modernize-use-ranges %t -check-suffixes=,PIPE \
// RUN:   -config="{CheckOptions: { \
// RUN:     modernize-use-ranges.UseReversePipe: true }}" -- -isystem %clang_tidy_headers -I %S/Inputs/use-ranges/
// RUN: %check_clang_tidy -std=c++20 %s modernize-use-ranges %t -check-suffixes=,NOPIPE  -- -isystem %clang_tidy_headers -I %S/Inputs/use-ranges/

// CHECK-FIXES: #include <algorithm>
// CHECK-FIXES: #include <ranges>

#include "fake_std.h"

void stdLib() {
  std::vector<int> I;
  std::find(I.rbegin(), I.rend(), 0);
  // CHECK-MESSAGES: :[[@LINE-1]]:3: warning: use a ranges version of this algorithm
  // CHECK-FIXES-NOPIPE: std::ranges::find(std::views::reverse(I), 0);
  // CHECK-FIXES-PIPE: std::ranges::find(I | std::views::reverse, 0);
}
