// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --filter "define" --version 6
// Check that we appropriately annotate destructors with a dead_on_return
// attribute.
//
// RUN: %clang_cc1 -triple x86_64-unknown-linux-gnu -emit-llvm %s -o - | FileCheck %s
// RUN: %clang_cc1 -triple x86_64-unknown-linux-gnu -fno-lifetime-dse -emit-llvm %s -o - | FileCheck %s --check-prefix NO-LIFETIME-DSE

void opaque();
void opaque(char*);

class Foo {
public:
  ~Foo();

private:
  char FooVar[4];
};

// CHECK-LABEL: define dso_local void @_ZN3FooD1Ev(
// CHECK-SAME: ptr noundef nonnull align 1 dead_on_return(4) dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR0:[0-9]+]] align 2 {
// NO-LIFETIME-DSE-LABEL: define dso_local void @_ZN3FooD1Ev(
// NO-LIFETIME-DSE-SAME: ptr noundef nonnull align 1 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR0:[0-9]+]] align 2 {
Foo::~Foo() {
  opaque(FooVar);
}

class Bar {
public:
  ~Bar();

private:
  char BarVar[8];
};

// CHECK-LABEL: define dso_local void @_ZN3BarD1Ev(
// CHECK-SAME: ptr noundef nonnull align 1 dead_on_return(8) dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR0:[0-9]+]] align 2 {
// NO-LIFETIME-DSE-LABEL: define dso_local void @_ZN3BarD1Ev(
// NO-LIFETIME-DSE-SAME: ptr noundef nonnull align 1 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR0:[0-9]+]] align 2 {
Bar::~Bar() {
  opaque(BarVar);
}

class BarInheritsFoo : public Foo {
public:
  ~BarInheritsFoo();

private:
  char BarVar[12];
};

// CHECK-LABEL: define dso_local void @_ZN14BarInheritsFooD1Ev(
// CHECK-SAME: ptr noundef nonnull align 1 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR0:[0-9]+]] align 2 {
// NO-LIFETIME-DSE-LABEL: define dso_local void @_ZN14BarInheritsFooD1Ev(
// NO-LIFETIME-DSE-SAME: ptr noundef nonnull align 1 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR0:[0-9]+]] align 2 {
BarInheritsFoo::~BarInheritsFoo() {
  opaque(BarVar);
}

class BarVirtualInheritsFoo : public virtual Foo {
public:
  ~BarVirtualInheritsFoo();

private:
  char BarVar[16];
};

// CHECK-LABEL: define dso_local void @_ZN21BarVirtualInheritsFooD1Ev(
// CHECK-SAME: ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR0:[0-9]+]] align 2 {
// NO-LIFETIME-DSE-LABEL: define dso_local void @_ZN21BarVirtualInheritsFooD1Ev(
// NO-LIFETIME-DSE-SAME: ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR0:[0-9]+]] align 2 {
BarVirtualInheritsFoo::~BarVirtualInheritsFoo() {
  opaque(BarVar);
}

class Empty {
public:
  ~Empty();
};

// CHECK-LABEL: define dso_local void @_ZN5EmptyD1Ev(
// CHECK-SAME: ptr noundef nonnull align 1 dereferenceable(1) [[THIS:%.*]]) unnamed_addr #[[ATTR0:[0-9]+]] align 2 {
// NO-LIFETIME-DSE-LABEL: define dso_local void @_ZN5EmptyD1Ev(
// NO-LIFETIME-DSE-SAME: ptr noundef nonnull align 1 dereferenceable(1) [[THIS:%.*]]) unnamed_addr #[[ATTR0:[0-9]+]] align 2 {
Empty::~Empty() {
  opaque();
}
