# 新コメント扱い仕様ドラフト：矛盾解消と実装可否の検討報告

`draft/new_comment_treatment.md` について、矛盾点の解消状況・残存する曖昧点・実装に必要な判断を整理し、実装に取り組めるかどうかの結論を報告する。

---

## 1. 矛盾点の解消状況

### 1.1 解消済みと判断できる点

| 論点 | 解消内容 |
|------|----------|
| **[1] と [7] の扱い** | 「連続する dangling の最後以外は空の要素グループ」に統一。[1] を「次のグループに紐づく」としていた記述をやめ、[1] も空の要素グループに紐づくとした。ファイル先頭の「最後の」コメントグループ（例の [2]）のみが次の key-value グループに紐づく。 |
| **テーブル間の dangling（[9][22][25][26] 等）** | 「直前の key/value やテーブルに属する」ではなく、**そのスコープの空の要素グループに対する dangling** に統一。ルートの空のグループ、[[item]] の空のグループとして [1][7] と同様のルールで一貫。 |
| **ディレクティブ名** | 例をすべて `format.rules.table-keys-order.disabled = true` / `= "ascending"` に統一。`format.disabled` の誤記は解消。 |
| **グループに作用するディレクティブの書き方** | グループに作用させるディレクティブは **dangling** とし、**直後に空行**を入れる旨を明記。leading のみでグループに効かせる書き方を排除。 |
| **ソート優先順位とグループ** | Comment Directives > JSON Schema を明記し、グループにディレクティブが無い場合のみ Schema を適用。schema とグループ分割の整合は「優先順位で解決」として矛盾はない。 |

### 1.2 内部整合性の確認

- **dangling の判定**: 「前ノードとの間に空行が無い → 前のグループ」「空行あり → 次のグループ」と「連続する dangling の最後以外は空の要素グループ」が両立している。総合例の [1]～[35] の紐付けと説明はこのルールと一致している。
- **空の要素グループ**: ファイル先頭・キー間・テーブル間・配列内・[[item]] 末尾など、key-value が存在しない区間のコメントをすべて「空の要素グループに対する dangling」として扱う方針で統一されている。
- **フォーマット出力**: Separator は AST で n を保持し、フォーマッタでは 0 または 1 に圧縮。代替案 B（空行数を捨てる）は非推奨としており、仕様と矛盾しない。

---

## 2. 判断結果（仕様ドラフトに反映済み）

以下は実装前に決めるべきものとして挙げていたが、**判断を確定し** `new_comment_treatment.md` に反映した。

| # | 項目 | 判断結果 |
|---|------|----------|
| 1 | **「空行」の定義** | **二つ以上の LINE_BREAK が連続したもの（Whitespace は除く）** とする。ドラフトの「用語」に追加済み。 |
| 2 | **境界判定の「ノード」** | **key-value、テーブルヘッダ（`[table]` / `[[array of tables]]`）、配列要素** とする。ドラフトの「用語」に明示済み。 |
| 3 | **同一グループで先頭・末尾の両方にディレクティブ** | 同一コメントグループを集めた上で JSON Schema を用いて**重複キーの警告**を出す実装がすでにあるため、**それを継続**する。新たな優先順位規定はしない。ドラフト §6 に追記済み。 |
| 4 | **ファイル先頭の 1 グループ目・ドキュメントディレクティブ** | 現状どおり [1] を「空の要素グループ」に寄せる。**ファイル先頭の 1 グループも空のグループと解釈する**。ただし **ドキュメントレベルのコメントディレクティブ（`#:schema`, `#:tombi`）は先頭のコメントグループでしか定義できない** という制限は継続。ドラフトに明記済み。 |

---

## 3. 実装に必要な前提・判断

### 3.1 パーサ・AST

- **Separator の導入**: 空行を「捨てる」のではなく、`Separator(n)`（または同等の境界ノード）として AST に保持する必要がある。現行パーサの変更範囲は大きい。
- **既存の comment attachment**: 現行の `group_comments`（連続 LINE_BREAK でグループ化）は、本仕様の「空行で区切られた dangling グループ」と概念的に一致する。Separator を導入したうえで、コメントの紐付けを「前/次のノードとの間に Separator があるか」で決める形に拡張する必要がある。

### 3.2 フォーマッタ・エディタ

- **ソート単位**: 現在はテーブル単位で `key_values` をまとめてソートしている。グループ境界（Separator で区切られた区間）を渡し、**グループ内のみ**ソートするように変更する必要がある。
- **配列・inline table**: 配列要素間の空行を Separator として扱うか、既存の comment 構造をどう拡張するかは、パーサと相談になる。inline table は 1 行のためグループは 1 つのみで、現行の trailing/leading のまま扱える。

### 3.3 段階実装の可否

- **まずルートと [table] のみ**: Separator とグループ内ソートをルート・通常テーブルにだけ導入し、配列・array of tables は後回しにすることは可能。ドラフトの「スコープ: テーブル以外のソート対象」は提案レベルであり、実装順序を分けても矛盾はない。
- **既存挙動との非互換**: 現行は「key 間の空行で区切られた dangling を leading にマージし空行を削除」している。本仕様では空行を保持し、dangling はグループ先頭/末尾や空の要素グループに紐づく。**同じ入力で出力が変わる**ため、変更内容を CHANGELOG や migration で明示する必要がある。

---

## 4. 結論：設計・実装に取り組めるか

### 4.1 結論

**矛盾点は解消済みであり、空行の定義・境界ノード・同一グループのディレクティブ・ファイル先頭とドキュメントディレクティブの扱いについて判断を確定し仕様ドラフトに反映した。**  
したがって **設計に改めて取り組むことができ、実装に着手してよい**。

- 上記「2. 判断結果」の 1～4 はすべて `new_comment_treatment.md` に追記済みであり、実装前に決めるべき曖昧点は解消されている。
- 実装は**段階的に**行うことを推奨する（まずルートと [table] の Separator・グループ内ソート・コメント紐付け。配列・array of tables は後からでもよい）。
- 既存挙動との非互換（空行保持・dangling の紐付け変更）については、CHANGELOG や必要に応じた migration・設定オプションの検討を推奨する。

### 4.2 矛盾が解消されていると判断した理由

- **[1] と [7]**: どちらも「空の要素グループに対する dangling」として扱うルールに統一。ファイル先頭の 1 グループも空のグループと解釈し、最後のコメントグループのみ次の key-value に紐づく。
- **テーブル間の dangling**: key-value が存在しない区間はすべてそのスコープの空の要素グループに統一。
- **ディレクティブとグループ**: グループに作用させるディレクティブは dangling で直後に空行。同一グループで先頭・末尾の両方にディレクティブがある場合は既存の「同一コメントグループ + JSON Schema による重複キー警告」を継続。
- **ドキュメントディレクティブ**: `#:schema`, `#:tombi` は先頭のコメントグループでしか定義できない制限を継続と明記。

### 4.3 設計・実装に取り組める状態

仕様ドラフトは、空行の定義・境界判定のノード・同一グループのディレクティブ扱い・ファイル先頭とドキュメントディレクティブの制限をすべて明文化した。**設計に改めて取り組むことができ、実装に着手してよい水準にある。**
