#ifndef OPJ_CONFIG_H_INCLUDED
#define OPJ_CONFIG_H_INCLUDED

/* create opj_config.h for CMake */

/*--------------------------------------------------------------------------*/
/* OpenJPEG Versioning                                                      */

/* Version number. */
#define OPJ_VERSION_MAJOR 2
#define OPJ_VERSION_MINOR 5
#define OPJ_VERSION_BUILD 3

/* I think we always want to rename OPJ symbols, if we are building
 * this lib locally. Just in case there is some strange case where
 * we don't want to, give us a mechanism to stop this. */
#ifndef DONT_OPJ_RENAME_SYMBOLS
#define OPJ_RENAME_SYMBOLS
#endif

#ifdef OPJ_RENAME_SYMBOLS
#define j2k_destroy_cstr_index fz_opj_j2k_destroy_cstr_index
#define j2k_dump fz_opj_j2k_dump
#define j2k_dump_image_comp_header fz_opj_j2k_dump_image_comp_header
#define j2k_dump_image_header fz_opj_j2k_dump_image_header
#define j2k_get_cstr_index fz_opj_j2k_get_cstr_index
#define j2k_get_cstr_info fz_opj_j2k_get_cstr_info
#define jp2_dump fz_opj_jp2_dump
#define jp2_get_cstr_index fz_opj_jp2_get_cstr_index
#define jp2_get_cstr_info fz_opj_jp2_get_cstr_info
#define opj_aligned_32_malloc fz_opj_aligned_32_malloc
#define opj_aligned_free fz_opj_aligned_free
#define opj_aligned_malloc fz_opj_aligned_malloc
#define opj_aligned_malloc_n fz_opj_aligned_malloc_n
#define opj_alloc_tile_component_data fz_opj_alloc_tile_component_data
#define opj_bio_bytein fz_opj_bio_bytein
#define opj_bio_byteout fz_opj_bio_byteout
#define opj_bio_create fz_opj_bio_create
#define opj_bio_destroy fz_opj_bio_destroy
#define opj_bio_flush fz_opj_bio_flush
#define opj_bio_getbit fz_opj_bio_getbit
#define opj_bio_inalign fz_opj_bio_inalign
#define opj_bio_init_dec fz_opj_bio_init_dec
#define opj_bio_init_enc fz_opj_bio_init_enc
#define opj_bio_numbytes fz_opj_bio_numbytes
#define opj_bio_putbit fz_opj_bio_putbit
#define opj_bio_read fz_opj_bio_read
#define opj_bio_write fz_opj_bio_write
#define opj_calculate_norms fz_opj_calculate_norms
#define opj_calloc fz_opj_calloc
#define opj_close_from_file fz_opj_close_from_file
#define opj_codec_set_threads fz_opj_codec_set_threads
#define opj_cond_create fz_opj_cond_create
#define opj_cond_destroy fz_opj_cond_destroy
#define opj_cond_signal fz_opj_cond_signal
#define opj_cond_wait fz_opj_cond_wait
#define opj_copy_image_header fz_opj_copy_image_header
#define opj_create_compress fz_opj_create_compress
#define opj_create_decompress fz_opj_create_decompress
#define opj_decode fz_opj_decode
#define opj_decode_tile_data fz_opj_decode_tile_data
#define opj_decoder_set_strict_mode fz_opj_decoder_set_strict_mode
#define opj_default_callback fz_opj_default_callback
#define opj_destroy_codec fz_opj_destroy_codec
#define opj_destroy_cstr_index fz_opj_destroy_cstr_index
#define opj_destroy_cstr_info fz_opj_destroy_cstr_info
#define opj_dump_codec fz_opj_dump_codec
#define opj_dwt97_decode_h_func fz_opj_dwt97_decode_h_func
#define opj_dwt97_decode_v_func fz_opj_dwt97_decode_v_func
#define opj_dwt_calc_explicit_stepsizes fz_opj_dwt_calc_explicit_stepsizes
#define opj_dwt_decode fz_opj_dwt_decode
#define opj_dwt_decode_h_func fz_opj_dwt_decode_h_func
#define opj_dwt_decode_partial_1 fz_opj_dwt_decode_partial_1
#define opj_dwt_decode_partial_1_parallel fz_opj_dwt_decode_partial_1_parallel
#define opj_dwt_decode_partial_97 fz_opj_dwt_decode_partial_97
#define opj_dwt_decode_partial_tile fz_opj_dwt_decode_partial_tile
#define opj_dwt_decode_real fz_opj_dwt_decode_real
#define opj_dwt_decode_tile fz_opj_dwt_decode_tile
#define opj_dwt_decode_tile_97 fz_opj_dwt_decode_tile_97
#define opj_dwt_decode_v_func fz_opj_dwt_decode_v_func
#define opj_dwt_deinterleave_h fz_opj_dwt_deinterleave_h
#define opj_dwt_deinterleave_v_cols fz_opj_dwt_deinterleave_v_cols
#define opj_dwt_encode fz_opj_dwt_encode
#define opj_dwt_encode_1_real fz_opj_dwt_encode_1_real
#define opj_dwt_encode_and_deinterleave_h_one_row fz_opj_dwt_encode_and_deinterleave_h_one_row
#define opj_dwt_encode_and_deinterleave_h_one_row_real fz_opj_dwt_encode_and_deinterleave_h_one_row_real
#define opj_dwt_encode_and_deinterleave_v fz_opj_dwt_encode_and_deinterleave_v
#define opj_dwt_encode_and_deinterleave_v_real fz_opj_dwt_encode_and_deinterleave_v_real
#define opj_dwt_encode_h_func fz_opj_dwt_encode_h_func
#define opj_dwt_encode_procedure fz_opj_dwt_encode_procedure
#define opj_dwt_encode_real fz_opj_dwt_encode_real
#define opj_dwt_encode_step1_combined fz_opj_dwt_encode_step1_combined
#define opj_dwt_encode_step2 fz_opj_dwt_encode_step2
#define opj_dwt_encode_stepsize fz_opj_dwt_encode_stepsize
#define opj_dwt_encode_v_func fz_opj_dwt_encode_v_func
#define opj_dwt_fetch_cols_vertical_pass fz_opj_dwt_fetch_cols_vertical_pass
#define opj_dwt_get_band_coordinates fz_opj_dwt_get_band_coordinates
#define opj_dwt_getnorm fz_opj_dwt_getnorm
#define opj_dwt_getnorm_real fz_opj_dwt_getnorm_real
#define opj_dwt_init_sparse_array fz_opj_dwt_init_sparse_array
#define opj_dwt_interleave_partial_h fz_opj_dwt_interleave_partial_h
#define opj_dwt_interleave_partial_v fz_opj_dwt_interleave_partial_v
#define opj_dwt_max_resolution fz_opj_dwt_max_resolution
#define opj_dwt_segment_grow fz_opj_dwt_segment_grow
#define opj_encode fz_opj_encode
#define opj_encoder_set_extra_options fz_opj_encoder_set_extra_options
#define opj_end_compress fz_opj_end_compress
#define opj_end_decompress fz_opj_end_decompress
#define opj_event_msg fz_opj_event_msg
#define opj_free fz_opj_free
#define opj_get_all_encoding_parameters fz_opj_get_all_encoding_parameters
#define opj_get_cstr_index fz_opj_get_cstr_index
#define opj_get_cstr_info fz_opj_get_cstr_info
#define opj_get_data_length_from_file fz_opj_get_data_length_from_file
#define opj_get_decoded_tile fz_opj_get_decoded_tile
#define opj_get_encoding_packet_count fz_opj_get_encoding_packet_count
#define opj_get_encoding_parameters fz_opj_get_encoding_parameters
#define opj_get_num_cpus fz_opj_get_num_cpus
#define opj_get_tile_dimensions fz_opj_get_tile_dimensions
#define opj_has_thread_support fz_opj_has_thread_support
#define opj_idwt3_v_cas0 fz_opj_idwt3_v_cas0
#define opj_idwt3_v_cas1 fz_opj_idwt3_v_cas1
#define opj_idwt53_h fz_opj_idwt53_h
#define opj_idwt53_h_cas0 fz_opj_idwt53_h_cas0
#define opj_idwt53_h_cas1 fz_opj_idwt53_h_cas1
#define opj_idwt53_v fz_opj_idwt53_v
#define opj_idwt53_v_cas0_mcols_SSE2_OR_AVX2 fz_opj_idwt53_v_cas0_mcols_SSE2_OR_AVX2
#define opj_idwt53_v_cas1_mcols_SSE2_OR_AVX2 fz_opj_idwt53_v_cas1_mcols_SSE2_OR_AVX2
#define opj_idwt53_v_final_memcpy fz_opj_idwt53_v_final_memcpy
#define opj_image_comp_header_update fz_opj_image_comp_header_update
#define opj_image_create fz_opj_image_create
#define opj_image_create0 fz_opj_image_create0
#define opj_image_data_alloc fz_opj_image_data_alloc
#define opj_image_data_free fz_opj_image_data_free
#define opj_image_destroy fz_opj_image_destroy
#define opj_image_tile_create fz_opj_image_tile_create
#define opj_int64_ceildivpow2 fz_opj_int64_ceildivpow2
#define opj_int64_clamp fz_opj_int64_clamp
#define opj_int_abs fz_opj_int_abs
#define opj_int_add_no_overflow fz_opj_int_add_no_overflow
#define opj_int_ceildiv fz_opj_int_ceildiv
#define opj_int_ceildivpow2 fz_opj_int_ceildivpow2
#define opj_int_clamp fz_opj_int_clamp
#define opj_int_fix_mul fz_opj_int_fix_mul
#define opj_int_floordivpow2 fz_opj_int_floordivpow2
#define opj_int_floorlog2 fz_opj_int_floorlog2
#define opj_int_max fz_opj_int_max
#define opj_int_min fz_opj_int_min
#define opj_int_sub_no_overflow fz_opj_int_sub_no_overflow
#define opj_j2k_add_mct fz_opj_j2k_add_mct
#define opj_j2k_add_mhmarker fz_opj_j2k_add_mhmarker
#define opj_j2k_add_tlmarker fz_opj_j2k_add_tlmarker
#define opj_j2k_allocate_tile_element_cstr_index fz_opj_j2k_allocate_tile_element_cstr_index
#define opj_j2k_are_all_used_components_decoded fz_opj_j2k_are_all_used_components_decoded
#define opj_j2k_build_decoder fz_opj_j2k_build_decoder
#define opj_j2k_build_encoder fz_opj_j2k_build_encoder
#define opj_j2k_build_tp_index_from_tlm fz_opj_j2k_build_tp_index_from_tlm
#define opj_j2k_calculate_tp fz_opj_j2k_calculate_tp
#define opj_j2k_check_poc_val fz_opj_j2k_check_poc_val
#define opj_j2k_compare_SPCod_SPCoc fz_opj_j2k_compare_SPCod_SPCoc
#define opj_j2k_compare_SQcd_SQcc fz_opj_j2k_compare_SQcd_SQcc
#define opj_j2k_compare_coc fz_opj_j2k_compare_coc
#define opj_j2k_compare_qcc fz_opj_j2k_compare_qcc
#define opj_j2k_convert_progression_order fz_opj_j2k_convert_progression_order
#define opj_j2k_copy_default_tcp_and_create_tcd fz_opj_j2k_copy_default_tcp_and_create_tcd
#define opj_j2k_copy_tile_component_parameters fz_opj_j2k_copy_tile_component_parameters
#define opj_j2k_copy_tile_quantization_parameters fz_opj_j2k_copy_tile_quantization_parameters
#define opj_j2k_cp_destroy fz_opj_j2k_cp_destroy
#define opj_j2k_create_compress fz_opj_j2k_create_compress
#define opj_j2k_create_cstr_index fz_opj_j2k_create_cstr_index
#define opj_j2k_create_decompress fz_opj_j2k_create_decompress
#define opj_j2k_create_tcd fz_opj_j2k_create_tcd
#define opj_j2k_decode fz_opj_j2k_decode
#define opj_j2k_decode_one_tile fz_opj_j2k_decode_one_tile
#define opj_j2k_decode_tile fz_opj_j2k_decode_tile
#define opj_j2k_decode_tiles fz_opj_j2k_decode_tiles
#define opj_j2k_decoder_set_strict_mode fz_opj_j2k_decoder_set_strict_mode
#define opj_j2k_decoding_validation fz_opj_j2k_decoding_validation
#define opj_j2k_destroy fz_opj_j2k_destroy
#define opj_j2k_destroy_header_memory fz_opj_j2k_destroy_header_memory
#define opj_j2k_dump_MH_index fz_opj_j2k_dump_MH_index
#define opj_j2k_dump_MH_info fz_opj_j2k_dump_MH_info
#define opj_j2k_dump_tile_info fz_opj_j2k_dump_tile_info
#define opj_j2k_encode fz_opj_j2k_encode
#define opj_j2k_encoder_set_extra_options fz_opj_j2k_encoder_set_extra_options
#define opj_j2k_encoding_validation fz_opj_j2k_encoding_validation
#define opj_j2k_end_compress fz_opj_j2k_end_compress
#define opj_j2k_end_decompress fz_opj_j2k_end_decompress
#define opj_j2k_end_encoding fz_opj_j2k_end_encoding
#define opj_j2k_exec fz_opj_j2k_exec
#define opj_j2k_get_SPCod_SPCoc_size fz_opj_j2k_get_SPCod_SPCoc_size
#define opj_j2k_get_SQcd_SQcc_size fz_opj_j2k_get_SQcd_SQcc_size
#define opj_j2k_get_default_stride fz_opj_j2k_get_default_stride
#define opj_j2k_get_default_thread_count fz_opj_j2k_get_default_thread_count
#define opj_j2k_get_end_header fz_opj_j2k_get_end_header
#define opj_j2k_get_imf_max_NL fz_opj_j2k_get_imf_max_NL
#define opj_j2k_get_marker_handler fz_opj_j2k_get_marker_handler
#define opj_j2k_get_max_coc_size fz_opj_j2k_get_max_coc_size
#define opj_j2k_get_max_poc_size fz_opj_j2k_get_max_poc_size
#define opj_j2k_get_max_qcc_size fz_opj_j2k_get_max_qcc_size
#define opj_j2k_get_max_toc_size fz_opj_j2k_get_max_toc_size
#define opj_j2k_get_num_tp fz_opj_j2k_get_num_tp
#define opj_j2k_get_sot_values fz_opj_j2k_get_sot_values
#define opj_j2k_get_specific_header_sizes fz_opj_j2k_get_specific_header_sizes
#define opj_j2k_get_tile fz_opj_j2k_get_tile
#define opj_j2k_get_tile_data fz_opj_j2k_get_tile_data
#define opj_j2k_get_tp_stride fz_opj_j2k_get_tp_stride
#define opj_j2k_init_info fz_opj_j2k_init_info
#define opj_j2k_initialise_4K_poc fz_opj_j2k_initialise_4K_poc
#define opj_j2k_is_cinema_compliant fz_opj_j2k_is_cinema_compliant
#define opj_j2k_is_imf_compliant fz_opj_j2k_is_imf_compliant
#define opj_j2k_mct_validation fz_opj_j2k_mct_validation
#define opj_j2k_merge_ppm fz_opj_j2k_merge_ppm
#define opj_j2k_merge_ppt fz_opj_j2k_merge_ppt
#define opj_j2k_move_data_from_codec_to_output_image fz_opj_j2k_move_data_from_codec_to_output_image
#define opj_j2k_need_nb_tile_parts_correction fz_opj_j2k_need_nb_tile_parts_correction
#define opj_j2k_post_write_tile fz_opj_j2k_post_write_tile
#define opj_j2k_pre_write_tile fz_opj_j2k_pre_write_tile
#define opj_j2k_read_SPCod_SPCoc fz_opj_j2k_read_SPCod_SPCoc
#define opj_j2k_read_SQcd_SQcc fz_opj_j2k_read_SQcd_SQcc
#define opj_j2k_read_cap fz_opj_j2k_read_cap
#define opj_j2k_read_cbd fz_opj_j2k_read_cbd
#define opj_j2k_read_coc fz_opj_j2k_read_coc
#define opj_j2k_read_cod fz_opj_j2k_read_cod
#define opj_j2k_read_com fz_opj_j2k_read_com
#define opj_j2k_read_cpf fz_opj_j2k_read_cpf
#define opj_j2k_read_crg fz_opj_j2k_read_crg
#define opj_j2k_read_float32_to_float fz_opj_j2k_read_float32_to_float
#define opj_j2k_read_float32_to_int32 fz_opj_j2k_read_float32_to_int32
#define opj_j2k_read_float64_to_float fz_opj_j2k_read_float64_to_float
#define opj_j2k_read_float64_to_int32 fz_opj_j2k_read_float64_to_int32
#define opj_j2k_read_header fz_opj_j2k_read_header
#define opj_j2k_read_header_procedure fz_opj_j2k_read_header_procedure
#define opj_j2k_read_int16_to_float fz_opj_j2k_read_int16_to_float
#define opj_j2k_read_int16_to_int32 fz_opj_j2k_read_int16_to_int32
#define opj_j2k_read_int32_to_float fz_opj_j2k_read_int32_to_float
#define opj_j2k_read_int32_to_int32 fz_opj_j2k_read_int32_to_int32
#define opj_j2k_read_mcc fz_opj_j2k_read_mcc
#define opj_j2k_read_mco fz_opj_j2k_read_mco
#define opj_j2k_read_mct fz_opj_j2k_read_mct
#define opj_j2k_read_plm fz_opj_j2k_read_plm
#define opj_j2k_read_plt fz_opj_j2k_read_plt
#define opj_j2k_read_poc fz_opj_j2k_read_poc
#define opj_j2k_read_ppm fz_opj_j2k_read_ppm
#define opj_j2k_read_ppt fz_opj_j2k_read_ppt
#define opj_j2k_read_qcc fz_opj_j2k_read_qcc
#define opj_j2k_read_qcd fz_opj_j2k_read_qcd
#define opj_j2k_read_rgn fz_opj_j2k_read_rgn
#define opj_j2k_read_siz fz_opj_j2k_read_siz
#define opj_j2k_read_soc fz_opj_j2k_read_soc
#define opj_j2k_read_sod fz_opj_j2k_read_sod
#define opj_j2k_read_sot fz_opj_j2k_read_sot
#define opj_j2k_read_tile_header fz_opj_j2k_read_tile_header
#define opj_j2k_read_tlm fz_opj_j2k_read_tlm
#define opj_j2k_read_unk fz_opj_j2k_read_unk
#define opj_j2k_set_cinema_parameters fz_opj_j2k_set_cinema_parameters
#define opj_j2k_set_decode_area fz_opj_j2k_set_decode_area
#define opj_j2k_set_decoded_components fz_opj_j2k_set_decoded_components
#define opj_j2k_set_decoded_resolution_factor fz_opj_j2k_set_decoded_resolution_factor
#define opj_j2k_set_imf_parameters fz_opj_j2k_set_imf_parameters
#define opj_j2k_set_threads fz_opj_j2k_set_threads
#define opj_j2k_setup_decoder fz_opj_j2k_setup_decoder
#define opj_j2k_setup_decoding fz_opj_j2k_setup_decoding
#define opj_j2k_setup_decoding_tile fz_opj_j2k_setup_decoding_tile
#define opj_j2k_setup_decoding_validation fz_opj_j2k_setup_decoding_validation
#define opj_j2k_setup_encoder fz_opj_j2k_setup_encoder
#define opj_j2k_setup_encoding_validation fz_opj_j2k_setup_encoding_validation
#define opj_j2k_setup_end_compress fz_opj_j2k_setup_end_compress
#define opj_j2k_setup_header_reading fz_opj_j2k_setup_header_reading
#define opj_j2k_setup_header_writing fz_opj_j2k_setup_header_writing
#define opj_j2k_setup_mct_encoding fz_opj_j2k_setup_mct_encoding
#define opj_j2k_start_compress fz_opj_j2k_start_compress
#define opj_j2k_tcp_data_destroy fz_opj_j2k_tcp_data_destroy
#define opj_j2k_tcp_destroy fz_opj_j2k_tcp_destroy
#define opj_j2k_update_image_data fz_opj_j2k_update_image_data
#define opj_j2k_update_image_dimensions fz_opj_j2k_update_image_dimensions
#define opj_j2k_update_rates fz_opj_j2k_update_rates
#define opj_j2k_update_tlm fz_opj_j2k_update_tlm
#define opj_j2k_write_SPCod_SPCoc fz_opj_j2k_write_SPCod_SPCoc
#define opj_j2k_write_SQcd_SQcc fz_opj_j2k_write_SQcd_SQcc
#define opj_j2k_write_all_coc fz_opj_j2k_write_all_coc
#define opj_j2k_write_all_qcc fz_opj_j2k_write_all_qcc
#define opj_j2k_write_all_tile_parts fz_opj_j2k_write_all_tile_parts
#define opj_j2k_write_cbd fz_opj_j2k_write_cbd
#define opj_j2k_write_coc fz_opj_j2k_write_coc
#define opj_j2k_write_coc_in_memory fz_opj_j2k_write_coc_in_memory
#define opj_j2k_write_cod fz_opj_j2k_write_cod
#define opj_j2k_write_com fz_opj_j2k_write_com
#define opj_j2k_write_eoc fz_opj_j2k_write_eoc
#define opj_j2k_write_epc fz_opj_j2k_write_epc
#define opj_j2k_write_first_tile_part fz_opj_j2k_write_first_tile_part
#define opj_j2k_write_float_to_float fz_opj_j2k_write_float_to_float
#define opj_j2k_write_float_to_float64 fz_opj_j2k_write_float_to_float64
#define opj_j2k_write_float_to_int16 fz_opj_j2k_write_float_to_int16
#define opj_j2k_write_float_to_int32 fz_opj_j2k_write_float_to_int32
#define opj_j2k_write_mcc_record fz_opj_j2k_write_mcc_record
#define opj_j2k_write_mco fz_opj_j2k_write_mco
#define opj_j2k_write_mct_data_group fz_opj_j2k_write_mct_data_group
#define opj_j2k_write_mct_record fz_opj_j2k_write_mct_record
#define opj_j2k_write_plt_in_memory fz_opj_j2k_write_plt_in_memory
#define opj_j2k_write_poc fz_opj_j2k_write_poc
#define opj_j2k_write_poc_in_memory fz_opj_j2k_write_poc_in_memory
#define opj_j2k_write_qcc fz_opj_j2k_write_qcc
#define opj_j2k_write_qcc_in_memory fz_opj_j2k_write_qcc_in_memory
#define opj_j2k_write_qcd fz_opj_j2k_write_qcd
#define opj_j2k_write_regions fz_opj_j2k_write_regions
#define opj_j2k_write_rgn fz_opj_j2k_write_rgn
#define opj_j2k_write_siz fz_opj_j2k_write_siz
#define opj_j2k_write_soc fz_opj_j2k_write_soc
#define opj_j2k_write_sod fz_opj_j2k_write_sod
#define opj_j2k_write_sot fz_opj_j2k_write_sot
#define opj_j2k_write_tile fz_opj_j2k_write_tile
#define opj_j2k_write_tlm fz_opj_j2k_write_tlm
#define opj_j2k_write_updated_tlm fz_opj_j2k_write_updated_tlm
#define opj_jp2_apply_cdef fz_opj_jp2_apply_cdef
#define opj_jp2_apply_color_postprocessing fz_opj_jp2_apply_color_postprocessing
#define opj_jp2_apply_pclr fz_opj_jp2_apply_pclr
#define opj_jp2_check_color fz_opj_jp2_check_color
#define opj_jp2_create fz_opj_jp2_create
#define opj_jp2_decode fz_opj_jp2_decode
#define opj_jp2_decode_tile fz_opj_jp2_decode_tile
#define opj_jp2_decoder_set_strict_mode fz_opj_jp2_decoder_set_strict_mode
#define opj_jp2_default_validation fz_opj_jp2_default_validation
#define opj_jp2_destroy fz_opj_jp2_destroy
#define opj_jp2_encode fz_opj_jp2_encode
#define opj_jp2_encoder_set_extra_options fz_opj_jp2_encoder_set_extra_options
#define opj_jp2_end_compress fz_opj_jp2_end_compress
#define opj_jp2_end_decompress fz_opj_jp2_end_decompress
#define opj_jp2_exec fz_opj_jp2_exec
#define opj_jp2_find_handler fz_opj_jp2_find_handler
#define opj_jp2_free_pclr fz_opj_jp2_free_pclr
#define opj_jp2_get_tile fz_opj_jp2_get_tile
#define opj_jp2_img_find_handler fz_opj_jp2_img_find_handler
#define opj_jp2_read_boxhdr fz_opj_jp2_read_boxhdr
#define opj_jp2_read_boxhdr_char fz_opj_jp2_read_boxhdr_char
#define opj_jp2_read_bpcc fz_opj_jp2_read_bpcc
#define opj_jp2_read_cdef fz_opj_jp2_read_cdef
#define opj_jp2_read_cmap fz_opj_jp2_read_cmap
#define opj_jp2_read_colr fz_opj_jp2_read_colr
#define opj_jp2_read_ftyp fz_opj_jp2_read_ftyp
#define opj_jp2_read_header fz_opj_jp2_read_header
#define opj_jp2_read_header_procedure fz_opj_jp2_read_header_procedure
#define opj_jp2_read_ihdr fz_opj_jp2_read_ihdr
#define opj_jp2_read_jp fz_opj_jp2_read_jp
#define opj_jp2_read_jp2h fz_opj_jp2_read_jp2h
#define opj_jp2_read_pclr fz_opj_jp2_read_pclr
#define opj_jp2_read_tile_header fz_opj_jp2_read_tile_header
#define opj_jp2_set_decode_area fz_opj_jp2_set_decode_area
#define opj_jp2_set_decoded_components fz_opj_jp2_set_decoded_components
#define opj_jp2_set_decoded_resolution_factor fz_opj_jp2_set_decoded_resolution_factor
#define opj_jp2_set_threads fz_opj_jp2_set_threads
#define opj_jp2_setup_decoder fz_opj_jp2_setup_decoder
#define opj_jp2_setup_decoding_validation fz_opj_jp2_setup_decoding_validation
#define opj_jp2_setup_encoder fz_opj_jp2_setup_encoder
#define opj_jp2_setup_encoding_validation fz_opj_jp2_setup_encoding_validation
#define opj_jp2_setup_end_header_reading fz_opj_jp2_setup_end_header_reading
#define opj_jp2_setup_end_header_writing fz_opj_jp2_setup_end_header_writing
#define opj_jp2_setup_header_reading fz_opj_jp2_setup_header_reading
#define opj_jp2_setup_header_writing fz_opj_jp2_setup_header_writing
#define opj_jp2_skip_jp2c fz_opj_jp2_skip_jp2c
#define opj_jp2_start_compress fz_opj_jp2_start_compress
#define opj_jp2_write_bpcc fz_opj_jp2_write_bpcc
#define opj_jp2_write_cdef fz_opj_jp2_write_cdef
#define opj_jp2_write_colr fz_opj_jp2_write_colr
#define opj_jp2_write_ftyp fz_opj_jp2_write_ftyp
#define opj_jp2_write_ihdr fz_opj_jp2_write_ihdr
#define opj_jp2_write_jp fz_opj_jp2_write_jp
#define opj_jp2_write_jp2c fz_opj_jp2_write_jp2c
#define opj_jp2_write_jp2h fz_opj_jp2_write_jp2h
#define opj_jp2_write_tile fz_opj_jp2_write_tile
#define opj_jpip_skip_iptr fz_opj_jpip_skip_iptr
#define opj_lrintf fz_opj_lrintf
#define opj_lupDecompose fz_opj_lupDecompose
#define opj_lupInvert fz_opj_lupInvert
#define opj_lupSolve fz_opj_lupSolve
#define opj_malloc fz_opj_malloc
#define opj_matrix_inversion_f fz_opj_matrix_inversion_f
#define opj_mct_decode fz_opj_mct_decode
#define opj_mct_decode_custom fz_opj_mct_decode_custom
#define opj_mct_decode_real fz_opj_mct_decode_real
#define opj_mct_encode fz_opj_mct_encode
#define opj_mct_encode_custom fz_opj_mct_encode_custom
#define opj_mct_encode_real fz_opj_mct_encode_real
#define opj_mct_get_mct_norms fz_opj_mct_get_mct_norms
#define opj_mct_get_mct_norms_real fz_opj_mct_get_mct_norms_real
#define opj_mct_getnorm fz_opj_mct_getnorm
#define opj_mct_getnorm_real fz_opj_mct_getnorm_real
#define opj_mqc_bypass_enc fz_opj_mqc_bypass_enc
#define opj_mqc_bypass_flush_enc fz_opj_mqc_bypass_flush_enc
#define opj_mqc_bypass_get_extra_bytes fz_opj_mqc_bypass_get_extra_bytes
#define opj_mqc_bypass_init_enc fz_opj_mqc_bypass_init_enc
#define opj_mqc_bytein fz_opj_mqc_bytein
#define opj_mqc_byteout fz_opj_mqc_byteout
#define opj_mqc_codelps fz_opj_mqc_codelps
#define opj_mqc_codemps fz_opj_mqc_codemps
#define opj_mqc_encode fz_opj_mqc_encode
#define opj_mqc_erterm_enc fz_opj_mqc_erterm_enc
#define opj_mqc_flush fz_opj_mqc_flush
#define opj_mqc_init_dec fz_opj_mqc_init_dec
#define opj_mqc_init_dec_common fz_opj_mqc_init_dec_common
#define opj_mqc_init_enc fz_opj_mqc_init_enc
#define opj_mqc_numbytes fz_opj_mqc_numbytes
#define opj_mqc_raw_decode fz_opj_mqc_raw_decode
#define opj_mqc_raw_init_dec fz_opj_mqc_raw_init_dec
#define opj_mqc_reset_enc fz_opj_mqc_reset_enc
#define opj_mqc_resetstates fz_opj_mqc_resetstates
#define opj_mqc_restart_init_enc fz_opj_mqc_restart_init_enc
#define opj_mqc_segmark_enc fz_opj_mqc_segmark_enc
#define opj_mqc_setbits fz_opj_mqc_setbits
#define opj_mqc_setstate fz_opj_mqc_setstate
#define opj_mutex_create fz_opj_mutex_create
#define opj_mutex_destroy fz_opj_mutex_destroy
#define opj_mutex_lock fz_opj_mutex_lock
#define opj_mutex_unlock fz_opj_mutex_unlock
#define opj_null_jas_fprintf fz_opj_null_jas_fprintf
#define opj_pi_check_next_level fz_opj_pi_check_next_level
#define opj_pi_create fz_opj_pi_create
#define opj_pi_create_decode fz_opj_pi_create_decode
#define opj_pi_create_encode fz_opj_pi_create_encode
#define opj_pi_destroy fz_opj_pi_destroy
#define opj_pi_initialise_encode fz_opj_pi_initialise_encode
#define opj_pi_next fz_opj_pi_next
#define opj_pi_next_cprl fz_opj_pi_next_cprl
#define opj_pi_next_lrcp fz_opj_pi_next_lrcp
#define opj_pi_next_pcrl fz_opj_pi_next_pcrl
#define opj_pi_next_rlcp fz_opj_pi_next_rlcp
#define opj_pi_next_rpcl fz_opj_pi_next_rpcl
#define opj_pi_update_decode_not_poc fz_opj_pi_update_decode_not_poc
#define opj_pi_update_decode_poc fz_opj_pi_update_decode_poc
#define opj_pi_update_encode_not_poc fz_opj_pi_update_encode_not_poc
#define opj_pi_update_encode_poc_and_final fz_opj_pi_update_encode_poc_and_final
#define opj_pi_update_encoding_parameters fz_opj_pi_update_encoding_parameters
#define opj_procedure_list_add_procedure fz_opj_procedure_list_add_procedure
#define opj_procedure_list_clear fz_opj_procedure_list_clear
#define opj_procedure_list_create fz_opj_procedure_list_create
#define opj_procedure_list_destroy fz_opj_procedure_list_destroy
#define opj_procedure_list_get_first_procedure fz_opj_procedure_list_get_first_procedure
#define opj_procedure_list_get_nb_procedures fz_opj_procedure_list_get_nb_procedures
#define opj_read_bytes_BE fz_opj_read_bytes_BE
#define opj_read_bytes_LE fz_opj_read_bytes_LE
#define opj_read_double_BE fz_opj_read_double_BE
#define opj_read_double_LE fz_opj_read_double_LE
#define opj_read_float_BE fz_opj_read_float_BE
#define opj_read_float_LE fz_opj_read_float_LE
#define opj_read_from_file fz_opj_read_from_file
#define opj_read_header fz_opj_read_header
#define opj_read_tile_header fz_opj_read_tile_header
#define opj_realloc fz_opj_realloc
#define opj_seek_from_file fz_opj_seek_from_file
#define opj_set_MCT fz_opj_set_MCT
#define opj_set_decode_area fz_opj_set_decode_area
#define opj_set_decoded_components fz_opj_set_decoded_components
#define opj_set_decoded_resolution_factor fz_opj_set_decoded_resolution_factor
#define opj_set_default_decoder_parameters fz_opj_set_default_decoder_parameters
#define opj_set_default_encoder_parameters fz_opj_set_default_encoder_parameters
#define opj_set_default_event_handler fz_opj_set_default_event_handler
#define opj_set_error_handler fz_opj_set_error_handler
#define opj_set_info_handler fz_opj_set_info_handler
#define opj_set_warning_handler fz_opj_set_warning_handler
#define opj_setup_decoder fz_opj_setup_decoder
#define opj_setup_encoder fz_opj_setup_encoder
#define opj_skip_from_file fz_opj_skip_from_file
#define opj_sparse_array_int32_create fz_opj_sparse_array_int32_create
#define opj_sparse_array_int32_free fz_opj_sparse_array_int32_free
#define opj_sparse_array_int32_read fz_opj_sparse_array_int32_read
#define opj_sparse_array_int32_read_or_write fz_opj_sparse_array_int32_read_or_write
#define opj_sparse_array_int32_write fz_opj_sparse_array_int32_write
#define opj_sparse_array_is_region_valid fz_opj_sparse_array_is_region_valid
#define opj_start_compress fz_opj_start_compress
#define opj_stream_create fz_opj_stream_create
#define opj_stream_create_default_file_stream fz_opj_stream_create_default_file_stream
#define opj_stream_create_file_stream fz_opj_stream_create_file_stream
#define opj_stream_default_create fz_opj_stream_default_create
#define opj_stream_default_read fz_opj_stream_default_read
#define opj_stream_default_seek fz_opj_stream_default_seek
#define opj_stream_default_skip fz_opj_stream_default_skip
#define opj_stream_default_write fz_opj_stream_default_write
#define opj_stream_destroy fz_opj_stream_destroy
#define opj_stream_flush fz_opj_stream_flush
#define opj_stream_get_number_byte_left fz_opj_stream_get_number_byte_left
#define opj_stream_has_seek fz_opj_stream_has_seek
#define opj_stream_read_data fz_opj_stream_read_data
#define opj_stream_read_seek fz_opj_stream_read_seek
#define opj_stream_read_skip fz_opj_stream_read_skip
#define opj_stream_seek fz_opj_stream_seek
#define opj_stream_set_read_function fz_opj_stream_set_read_function
#define opj_stream_set_seek_function fz_opj_stream_set_seek_function
#define opj_stream_set_skip_function fz_opj_stream_set_skip_function
#define opj_stream_set_user_data fz_opj_stream_set_user_data
#define opj_stream_set_user_data_length fz_opj_stream_set_user_data_length
#define opj_stream_set_write_function fz_opj_stream_set_write_function
#define opj_stream_skip fz_opj_stream_skip
#define opj_stream_tell fz_opj_stream_tell
#define opj_stream_write_data fz_opj_stream_write_data
#define opj_stream_write_seek fz_opj_stream_write_seek
#define opj_stream_write_skip fz_opj_stream_write_skip
#define opj_t1_allocate_buffers fz_opj_t1_allocate_buffers
#define opj_t1_cblk_encode_processor fz_opj_t1_cblk_encode_processor
#define opj_t1_clbl_decode_processor fz_opj_t1_clbl_decode_processor
#define opj_t1_create fz_opj_t1_create
#define opj_t1_dec_clnpass fz_opj_t1_dec_clnpass
#define opj_t1_dec_clnpass_64x64_novsc fz_opj_t1_dec_clnpass_64x64_novsc
#define opj_t1_dec_clnpass_64x64_vsc fz_opj_t1_dec_clnpass_64x64_vsc
#define opj_t1_dec_clnpass_check_segsym fz_opj_t1_dec_clnpass_check_segsym
#define opj_t1_dec_clnpass_generic_novsc fz_opj_t1_dec_clnpass_generic_novsc
#define opj_t1_dec_clnpass_generic_vsc fz_opj_t1_dec_clnpass_generic_vsc
#define opj_t1_dec_clnpass_step fz_opj_t1_dec_clnpass_step
#define opj_t1_dec_refpass_mqc fz_opj_t1_dec_refpass_mqc
#define opj_t1_dec_refpass_mqc_64x64 fz_opj_t1_dec_refpass_mqc_64x64
#define opj_t1_dec_refpass_mqc_generic fz_opj_t1_dec_refpass_mqc_generic
#define opj_t1_dec_refpass_raw fz_opj_t1_dec_refpass_raw
#define opj_t1_dec_refpass_step_mqc fz_opj_t1_dec_refpass_step_mqc
#define opj_t1_dec_refpass_step_raw fz_opj_t1_dec_refpass_step_raw
#define opj_t1_dec_sigpass_mqc fz_opj_t1_dec_sigpass_mqc
#define opj_t1_dec_sigpass_mqc_64x64_novsc fz_opj_t1_dec_sigpass_mqc_64x64_novsc
#define opj_t1_dec_sigpass_mqc_64x64_vsc fz_opj_t1_dec_sigpass_mqc_64x64_vsc
#define opj_t1_dec_sigpass_mqc_generic_novsc fz_opj_t1_dec_sigpass_mqc_generic_novsc
#define opj_t1_dec_sigpass_mqc_generic_vsc fz_opj_t1_dec_sigpass_mqc_generic_vsc
#define opj_t1_dec_sigpass_raw fz_opj_t1_dec_sigpass_raw
#define opj_t1_dec_sigpass_step_mqc fz_opj_t1_dec_sigpass_step_mqc
#define opj_t1_dec_sigpass_step_raw fz_opj_t1_dec_sigpass_step_raw
#define opj_t1_decode_cblk fz_opj_t1_decode_cblk
#define opj_t1_decode_cblks fz_opj_t1_decode_cblks
#define opj_t1_destroy fz_opj_t1_destroy
#define opj_t1_destroy_wrapper fz_opj_t1_destroy_wrapper
#define opj_t1_enc_clnpass fz_opj_t1_enc_clnpass
#define opj_t1_enc_is_term_pass fz_opj_t1_enc_is_term_pass
#define opj_t1_enc_refpass fz_opj_t1_enc_refpass
#define opj_t1_enc_sigpass fz_opj_t1_enc_sigpass
#define opj_t1_encode_cblk fz_opj_t1_encode_cblk
#define opj_t1_encode_cblks fz_opj_t1_encode_cblks
#define opj_t1_getctxno_mag fz_opj_t1_getctxno_mag
#define opj_t1_getctxno_sc fz_opj_t1_getctxno_sc
#define opj_t1_getctxno_zc fz_opj_t1_getctxno_zc
#define opj_t1_getctxtno_sc_or_spb_index fz_opj_t1_getctxtno_sc_or_spb_index
#define opj_t1_getnmsedec_ref fz_opj_t1_getnmsedec_ref
#define opj_t1_getnmsedec_sig fz_opj_t1_getnmsedec_sig
#define opj_t1_getspb fz_opj_t1_getspb
#define opj_t1_getwmsedec fz_opj_t1_getwmsedec
#define opj_t1_ht_decode_cblk fz_opj_t1_ht_decode_cblk
#define opj_t1_update_flags fz_opj_t1_update_flags
#define opj_t2_create fz_opj_t2_create
#define opj_t2_decode_packet fz_opj_t2_decode_packet
#define opj_t2_decode_packets fz_opj_t2_decode_packets
#define opj_t2_destroy fz_opj_t2_destroy
#define opj_t2_encode_packet fz_opj_t2_encode_packet
#define opj_t2_encode_packets fz_opj_t2_encode_packets
#define opj_t2_getcommacode fz_opj_t2_getcommacode
#define opj_t2_getnumpasses fz_opj_t2_getnumpasses
#define opj_t2_init_seg fz_opj_t2_init_seg
#define opj_t2_putcommacode fz_opj_t2_putcommacode
#define opj_t2_putnumpasses fz_opj_t2_putnumpasses
#define opj_t2_read_packet_data fz_opj_t2_read_packet_data
#define opj_t2_read_packet_header fz_opj_t2_read_packet_header
#define opj_t2_skip_packet fz_opj_t2_skip_packet
#define opj_t2_skip_packet_data fz_opj_t2_skip_packet_data
#define opj_tcd_code_block_dec_allocate fz_opj_tcd_code_block_dec_allocate
#define opj_tcd_code_block_dec_deallocate fz_opj_tcd_code_block_dec_deallocate
#define opj_tcd_code_block_enc_allocate fz_opj_tcd_code_block_enc_allocate
#define opj_tcd_code_block_enc_allocate_data fz_opj_tcd_code_block_enc_allocate_data
#define opj_tcd_code_block_enc_deallocate fz_opj_tcd_code_block_enc_deallocate
#define opj_tcd_copy_tile_data fz_opj_tcd_copy_tile_data
#define opj_tcd_create fz_opj_tcd_create
#define opj_tcd_dc_level_shift_decode fz_opj_tcd_dc_level_shift_decode
#define opj_tcd_dc_level_shift_encode fz_opj_tcd_dc_level_shift_encode
#define opj_tcd_decode_tile fz_opj_tcd_decode_tile
#define opj_tcd_destroy fz_opj_tcd_destroy
#define opj_tcd_dwt_decode fz_opj_tcd_dwt_decode
#define opj_tcd_dwt_encode fz_opj_tcd_dwt_encode
#define opj_tcd_encode_tile fz_opj_tcd_encode_tile
#define opj_tcd_free_tile fz_opj_tcd_free_tile
#define opj_tcd_get_decoded_tile_size fz_opj_tcd_get_decoded_tile_size
#define opj_tcd_get_encoder_input_buffer_size fz_opj_tcd_get_encoder_input_buffer_size
#define opj_tcd_init fz_opj_tcd_init
#define opj_tcd_init_decode_tile fz_opj_tcd_init_decode_tile
#define opj_tcd_init_encode_tile fz_opj_tcd_init_encode_tile
#define opj_tcd_init_tile fz_opj_tcd_init_tile
#define opj_tcd_is_band_empty fz_opj_tcd_is_band_empty
#define opj_tcd_is_subband_area_of_interest fz_opj_tcd_is_subband_area_of_interest
#define opj_tcd_is_whole_tilecomp_decoding fz_opj_tcd_is_whole_tilecomp_decoding
#define opj_tcd_makelayer fz_opj_tcd_makelayer
#define opj_tcd_makelayer_fixed fz_opj_tcd_makelayer_fixed
#define opj_tcd_marker_info_create fz_opj_tcd_marker_info_create
#define opj_tcd_marker_info_destroy fz_opj_tcd_marker_info_destroy
#define opj_tcd_mct_decode fz_opj_tcd_mct_decode
#define opj_tcd_mct_encode fz_opj_tcd_mct_encode
#define opj_tcd_rate_allocate_encode fz_opj_tcd_rate_allocate_encode
#define opj_tcd_rateallocate fz_opj_tcd_rateallocate
#define opj_tcd_rateallocate_fixed fz_opj_tcd_rateallocate_fixed
#define opj_tcd_reinit_segment fz_opj_tcd_reinit_segment
#define opj_tcd_t1_decode fz_opj_tcd_t1_decode
#define opj_tcd_t1_encode fz_opj_tcd_t1_encode
#define opj_tcd_t2_decode fz_opj_tcd_t2_decode
#define opj_tcd_t2_encode fz_opj_tcd_t2_encode
#define opj_tcd_update_tile_data fz_opj_tcd_update_tile_data
#define opj_tgt_create fz_opj_tgt_create
#define opj_tgt_decode fz_opj_tgt_decode
#define opj_tgt_destroy fz_opj_tgt_destroy
#define opj_tgt_encode fz_opj_tgt_encode
#define opj_tgt_init fz_opj_tgt_init
#define opj_tgt_reset fz_opj_tgt_reset
#define opj_tgt_setvalue fz_opj_tgt_setvalue
#define opj_thread_create fz_opj_thread_create
#define opj_thread_join fz_opj_thread_join
#define opj_thread_pool_create fz_opj_thread_pool_create
#define opj_thread_pool_destroy fz_opj_thread_pool_destroy
#define opj_thread_pool_get_next_job fz_opj_thread_pool_get_next_job
#define opj_thread_pool_get_thread_count fz_opj_thread_pool_get_thread_count
#define opj_thread_pool_setup fz_opj_thread_pool_setup
#define opj_thread_pool_submit_job fz_opj_thread_pool_submit_job
#define opj_thread_pool_wait_completion fz_opj_thread_pool_wait_completion
#define opj_tls_destroy fz_opj_tls_destroy
#define opj_tls_get fz_opj_tls_get
#define opj_tls_new fz_opj_tls_new
#define opj_tls_set fz_opj_tls_set
#define opj_uint64_ceildiv_res_uint32 fz_opj_uint64_ceildiv_res_uint32
#define opj_uint_adds fz_opj_uint_adds
#define opj_uint_ceildiv fz_opj_uint_ceildiv
#define opj_uint_ceildivpow2 fz_opj_uint_ceildivpow2
#define opj_uint_floordivpow2 fz_opj_uint_floordivpow2
#define opj_uint_floorlog2 fz_opj_uint_floorlog2
#define opj_uint_max fz_opj_uint_max
#define opj_uint_min fz_opj_uint_min
#define opj_uint_subs fz_opj_uint_subs
#define opj_v8dwt_decode fz_opj_v8dwt_decode
#define opj_v8dwt_decode_step1_sse fz_opj_v8dwt_decode_step1_sse
#define opj_v8dwt_decode_step2_sse fz_opj_v8dwt_decode_step2_sse
#define opj_v8dwt_encode_step1 fz_opj_v8dwt_encode_step1
#define opj_v8dwt_encode_step2 fz_opj_v8dwt_encode_step2
#define opj_v8dwt_interleave_h fz_opj_v8dwt_interleave_h
#define opj_v8dwt_interleave_partial_h fz_opj_v8dwt_interleave_partial_h
#define opj_v8dwt_interleave_partial_v fz_opj_v8dwt_interleave_partial_v
#define opj_v8dwt_interleave_v fz_opj_v8dwt_interleave_v
#define opj_version fz_opj_version
#define opj_worker_thread_function fz_opj_worker_thread_function
#define opj_write_bytes_BE fz_opj_write_bytes_BE
#define opj_write_bytes_LE fz_opj_write_bytes_LE
#define opj_write_double_BE fz_opj_write_double_BE
#define opj_write_double_LE fz_opj_write_double_LE
#define opj_write_float_BE fz_opj_write_float_BE
#define opj_write_float_LE fz_opj_write_float_LE
#define opj_write_from_file fz_opj_write_from_file
#define opj_write_tile fz_opj_write_tile
#define opq_mqc_finish_dec fz_opj_opq_mqc_finish_dec
#endif

#endif
