/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class IndexOf
extends CollatingFunction
implements Callable {
    protected int getCollationArgument() {
        return 2;
    }

    public IntegerValue[] getIntegerBounds() {
        return new IntegerValue[]{Int64Value.PLUS_ONE, MAX_SEQUENCE_LENGTH};
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        ItemType type0 = this.argument[0].getItemType();
        ItemType type1 = this.argument[1].getItemType();
        if (type0 instanceof AtomicType && type1 instanceof AtomicType) {
            this.preAllocateComparer((AtomicType)type0, (AtomicType)type1, visitor.getStaticContext(), false);
        }
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        AtomicComparer preAllocated = this.getPreAllocatedAtomicComparer();
        AtomicComparer comparer = preAllocated == null ? this.getAtomicComparer(this.getCollator(context), context) : preAllocated;
        SequenceIterator seq = this.argument[0].iterate(context);
        AtomicValue val = (AtomicValue)this.argument[1].evaluateItem(context);
        return IndexOf.indexOf(seq, val, comparer);
    }

    private static SequenceIterator indexOf(SequenceIterator seq, final AtomicValue val, final AtomicComparer comparer) {
        final BuiltInAtomicType searchType = val.getPrimitiveType();
        ItemMappingFunction<AtomicValue, IntegerValue> f = new ItemMappingFunction<AtomicValue, IntegerValue>(){
            int index = 0;

            @Override
            public IntegerValue mapItem(AtomicValue item) throws XPathException {
                ++this.index;
                if (Type.isGuaranteedComparable(searchType, item.getPrimitiveType(), false) && comparer.comparesEqual(item, val)) {
                    return new Int64Value(this.index);
                }
                return null;
            }
        };
        return new ItemMappingIterator<AtomicValue, IntegerValue>(seq, f);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringCollator collator = this.getCollatorFromLastArgument(arguments, 2, context);
        GenericAtomicComparer comparer = new GenericAtomicComparer(collator, context);
        SequenceIterator seq = arguments[0].iterate();
        AtomicValue val = (AtomicValue)arguments[1].head();
        return SequenceTool.toLazySequence(IndexOf.indexOf(seq, val, comparer));
    }
}

