/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;

public class ContentGeneratorDescriptor {
    private static final String ATTRIBUTE_DEFAULT_MARKER_GROUPING = "defaultMarkerGrouping";
    private static final String ATTRIBUTE_VISIBLE = "visible";
    private static final String ELEMENT_MARKER_FIELD_CONFIGURATION = "markerFieldConfiguration";
    private static final String MARKER_FIELD_REFERENCE = "markerFieldReference";
    private IConfigurationElement configurationElement;
    private MarkerField[] allFields;
    private MarkerField[] allFieldsWithExtensions;
    private Collection<MarkerType> markerTypes;
    private MarkerField[] initialVisible;
    private MarkerField[] initialVisibleWithExtensions;
    private Collection<MarkerGroup> groups;
    private Collection<IConfigurationElement> generatorExtensions = new ArrayList<IConfigurationElement>();
    private Map<String, MarkerType> allTypesTable;

    public ContentGeneratorDescriptor(IConfigurationElement element) {
        this.configurationElement = element;
    }

    private void addDefinedGroups(Collection<MarkerGroup> groupss) {
        this.addGroupsFrom(this.configurationElement, groupss);
        Iterator<IConfigurationElement> extensions = this.generatorExtensions.iterator();
        while (extensions.hasNext()) {
            this.addGroupsFrom(extensions.next(), groupss);
        }
    }

    public void addExtensions(Collection<IConfigurationElement> extensions) {
        this.generatorExtensions = extensions;
        this.clearCaches();
    }

    private void addGroupsFrom(IConfigurationElement element, Collection<MarkerGroup> groupss) {
        IConfigurationElement[] iConfigurationElementArray = element.getChildren("markerGrouping");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement grouping = iConfigurationElementArray[n2];
            groupss.add(MarkerGroup.createMarkerGroup(grouping));
            ++n2;
        }
    }

    public boolean allTypesSelected(Collection<MarkerType> selectedTypes) {
        return selectedTypes.containsAll(this.getMarkerTypes());
    }

    public MarkerField[] getAllFields() {
        if (this.allFieldsWithExtensions == null) {
            ArrayList<MarkerField> fields = new ArrayList<MarkerField>();
            fields.addAll(Arrays.asList(this.allFields));
            this.getExtensionsDescriptorsStream().map(d -> Arrays.asList(d.getAllFields())).flatMap(Collection::stream).forEach(fields::add);
            this.allFieldsWithExtensions = (MarkerField[])fields.toArray(MarkerField[]::new);
        }
        return this.allFieldsWithExtensions;
    }

    public String getCategoryName() {
        return this.configurationElement.getAttribute(ATTRIBUTE_DEFAULT_MARKER_GROUPING);
    }

    public IConfigurationElement[] getFilterReferences() {
        IConfigurationElement[] filterGroups = this.configurationElement.getChildren(ELEMENT_MARKER_FIELD_CONFIGURATION);
        if (this.generatorExtensions.isEmpty()) {
            return filterGroups;
        }
        Iterator<IConfigurationElement> extensions = this.generatorExtensions.iterator();
        ArrayList<IConfigurationElement> extendedElements = new ArrayList<IConfigurationElement>();
        while (extensions.hasNext()) {
            IConfigurationElement extension = extensions.next();
            IConfigurationElement[] extensionFilters = extension.getChildren(ELEMENT_MARKER_FIELD_CONFIGURATION);
            extendedElements.addAll(Arrays.asList(extensionFilters));
        }
        if (extendedElements.size() > 0) {
            return (IConfigurationElement[])Stream.concat(Arrays.stream(filterGroups), extendedElements.stream()).toArray(IConfigurationElement[]::new);
        }
        return filterGroups;
    }

    public String getId() {
        return this.configurationElement.getAttribute("id");
    }

    public MarkerField[] getInitialVisible() {
        if (this.initialVisibleWithExtensions == null) {
            ArrayList<MarkerField> fields = new ArrayList<MarkerField>();
            fields.addAll(Arrays.asList(this.initialVisible));
            this.getExtensionsDescriptorsStream().map(d -> Arrays.asList(d.getInitialVisible())).flatMap(Collection::stream).forEach(fields::add);
            this.initialVisibleWithExtensions = (MarkerField[])fields.toArray(MarkerField[]::new);
        }
        return this.initialVisibleWithExtensions;
    }

    public Collection<MarkerGroup> getMarkerGroups() {
        if (this.groups == null) {
            this.groups = new TreeSet<MarkerGroup>((mg1, mg2) -> mg1.getMarkerField().getName().compareTo(mg2.getMarkerField().getName()));
            this.addDefinedGroups(this.groups);
            if (this.getId().equals("org.eclipse.ui.ide.problemsGenerator")) {
                this.groups.addAll(MarkerSupportRegistry.getInstance().getMarkerGroups());
            }
        }
        return this.groups;
    }

    /*
     * Exception decompiling
     */
    public Collection<MarkerType> getMarkerTypes() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl47 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl47 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getName() {
        return this.configurationElement.getAttribute("name");
    }

    public MarkerType getType(String typeId) {
        return this.getTypesTable().get(typeId);
    }

    public Map<String, MarkerType> getTypesTable() {
        if (this.allTypesTable == null) {
            this.allTypesTable = new HashMap<String, MarkerType>();
            for (MarkerType next : this.getMarkerTypes()) {
                this.allTypesTable.put(next.getId(), next);
            }
        }
        return this.allTypesTable;
    }

    public void initializeFromConfigurationElement(MarkerSupportRegistry registry) {
        IConfigurationElement[] elements = this.configurationElement.getChildren(MARKER_FIELD_REFERENCE);
        ArrayList<MarkerField> allFieldList = new ArrayList<MarkerField>();
        ArrayList<MarkerField> initialVisibleList = new ArrayList<MarkerField>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MarkerField field = registry.getField(element.getAttribute("id"));
            if (field != null) {
                allFieldList.add(field);
                if (!MarkerSupportInternalUtilities.VALUE_FALSE.equals(element.getAttribute(ATTRIBUTE_VISIBLE))) {
                    initialVisibleList.add(field);
                }
            }
            ++n2;
        }
        this.allFields = new MarkerField[allFieldList.size()];
        allFieldList.toArray(this.allFields);
        this.initialVisible = new MarkerField[initialVisibleList.size()];
        initialVisibleList.toArray(this.initialVisible);
    }

    public void removeExtension(IConfigurationElement element) {
        this.generatorExtensions.remove(element);
        this.clearCaches();
    }

    private void clearCaches() {
        this.allFieldsWithExtensions = null;
        this.initialVisibleWithExtensions = null;
        this.markerTypes = null;
        this.groups = null;
        this.allTypesTable = null;
    }

    private Stream<ContentGeneratorDescriptor> getExtensionsDescriptorsStream() {
        if (this.generatorExtensions != null) {
            MarkerSupportRegistry registry = MarkerSupportRegistry.getInstance();
            return this.generatorExtensions.stream().map(extensionConfigElem -> extensionConfigElem.getAttribute("id")).filter(id -> id != null && !id.isBlank()).map(contentGeneratorId -> registry.getContentGenDescriptor((String)contentGeneratorId)).filter(generator -> generator != null);
        }
        return Stream.empty();
    }
}

