/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.plan;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerDeSerialInfo;

public class ExecutionPlanDeserializer<NODE extends DBCPlanNode> {
    public List<NODE> loadRoot(DBPDataSource datasource, JsonObject plan, DBCQueryPlannerDeSerialInfo<NODE> info) throws InvocationTargetException {
        String currSignature;
        String signature = plan.get("signature").getAsString();
        if (!signature.equals(currSignature = datasource.getInfo().getDriverName())) {
            throw new InvocationTargetException(new Throwable(String.format("Incorrect plan signature found - %s, expected - %s", signature, currSignature)));
        }
        ArrayList nodes = new ArrayList(1);
        plan.getAsJsonArray("root").forEach(e -> nodes.add(this.loadNode(datasource, e.getAsJsonObject(), null, info)));
        return nodes;
    }

    private NODE loadNode(DBPDataSource dataSource, JsonObject nodeObject, NODE parent, DBCQueryPlannerDeSerialInfo<NODE> info) {
        NODE node = info.createNode(dataSource, nodeObject, parent);
        JsonArray childs = nodeObject.getAsJsonArray("child");
        if (childs != null) {
            childs.forEach(e -> node.getNested().add(this.loadNode(dataSource, e.getAsJsonObject(), node, info)));
        }
        return node;
    }
}

