/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model.generic;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericTable;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerMetaModel;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;

public class SQLServerGenericSchema
extends GenericSchema
implements DBPObjectStatisticsCollector {
    private static final Log log = Log.getLog(SQLServerGenericSchema.class);
    private long schemaId;
    private boolean hasStatistics;

    public SQLServerGenericSchema(GenericDataSource dataSource, GenericCatalog catalog, String schemaName, long schemaId) {
        super(dataSource, catalog, schemaName);
        this.schemaId = schemaId;
    }

    @Property(viewable=true, order=3)
    public long getSchemaId() {
        return this.schemaId;
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public void collectObjectStatistics(@NotNull DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        boolean isSQLServer = ((SQLServerMetaModel)this.getDataSource().getMetaModel()).isSqlServer();
        if (!isSQLServer && !this.getDataSource().isServerVersionAtLeast(15, 0)) {
            this.hasStatistics = true;
            return;
        }
        GenericCatalog catalog = this.getCatalog();
        if (catalog == null) {
            log.debug((Object)"Can't read tables statistics due to lack of schemas catalog");
            return;
        }
        try {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table statistics");){
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (JDBCPreparedStatement dbStat = SQLServerUtils.prepareTableStatisticLoadStatement(session, (JDBCDataSource)this.getDataSource(), (DBSCatalog)catalog, this.getSchemaId(), null, isSQLServer);){
                        Throwable throwable3 = null;
                        Object var13_19 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            while (dbResult.next()) {
                                String tableName = dbResult.getString("name");
                                GenericTableBase table = this.getTable(monitor, tableName);
                                if (!(table instanceof SQLServerGenericTable)) continue;
                                ((SQLServerGenericTable)table).fetchTableStats(dbResult);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException("Error reading table statistics", (Throwable)e);
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }
}

