/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorListener;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.MultiPageAbstractEditor;

public abstract class MultiPageDatabaseEditor
extends MultiPageAbstractEditor
implements IDatabaseEditor,
DBPContextProvider {
    public static final String PARAMETER_ACTIVE_PAGE = "activePage";
    public static final String PARAMETER_ACTIVE_FOLDER = "activeFolder";
    private DatabaseEditorListener listener;

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    @Override
    public void dispose() {
        if (this.listener != null) {
            this.listener.dispose();
        }
        super.dispose();
    }

    public IDatabaseEditorInput getEditorInput() {
        return (IDatabaseEditorInput)super.getEditorInput();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.listener != null) {
            this.listener.dispose();
        }
        this.listener = new DatabaseEditorListener(this);
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.getEditorInput().getExecutionContext();
    }

    @Override
    protected void createPages() {
        super.createPages();
        DatabaseEditorUtils.setPartBackground(this, this.getContainer());
    }

    @Override
    protected void setContainerStyles() {
        super.setContainerStyles();
        Composite container = this.getContainer();
        if (container instanceof CTabFolder && !container.isDisposed()) {
            CSSUtils.markConnectionTypeColor((Widget)container);
        }
    }

    public boolean isActiveTask() {
        return false;
    }
}

