/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.commands;

import org.hampelratte.svdrp.Command;

public class PLUG
extends Command {
    private static final long serialVersionUID = 1L;
    private boolean mainSwitch = false;
    private boolean helpSwitch = false;
    private String pluginName = "";
    private String pluginCommand = "";
    private String options = "";

    public PLUG() {
    }

    public PLUG(String pluginName, String pluginCommand) {
        this.pluginName = pluginName;
        this.pluginCommand = pluginCommand;
    }

    public PLUG(String pluginName, boolean mainSwitch, boolean helpSwitch, String pluginCommand, String options) {
        this.mainSwitch = mainSwitch;
        this.helpSwitch = helpSwitch;
        this.pluginName = pluginName;
        this.pluginCommand = pluginCommand;
        this.options = options;
    }

    @Override
    public String getCommand() {
        StringBuilder sb = new StringBuilder("PLUG ");
        if (this.pluginName != null && this.pluginName.length() > 0) {
            sb.append(this.pluginName);
            if (this.mainSwitch) {
                sb.append(" MAIN");
            } else if (this.helpSwitch) {
                sb.append(" HELP");
            }
            if (this.pluginCommand != null && this.pluginCommand.length() > 0 && !this.mainSwitch) {
                sb.append(" ");
                sb.append(this.pluginCommand);
                if (this.options != null && this.options.length() > 0 && !this.helpSwitch && !this.mainSwitch) {
                    sb.append(" ");
                    sb.append(this.options);
                }
            }
        }
        return sb.toString().trim();
    }

    @Override
    public String toString() {
        return "PLUG";
    }

    public boolean isMainSwitch() {
        return this.mainSwitch;
    }

    public void setMainSwitch(boolean mainSwitch) {
        this.mainSwitch = mainSwitch;
        if (mainSwitch && this.helpSwitch) {
            this.helpSwitch = false;
        }
    }

    public boolean isHelpSwitch() {
        return this.helpSwitch;
    }

    public void setHelpSwitch(boolean helpSwitch) {
        this.helpSwitch = helpSwitch;
        if (helpSwitch && this.mainSwitch) {
            this.mainSwitch = false;
        }
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public String getPluginCommand() {
        return this.pluginCommand;
    }

    public void setPluginCommand(String pluginCommand) {
        this.pluginCommand = pluginCommand;
    }
}

