/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

// WorkloadSpecApplyConfiguration represents a declarative configuration of the WorkloadSpec type for use
// with apply.
//
// WorkloadSpec defines the desired state of a Workload.
type WorkloadSpecApplyConfiguration struct {
	// ControllerRef is an optional reference to the controlling object, such as a
	// Deployment or Job. This field is intended for use by tools like CLIs
	// to provide a link back to the original workload definition.
	// When set, it cannot be changed.
	ControllerRef *TypedLocalObjectReferenceApplyConfiguration `json:"controllerRef,omitempty"`
	// PodGroups is the list of pod groups that make up the Workload.
	// The maximum number of pod groups is 8. This field is immutable.
	PodGroups []PodGroupApplyConfiguration `json:"podGroups,omitempty"`
}

// WorkloadSpecApplyConfiguration constructs a declarative configuration of the WorkloadSpec type for use with
// apply.
func WorkloadSpec() *WorkloadSpecApplyConfiguration {
	return &WorkloadSpecApplyConfiguration{}
}

// WithControllerRef sets the ControllerRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ControllerRef field is set to the value of the last call.
func (b *WorkloadSpecApplyConfiguration) WithControllerRef(value *TypedLocalObjectReferenceApplyConfiguration) *WorkloadSpecApplyConfiguration {
	b.ControllerRef = value
	return b
}

// WithPodGroups adds the given value to the PodGroups field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the PodGroups field.
func (b *WorkloadSpecApplyConfiguration) WithPodGroups(values ...*PodGroupApplyConfiguration) *WorkloadSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithPodGroups")
		}
		b.PodGroups = append(b.PodGroups, *values[i])
	}
	return b
}
