// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_get_session_token_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::get_session_token::GetSessionTokenOutput, crate::operation::get_session_token::GetSessionTokenError> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::get_session_token::GetSessionTokenError::unhandled)?;
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::operation::get_session_token::GetSessionTokenError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RegionDisabledException" => crate::operation::get_session_token::GetSessionTokenError::RegionDisabledException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::RegionDisabledExceptionBuilder::default();
                output = crate::protocol_serde::shape_region_disabled_exception::de_region_disabled_exception_xml_err(_response_body, output)
                    .map_err(crate::operation::get_session_token::GetSessionTokenError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        _ => crate::operation::get_session_token::GetSessionTokenError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_get_session_token_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::get_session_token::GetSessionTokenOutput, crate::operation::get_session_token::GetSessionTokenError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::get_session_token::builders::GetSessionTokenOutputBuilder::default();
        output = crate::protocol_serde::shape_get_session_token::de_get_session_token(_response_body, output)
            .map_err(crate::operation::get_session_token::GetSessionTokenError::unhandled)?;
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

#[allow(unused_mut)]
pub fn de_get_session_token(
    inp: &[u8],
    mut builder: crate::operation::get_session_token::builders::GetSessionTokenOutputBuilder,
) -> Result<crate::operation::get_session_token::builders::GetSessionTokenOutputBuilder, ::aws_smithy_xml::decode::XmlDecodeError> {
    let mut doc = ::aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    #[allow(unused_variables)]
    let start_el = decoder.start_el();
    if !(start_el.matches("GetSessionTokenResponse")) {
        return Err(::aws_smithy_xml::decode::XmlDecodeError::custom(format!(
            "invalid root, expected GetSessionTokenResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetSessionTokenResult")) {
            return Err(::aws_smithy_xml::decode::XmlDecodeError::custom(format!(
                "invalid result, expected GetSessionTokenResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Credentials") /* Credentials com.amazonaws.sts.synthetic#GetSessionTokenOutput$Credentials */ =>  {
                let var_1 =
                    Some(
                        crate::protocol_serde::shape_credentials::de_credentials(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_credentials(var_1);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(::aws_smithy_xml::decode::XmlDecodeError::custom("expected GetSessionTokenResult tag"));
    };
    Ok(builder)
}
