### 📦 **Rust Coreutils 0.4.0 Release:**

We are pleased to announce the release of **Rust Coreutils 0.4.0** — continuing our journey toward full GNU compatibility with **improved test coverage**, **enhanced functionality**, and **robust implementations**!

---

### Highlights:

- **Enhanced GNU Compatibility**
  - **544 passing tests** (+12 from 0.3.0), achieving **85.80%** compatibility
  - Reduced failures from 68 to 56 (-12)
  - Major improvements to `cksum` with SHA2/SHA3 support and CRC32B fix
  - Better compatibility with GNU `date` timezone handling

- **Algorithm & Performance Improvements**
  - `factor`: Integrated num_prime crate for 15x faster u64/u128 factorization
  - `tsort`: Fixed stack overflow issues with iterative DFS implementation
  - `cksum`: Added comprehensive performance benchmarks
  - `mkdir`: Fixed stack overflow with deeply nested directories

- **Platform Support Enhancements**
  - OpenBSD support for `stdbuf` and `uptime`
  - FreeBSD build and test improvements
  - Better cross-platform compatibility

- **hashsum Reorganization**
  - Removed non-GNU binaries to fix interface divergence
  - Merged functionality into `cksum` for better GNU compatibility
  - Marked hashsum as deprecated in favor of cksum

- **Contributions**: This release was made possible by **4 new contributors** joining our community

---

### GNU Test Suite Compatibility:

| Result        | 0.3.0 | 0.4.0 | Change 0.3.0 to 0.4.0 | % Total 0.3.0 | % Total 0.4.0 | % Change 0.3.0 to 0.4.0 |
|---------------|-------|-------|------------------------|---------------|---------------|--------------------------|
| Pass          | 532   | 544   | +12                    | 83.91%        | 85.80%        | +1.89%                   |
| Skip          | 33    | 33    | 0                      | 5.20%         | 5.21%         | +0.01%                   |
| Fail          | 68    | 56    | -12                    | 10.73%        | 8.83%         | -1.90%                   |
| Error         | 1     | 1     | 0                      | 0.16%         | 0.16%         | 0%                       |
| Total         | 634   | 634   | 0                      |               |               |                          |

---

![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.svg?raw=true)

---

### Call to Action:

🌍 **Help us translate** - Contribute translations at [Weblate](https://hosted.weblate.org/projects/rust-coreutils/)
🚀 **Sponsor us on GitHub** to accelerate development: [github.com/sponsors/uutils](https://github.com/sponsors/uutils)
🔗 Download the latest release: [https://uutils.github.io](https://uutils.github.io)

## What's Changed

## base64
* Align base64 with GNU base64.pl tests by @karanabe in https://github.com/uutils/coreutils/pull/9194

## cat
* Fix EINTR handling in cat by @naoNao89 in https://github.com/uutils/coreutils/pull/8946
* fix(cat): refine unsafe overwrite detection for appending files by @mattsu2020 in https://github.com/uutils/coreutils/pull/9122

## chown
* Fix chown tests for FreeBSD and macOS by @akretz in https://github.com/uutils/coreutils/pull/9058

## cksum
* Refactor cksum for incoming merge with hashsum, Fix behavior for `--text` and `--untagged` by @RenjiSann in https://github.com/uutils/coreutils/pull/9024
* Fix "cksum: --length 0 shouldn't fail for algorithms that don't support --length" by @RenjiSann in https://github.com/uutils/coreutils/pull/9032
* Add support for sha2, sha3 by @RenjiSann in https://github.com/uutils/coreutils/pull/9035
* Fix GNU `cksum-c.sh` and `cksum-sha3.sh` by @RenjiSann in https://github.com/uutils/coreutils/pull/9063
* add cksum performance benchmarks by @naoNao89 in https://github.com/uutils/coreutils/pull/9075
* fix(cksum): correct CRC32B implementation to match GNU cksum by @naoNao89 in https://github.com/uutils/coreutils/pull/9026

## comm
* Fix EINTR handling in comm by @naoNao89 in https://github.com/uutils/coreutils/pull/8946
* hold the stdin lock for the whole duration of the program by @andreacorbellini in https://github.com/uutils/coreutils/pull/9085

## date
* fix(date): support timezone abbreviations in date --set by @naoNao89 in https://github.com/uutils/coreutils/pull/8944
* date, touch: fix parse_datetime 0.13.0 compatibility by @naoNao89 in https://github.com/uutils/coreutils/pull/8843
* improve compat with GNU by @sylvestre in https://github.com/uutils/coreutils/pull/9022
* remove `chrono` by @cakebaker in https://github.com/uutils/coreutils/pull/9048
* add --uct alias and allow multiple option aliases together by @sylvestre in https://github.com/uutils/coreutils/pull/9181

## dd
* fix(dd): handle O_DIRECT partial block writes by @naoNao89 in https://github.com/uutils/coreutils/pull/9016

## du
* fix dead code warnings in test on Android by @cakebaker in https://github.com/uutils/coreutils/pull/9131
* disable some benchmarks by @sylvestre in https://github.com/uutils/coreutils/pull/9167
* also disable du_human_balanced_tree as benchmark by @sylvestre in https://github.com/uutils/coreutils/pull/9198

## factor
* base benchmarking for single/multiple u64, u128, and >u128 by @asder8215 in https://github.com/uutils/coreutils/pull/9182
* use num_prime crate's u64 and u128 factorization methods to speed up the performance by @asder8215 in https://github.com/uutils/coreutils/pull/9171

## hashsum
* don't fail on dirs by @Ada-Armstrong in https://github.com/uutils/coreutils/pull/8930
* Remove non-GNU binaries (fix cksum interface divergence) by @oech3 in https://github.com/uutils/coreutils/pull/9153

## install
* fix the error message by @sylvestre in https://github.com/uutils/coreutils/pull/9188

## ls
* use file path for ACL check by @akretz in https://github.com/uutils/coreutils/pull/9055

## mkdir
* Fix stack overflow with deeply nested directories by @naoNao89 in https://github.com/uutils/coreutils/pull/8947
* remove `#[allow(unused_variables)]` by @cakebaker in https://github.com/uutils/coreutils/pull/9109

## od
* Fix EINTR handling in od by @naoNao89 in https://github.com/uutils/coreutils/pull/8946

## printenv
* add more tests by @ya7on in https://github.com/uutils/coreutils/pull/9151

## printf
* handle extremely large format widths gracefully to fix GNU test panic by @sylvestre in https://github.com/uutils/coreutils/pull/9133

## readlink
* fix(readlink): emit GNU-style Invalid argument for non-symlinks by @karanabe in https://github.com/uutils/coreutils/pull/9189

## stdbuf
* add support for OpenBSD by @lcheylus in https://github.com/uutils/coreutils/pull/9185

## timeout
* add missing extra help by @matttbe in https://github.com/uutils/coreutils/pull/9160

## truncate
* feat(truncate): allow negative size values for truncation by @mattsu2020 in https://github.com/uutils/coreutils/pull/9129

## tsort
* use iterative dfs to prevent stack overflows by @Nekrolm in https://github.com/uutils/coreutils/pull/8737
* fix minimal cycle reporting and precise back-edge removal by @naoNao89 in https://github.com/uutils/coreutils/pull/8786

## uptime
* Fix build and tests for uptime on OpenBSD by @lcheylus in https://github.com/uutils/coreutils/pull/9158
* fix clippy warning manual-let-else on OpenBSD by @lcheylus in https://github.com/uutils/coreutils/pull/9193

## uudoc
* respect SKIP_UTILS by @oech3 in https://github.com/uutils/coreutils/pull/8982
* Add example to manpage by @Its-Just-Nans in https://github.com/uutils/coreutils/pull/7841

## Documentation
* release notes: add 0.2.2 by @sylvestre in https://github.com/uutils/coreutils/pull/8998
* README: Fix coverage badge URL by @RenjiSann in https://github.com/uutils/coreutils/pull/9046
* README.md: Fix about manpage generation by @oech3 in https://github.com/uutils/coreutils/pull/8994
* README.md: Show how to build all individual bins by cargo by @oech3 in https://github.com/uutils/coreutils/pull/9069
* extensions.md: mark hashsum as deprecated by @oech3 in https://github.com/uutils/coreutils/pull/9089
* doc: rename file by @sylvestre in https://github.com/uutils/coreutils/pull/9208

## CI & Build
* chore(deps): update github artifact actions (major) by @renovate[bot] in https://github.com/uutils/coreutils/pull/8997
* publish script: add progress by @sylvestre in https://github.com/uutils/coreutils/pull/9008
* GNUmakefile: Add a value for cross-build by @oech3 in https://github.com/uutils/coreutils/pull/9015
* GNUmakefile: Don't install part of hashsum if we excluded hashsum by @oech3 in https://github.com/uutils/coreutils/pull/9036
* ci: remove `code_format` job from `FixPR` workflow by @cakebaker in https://github.com/uutils/coreutils/pull/9043
* Append .bash to completions by @oech3 in https://github.com/uutils/coreutils/pull/9049
* ci: remove deprecated `lima-actions/ssh` by @cakebaker in https://github.com/uutils/coreutils/pull/9054
* GNUmakefile: Do not use install -v by @oech3 in https://github.com/uutils/coreutils/pull/9051
* GNUmakefile: Reduce deps & minor cleanup by @oech3 in https://github.com/uutils/coreutils/pull/9065
* CICD.yml: stop ci for redox by @oech3 in https://github.com/uutils/coreutils/pull/9112
* ci: adapt template name for Lima v2.0 by @cakebaker in https://github.com/uutils/coreutils/pull/9159
* FreeBSD workflow: disable stats report for sccache action by @lcheylus in https://github.com/uutils/coreutils/pull/9156
* Fix test job in FreeBSD workflow by @lcheylus in https://github.com/uutils/coreutils/pull/9155
* GNUmakefile: Better comment for cross build by @oech3 in https://github.com/uutils/coreutils/pull/9186
* GNUmakefile: fix LOCALES=n by @oech3 in https://github.com/uutils/coreutils/pull/9034
* Fix tests on OpenBSD for unix feature by @lcheylus in https://github.com/uutils/coreutils/pull/9200

## Code Quality & Cleanup
* fix: make visible alias by @Its-Just-Nans in https://github.com/uutils/coreutils/pull/9041
* fix: show ignored args by @Its-Just-Nans in https://github.com/uutils/coreutils/pull/9040
* rustdoc: fix broken intra doc links by @cakebaker in https://github.com/uutils/coreutils/pull/9097
* clippy: re-enable `unnecessary_semicolon` lint by @cakebaker in https://github.com/uutils/coreutils/pull/9143
* Remove `test_keys2` binary by @cakebaker in https://github.com/uutils/coreutils/pull/9183
* Typo by @sylvestre in https://github.com/uutils/coreutils/pull/9197

## Performance & Benchmarking
* bench: remove 'sort_random_strings' by @sylvestre in https://github.com/uutils/coreutils/pull/9030
* bench: tsort_input_parsing_heavy reduce the input side by @sylvestre in https://github.com/uutils/coreutils/pull/9067
* Fix base64 benchmarks by @akretz in https://github.com/uutils/coreutils/pull/9082
* Revert "Fix base64 benchmarks" by @sylvestre in https://github.com/uutils/coreutils/pull/9139
* Disable variance-heavy benchmark tests by @sylvestre in https://github.com/uutils/coreutils/pull/9201

## Version Management
* prepare version 0.4.0 by @sylvestre in https://github.com/uutils/coreutils/pull/9205

## Dependency Updates
* be prescriptive on the codspeed-divan-compat version by @sylvestre in https://github.com/uutils/coreutils/pull/9007
* Bump `linux-raw-sys` from `0.11` to `0.12` by @cakebaker in https://github.com/uutils/coreutils/pull/9019
* chore(deps): update rust crate bstr to v1.12.1 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9038
* chore(deps): update rust crate indicatif to v0.18.2 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9053
* chore(deps): update rust crate hex-literal to v1.1.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9077
* chore(deps): update rust crate clap to v4.5.51 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9079
* chore(deps): update rust crate clap_complete to v4.5.60 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9087
* chore(deps): update rust crate crc-fast to v1.6.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9095
* chore(deps): update vmactions/freebsd-vm action to v1.2.5 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9121
* chore(deps): update rust crate ctor to v0.6.1 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9130
* chore(deps): update rust crate quote to v1.0.42 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9165
* chore(deps): update reactivecircus/android-emulator-runner action to v2.35.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9169
* chore(deps): update rust crate jiff to v0.2.16 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9175
* chore(deps): update rust crate divan to v4.1.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9179
* chore(deps): update rust crate crc-fast to v1.7.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9180
* chore(deps): update vmactions/freebsd-vm action to v1.2.6 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9192
* chore(deps): update rust crate parse_datetime to v0.13.2 by @renovate[bot] in https://github.com/uutils/coreutils/pull/9207

## New Contributors
* @akretz made their first contribution in https://github.com/uutils/coreutils/pull/9058
* @andreacorbellini made their first contribution in https://github.com/uutils/coreutils/pull/9085
* @ya7on made their first contribution in https://github.com/uutils/coreutils/pull/9151
* @matttbe made their first contribution in https://github.com/uutils/coreutils/pull/9160

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.3.0...0.4.0
