/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.registry;

import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferPageType;
import org.jkiss.utils.CommonUtils;

public class DataTransferPageDescriptor
extends AbstractDescriptor {
    private final String id;
    private final boolean producerSelector;
    private final boolean consumerSelector;
    private final String producerType;
    private final String consumerType;
    private final DataTransferPageType pageType;
    private final AbstractDescriptor.ObjectType pageClass;

    DataTransferPageDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.pageClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.producerSelector = CommonUtils.toBoolean((Object)config.getAttribute("producerSelector"));
        this.consumerSelector = CommonUtils.toBoolean((Object)config.getAttribute("consumerSelector"));
        this.producerType = config.getAttribute("producerType");
        this.consumerType = config.getAttribute("consumerType");
        String typeStr = config.getAttribute("type");
        this.pageType = CommonUtils.isEmpty((String)typeStr) ? DataTransferPageType.NORMAL : DataTransferPageType.valueOf(typeStr.toUpperCase(Locale.ENGLISH));
    }

    public String getId() {
        return this.id;
    }

    public AbstractDescriptor.ObjectType getPageClass() {
        return this.pageClass;
    }

    public boolean isProducerSelector() {
        return this.producerSelector;
    }

    public boolean isConsumerSelector() {
        return this.consumerSelector;
    }

    public String getProducerType() {
        return this.producerType;
    }

    public String getConsumerType() {
        return this.consumerType;
    }

    public DataTransferPageType getPageType() {
        return this.pageType;
    }

    public String toString() {
        return this.id;
    }
}

