/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources.shortcuts;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;

public class ShortcutsHandlerImpl
extends AbstractResourceHandler {
    public void openResource(@NotNull IResource resource) throws CoreException, DBException {
        try {
            File path = resource.getLocation().toFile();
            File resolved = ShortcutsHandlerImpl.resolve(path);
            if (resolved.exists()) {
                EditorUtils.openExternalFileEditor((File)resolved, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow());
            } else if (DBWorkbench.getPlatformUI().confirmAction(CoreMessages.resource_shortcut_deleted_title, NLS.bind((String)CoreMessages.resource_shortcut_deleted_message, (Object)resolved.getName()))) {
                resource.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (IOException e) {
            throw new DBException("Error resolving shell link path", (Throwable)e);
        }
    }

    public int getFeatures(IResource resource) {
        if (resource instanceof IFile) {
            return 11;
        }
        return super.getFeatures(resource);
    }

    @NotNull
    private static File resolve(@NotNull File shellLinkFile) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(Files.readAllBytes(shellLinkFile.toPath())).order(ByteOrder.LITTLE_ENDIAN);
        if ((buf.getInt(20) & 1) > 0) {
            buf.position(buf.getInt(0) + buf.getShort(76) + 2);
        } else {
            buf.position(24);
        }
        boolean unicode = buf.getInt(buf.position() + 4) >= 36;
        StringBuilder path = new StringBuilder();
        buf.position(buf.position() + buf.getInt(buf.position() + (unicode ? 28 : 16)));
        do {
            char ch;
            char c = ch = unicode ? buf.getChar() : (char)buf.get();
            if (ch == '\u0000') break;
            path.append(ch);
        } while (path.length() <= 260);
        return new File(path.toString());
    }
}

