/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.altibase.AltibaseConstants;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class AltibaseUtils {
    static final Log log = Log.getLog(AltibaseUtils.class);

    public static <PARENT extends DBSObject> Object resolveLazyReference(DBRProgressMonitor monitor, PARENT parent, DBSObjectCache<PARENT, ?> cache, DBSObjectLazy<?> referrer, Object propertyId) throws DBException {
        Object reference = referrer.getLazyReference(propertyId);
        if (reference instanceof String) {
            DBSObject object = monitor != null ? cache.getObject(monitor, parent, (String)reference) : cache.getCachedObject((String)reference);
            if (object != null) {
                return object;
            }
            log.warn((Object)("Object '" + String.valueOf(reference) + "' not found"));
            return reference;
        }
        return reference;
    }

    public static boolean getViewStatus(JDBCSession session, String tableType, String schemaName, String objName) throws DBCException {
        boolean isValid = false;
        String qry = null;
        qry = "MATERIALIZED VIEW".equals(tableType) ? "SELECT v.status FROM system_.sys_users_ u, system_.sys_materialized_views_ m, system_.sys_views_ v WHERE u.user_id = m.user_id AND u.user_id = v.user_id AND v.view_id = m.view_id AND u.user_name = ? AND m.mview_name = ?" : "SELECT v.status FROM system_.sys_users_ u, system_.sys_tables_ t, system_.sys_views_ v WHERE u.user_id = t.user_id AND u.user_id = v.user_id AND v.view_id = t.table_id AND u.user_name = ? AND t.table_name = ?";
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement(qry);){
                dbStat.setString(1, schemaName);
                dbStat.setString(2, objName);
                dbStat.executeStatement();
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (JDBCResultSet dbResult = dbStat.getResultSet();){
                    if (dbResult != null && dbResult.next()) {
                        isValid = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (int)1, (String)"0");
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
        return isValid;
    }

    public static String getDmbsMetaDataObjTypeName(String objTypeName) {
        if (CommonUtils.isEmpty((String)objTypeName)) {
            return "UNKNOWN_OBJECT_TYPE";
        }
        return objTypeName.replaceAll(" ", "_");
    }

    private static int getEffectiveSqlLineNumber(String[] script) {
        int i = 0;
        String[] stringArray = script;
        int n = script.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line != null && line.trim().length() > 0 && !line.stripLeading().startsWith("--")) {
                return i;
            }
            ++i;
            ++n2;
        }
        return i;
    }

    public static String getEffectiveSql(String script) {
        StringBuilder ddl = new StringBuilder();
        String[] lines = script.split("\\R");
        int i = 0;
        int length = lines.length;
        i = AltibaseUtils.getEffectiveSqlLineNumber(lines);
        while (i < length) {
            ddl.append(lines[i]).append(AltibaseConstants.NEW_LINE);
            ++i;
        }
        int last = ddl.length() - AltibaseConstants.NEW_LINE.length();
        return ddl.substring(0, last);
    }
}

