/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.prototype;

import com.github.weisj.jsvg.attributes.Coordinate;
import com.github.weisj.jsvg.attributes.transform.TransformBox;
import com.github.weisj.jsvg.attributes.value.LengthValue;
import com.github.weisj.jsvg.attributes.value.TransformValue;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.renderer.ElementBounds;
import com.github.weisj.jsvg.renderer.Output;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.util.ShapeUtil;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Transformable {
    default public boolean shouldTransform() {
        return true;
    }

    @Nullable
    public TransformValue transform();

    @NotNull
    public Coordinate<LengthValue> transformOrigin();

    public TransformBox transformBox();

    @Nullable
    default public AffineTransform effectiveTransform(@NotNull RenderContext context, @NotNull ElementBounds bounds) {
        TransformValue transformValue = this.transform();
        if (transformValue == null) {
            return null;
        }
        Coordinate<LengthValue> origin = this.transformOrigin();
        double xOffset = 0.0;
        double yOffset = 0.0;
        MeasureContext measureContext = context.measureContext();
        switch (this.transformBox()) {
            case FillBox: {
                Rectangle2D fillBox = bounds.fillBox();
                measureContext = measureContext.derive((float)fillBox.getWidth(), (float)fillBox.getHeight());
                xOffset = fillBox.getX();
                yOffset = fillBox.getY();
                break;
            }
            case StrokeBox: {
                Rectangle2D strokeBox = bounds.strokeBox();
                measureContext = measureContext.derive((float)strokeBox.getWidth(), (float)strokeBox.getHeight());
                xOffset = strokeBox.getX();
                yOffset = strokeBox.getY();
                break;
            }
        }
        double xOrigin = (double)origin.x().resolve(measureContext) + xOffset;
        double yOrigin = (double)origin.y().resolve(measureContext) + yOffset;
        AffineTransform conjugate = AffineTransform.getTranslateInstance(xOrigin, yOrigin);
        conjugate.concatenate(transformValue.get(measureContext));
        conjugate.translate(-xOrigin, -yOrigin);
        return conjugate;
    }

    default public void applyTransform(@NotNull Output output, @NotNull RenderContext context, @NotNull ElementBounds bounds) {
        AffineTransform transform = this.effectiveTransform(context, bounds);
        if (transform == null) {
            return;
        }
        output.applyTransform(transform);
        context.userSpaceTransform().concatenate(transform);
    }

    default public Shape transformShape(@NotNull Shape shape, @NotNull RenderContext renderContext, @NotNull ElementBounds elementBounds) {
        AffineTransform transform = this.effectiveTransform(renderContext, elementBounds);
        if (transform == null) {
            return shape;
        }
        return ShapeUtil.transformShape(shape, transform);
    }
}

