/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.io;

import java.nio.charset.Charset;
import org.jkiss.code.NotNull;

public final class ByteOrderMark
extends Enum<ByteOrderMark>
implements Comparable<ByteOrderMark> {
    public static final /* enum */ ByteOrderMark UTF_8 = new ByteOrderMark("UTF-8", new int[]{239, 187, 191});
    public static final /* enum */ ByteOrderMark UTF_16BE = new ByteOrderMark("UTF-16BE", new int[]{254, 255});
    public static final /* enum */ ByteOrderMark UTF_16LE = new ByteOrderMark("UTF-16LE", new int[]{255, 254});
    public static final /* enum */ ByteOrderMark UTF_32BE;
    public static final /* enum */ ByteOrderMark UTF_32LE;
    private final String charsetName;
    private final int[] bytes;
    private static final /* synthetic */ ByteOrderMark[] ENUM$VALUES;

    static {
        int[] nArray = new int[4];
        nArray[2] = 254;
        nArray[3] = 255;
        UTF_32BE = new ByteOrderMark("UTF-32BE", nArray);
        int[] nArray2 = new int[4];
        nArray2[0] = 255;
        nArray2[1] = 254;
        UTF_32LE = new ByteOrderMark("UTF-32LE", nArray2);
        ENUM$VALUES = new ByteOrderMark[]{UTF_8, UTF_16BE, UTF_16LE, UTF_32BE, UTF_32LE};
    }

    private ByteOrderMark(String charsetName, int[] bytes) {
        this.charsetName = charsetName;
        this.bytes = bytes;
    }

    @NotNull
    public String getCharsetName() {
        return this.charsetName;
    }

    @NotNull
    public byte[] getBytes() {
        byte[] buffer = new byte[this.bytes.length];
        int index = 0;
        while (index < this.bytes.length) {
            buffer[index] = (byte)(this.bytes[index] & 0xFF);
            ++index;
        }
        return buffer;
    }

    public int get(int position) {
        return this.bytes[position];
    }

    public int length() {
        return this.bytes.length;
    }

    @NotNull
    public static ByteOrderMark fromCharset(@NotNull Charset charset) {
        return ByteOrderMark.fromCharset(charset.name());
    }

    @NotNull
    public static ByteOrderMark fromCharset(@NotNull String charsetName) {
        ByteOrderMark[] byteOrderMarkArray = ByteOrderMark.values();
        int n = byteOrderMarkArray.length;
        int n2 = 0;
        while (n2 < n) {
            ByteOrderMark bom = byteOrderMarkArray[n2];
            if (bom.charsetName.equalsIgnoreCase(charsetName)) {
                return bom;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Can't find BOM for charset " + charsetName);
    }

    public static ByteOrderMark[] values() {
        ByteOrderMark[] byteOrderMarkArray = ENUM$VALUES;
        int n = byteOrderMarkArray.length;
        ByteOrderMark[] byteOrderMarkArray2 = new ByteOrderMark[n];
        System.arraycopy(ENUM$VALUES, 0, byteOrderMarkArray2, 0, n);
        return byteOrderMarkArray2;
    }

    public static ByteOrderMark valueOf(String string) {
        return Enum.valueOf(ByteOrderMark.class, string);
    }
}

