/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdDataSource;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdFieldType;
import org.jkiss.dbeaver.ext.generic.model.GenericDataType;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.meta.Property;

public class FireBirdDataType
extends GenericDataType
implements DBPSystemObject {
    private final FireBirdFieldType fieldType;
    private final int subType;
    private int fieldLength;
    private int charLength;
    private String computedSource;
    private String validationSource;
    private String defaultSource;
    private String charsetName;
    private boolean notNull;

    public FireBirdDataType(FireBirdDataSource genericDataSource, FireBirdFieldType fieldType, int subType, String name, String remarks, boolean unsigned, boolean searchable, int precision, int minScale, int maxScale, int fieldLength, int charLength, String computedSource, String validationSource, String defaultSource, String charsetName, boolean notNull) {
        super((GenericStructContainer)genericDataSource, fieldType.getValueType(), name, remarks, unsigned, searchable, precision, minScale, maxScale);
        this.fieldType = fieldType;
        this.subType = subType;
        this.fieldLength = fieldLength;
        this.charLength = charLength;
        this.computedSource = computedSource;
        this.validationSource = validationSource;
        this.defaultSource = defaultSource;
        this.charsetName = charsetName;
        this.notNull = notNull;
    }

    public FireBirdDataType(FireBirdDataSource dataSource, FireBirdFieldType fieldType) {
        super((GenericStructContainer)dataSource, fieldType.getValueType(), fieldType.getName(), null, false, true, 0, 0, 0);
        this.fieldType = fieldType;
        this.subType = 0;
    }

    @NotNull
    public DBPDataKind getDataKind() {
        if (this.fieldType == FireBirdFieldType.CHAR && ("OCTETS".equals(this.charsetName) || "BINARY".equals(this.charsetName))) {
            return DBPDataKind.BINARY;
        }
        return super.getDataKind();
    }

    @Property(order=70)
    public int getSubType() {
        return this.subType;
    }

    @Property(order=50)
    public String getValidationSource() {
        return this.validationSource;
    }

    @Property(order=51)
    public String getComputedSource() {
        return this.computedSource;
    }

    @Property(order=45)
    public String getDefaultSource() {
        return this.defaultSource;
    }

    @Property(order=60)
    public String getCharsetName() {
        return this.charsetName;
    }

    @Property(order=16)
    public String getFieldType() {
        return this.fieldType.getName();
    }

    @Property(order=17)
    public int getFieldLength() {
        return this.fieldLength;
    }

    @Property(order=18)
    public int getCharLength() {
        return this.charLength;
    }

    @Property(order=19)
    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean isSystem() {
        return this.getTypeName().contains("$");
    }
}

