/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.content;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ColumnInfoPanel;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.data.IStreamValueManager;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditorStandalone;
import org.jkiss.dbeaver.ui.data.managers.stream.TextStreamValueManager;
import org.jkiss.dbeaver.ui.data.registry.StreamValueManagerDescriptor;
import org.jkiss.dbeaver.ui.data.registry.ValueManagerRegistry;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.editors.MultiPageAbstractEditor;
import org.jkiss.dbeaver.ui.editors.content.ContentEditorInput;
import org.jkiss.dbeaver.ui.editors.content.ContentEditorSite;
import org.jkiss.dbeaver.ui.editors.content.ContentPagePart;
import org.jkiss.dbeaver.ui.editors.content.SelectContentPartDialog;

public class ContentEditor
extends MultiPageAbstractEditor
implements IValueEditorStandalone,
IRefreshablePart {
    private static final Log log = Log.getLog(ContentEditor.class);
    private List<ContentPartInfo> contentParts = new ArrayList<ContentPartInfo>();
    private ColumnInfoPanel infoPanel;
    private boolean dirty;
    private boolean partsLoaded;
    private boolean saveInProgress;

    public ContentEditorInput getEditorInput() {
        return (ContentEditorInput)super.getEditorInput();
    }

    @Nullable
    public static ContentEditor openEditor(IValueController valueController) {
        ContentEditorInput editorInput;
        try {
            LOBInitializer initializer = new LOBInitializer(valueController);
            UIUtils.runInProgressService((DBRRunnableWithProgress)initializer);
            editorInput = initializer.editorInput;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            DBWorkbench.getPlatformUI().showError("Cannot open content editor", null, e);
            return null;
        }
        try {
            return (ContentEditor)valueController.getValueSite().getWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, ContentEditor.class.getName());
        }
        catch (PartInitException e) {
            log.error((Object)"Can't open CONTENT editorPart", (Throwable)e);
            return null;
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.isDirty()) {
            return;
        }
        UIUtils.syncExec(() -> {
            try {
                ArrayList<IEditorPart> dirtyParts = new ArrayList<IEditorPart>();
                for (ContentPartInfo partInfo : this.contentParts) {
                    if (!partInfo.activated || !partInfo.editorPart.isDirty()) continue;
                    dirtyParts.add(partInfo.editorPart);
                }
                IEditorPart dirtyPart = null;
                if (!dirtyParts.isEmpty()) {
                    dirtyPart = dirtyParts.size() == 1 ? (IEditorPart)dirtyParts.get(0) : SelectContentPartDialog.selectContentPart(this.getSite().getShell(), dirtyParts);
                }
                if (dirtyPart != null) {
                    this.saveInProgress = true;
                    try {
                        dirtyPart.doSave(monitor);
                    }
                    finally {
                        this.saveInProgress = false;
                    }
                }
                this.dirty = true;
                ContentEditorInput editorInput = this.getEditorInput();
                editorInput.updateContentFromFile((DBRProgressMonitor)new DefaultProgressMonitor(monitor), editorInput.getValue());
                editorInput.getValueController().updateValue(editorInput.getValue(), true);
                UIUtils.asyncExec(this::closeValueEditor);
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Can't save content", "Can't save content to database", (Throwable)e);
            }
        });
    }

    public void doSaveAs() {
        Shell shell = this.getSite().getShell();
        File saveFile = DialogUtils.selectFileForSave((Shell)shell, (String)this.getPartName());
        if (saveFile == null) {
            return;
        }
        try {
            this.getSite().getWorkbenchWindow().run(true, true, monitor -> {
                try {
                    this.getEditorInput().saveToExternalFile(saveFile, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Can't save content", "Can't save content to file '" + saveFile.getAbsolutePath() + "'", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(input.getName());
        IEditorPart[] editorParts = this.getEditorInput().getEditors();
        if (editorParts != null) {
            IEditorPart[] iEditorPartArray = editorParts;
            int n = editorParts.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart editorPart = iEditorPartArray[n2];
                this.contentParts.add(new ContentPartInfo((IEditorPart)new ContentPagePart(editorPart), editorPart == this.getEditorInput().getDefaultEditor()));
                ++n2;
            }
        }
    }

    @Override
    public void dispose() {
        this.partsLoaded = true;
        if (this.getEditorInput() != null) {
            try {
                this.getEditorInput().release();
            }
            catch (Throwable e) {
                log.warn((Object)"Error releasing CONTENT input", e);
            }
        }
        super.dispose();
    }

    @Override
    public boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        for (ContentPartInfo contentPart : this.contentParts) {
            if (!contentPart.activated || !contentPart.editorPart.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return new ContentEditorSite(this, editor);
    }

    protected void createPages() {
        super.createPages();
        ContentPartInfo defaultPage = null;
        for (ContentPartInfo contentPart : this.contentParts) {
            if (contentPart.isDefault) {
                defaultPage = contentPart;
            }
            IEditorPart editorPart = contentPart.editorPart;
            try {
                int index = this.addPage(editorPart, (IEditorInput)this.getEditorInput());
                this.setPageText(index, editorPart.getTitle());
                this.setPageImage(index, editorPart.getTitleImage());
                contentPart.activated = true;
                contentPart.index = index;
            }
            catch (PartInitException e) {
                log.error((Object)e);
            }
        }
        if (defaultPage != null) {
            this.setActiveEditor(defaultPage.editorPart);
        }
        this.partsLoaded = true;
    }

    public void removePage(int pageIndex) {
        for (ContentPartInfo contentPart : this.contentParts) {
            if (contentPart.index == pageIndex) {
                contentPart.index = -1;
                continue;
            }
            if (contentPart.index <= pageIndex) continue;
            --contentPart.index;
        }
        super.removePage(pageIndex);
    }

    protected Composite createPageContainer(Composite parent) {
        CustomSashForm panel = UIUtils.createPartDivider((IWorkbenchPart)this, (Composite)parent, (int)512);
        if (parent.getLayout() instanceof GridLayout) {
            panel.setLayoutData((Object)new GridData(1808));
        }
        IValueController valueController = this.getValueController();
        assert (valueController != null);
        this.infoPanel = new ColumnInfoPanel((Composite)panel, 0, valueController);
        GridData gd = new GridData(768);
        gd.exclude = true;
        this.infoPanel.setLayoutData(gd);
        Composite editorPanel = new Composite((Composite)panel, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        editorPanel.setLayout((Layout)layout);
        editorPanel.setLayoutData((Object)new GridData(1808));
        panel.setMaximizedControl((Control)editorPanel);
        return editorPanel;
    }

    void toggleInfoBar() {
        boolean visible;
        SashForm sashForm = (SashForm)this.infoPanel.getParent();
        boolean bl = visible = sashForm.getMaximizedControl() == null;
        if (visible) {
            sashForm.setMaximizedControl(sashForm.getChildren()[1]);
        } else {
            sashForm.setMaximizedControl(null);
            this.infoPanel.layoutProperties();
        }
    }

    @Nullable
    Object getValue() {
        IValueController valueController = this.getValueController();
        return valueController == null ? null : valueController.getValue();
    }

    @Nullable
    public IValueController getValueController() {
        ContentEditorInput input = this.getEditorInput();
        return input == null ? null : input.getValueController();
    }

    @Override
    public void createControl() {
    }

    @Override
    public Control getControl() {
        return super.getContainer();
    }

    @Override
    public Object extractEditorValue() throws DBException {
        UIUtils.runInUI(monitor -> {
            try {
                this.getEditorInput().updateContentFromFile(monitor, this.getEditorInput().getValue());
            }
            catch (DBException e) {
                throw new InvocationTargetException(e);
            }
        });
        return this.getEditorInput().getValue();
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        ContentEditorInput input = this.getEditorInput();
        IValueController valueController = input.getValueController();
        LOBInitializer initializer = new LOBInitializer(valueController, input.getEditors(), input.getDefaultEditor(), input);
        try {
            UIUtils.runInProgressService((DBRRunnableWithProgress)initializer);
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Cannot refresh content editor", null, (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public boolean isReadOnly() {
        return this.getEditorInput().isReadOnly();
    }

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller) throws DBCException {
    }

    @Override
    public void showValueEditor() {
        this.getEditorSite().getWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this);
    }

    @Override
    public void closeValueEditor() {
        IWorkbenchPage workbenchPage;
        IWorkbenchWindow workbenchWindow = this.getEditorSite().getWorkbenchWindow();
        if (workbenchWindow != null && (workbenchPage = workbenchWindow.getActivePage()) != null) {
            workbenchPage.closeEditor((IEditorPart)this, false);
        }
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        this.getEditorInput().refreshContentParts(source);
        this.fireContentChanged();
        return IRefreshablePart.RefreshResult.REFRESHED;
    }

    public void fireContentChanged() {
        this.firePropertyChange(257);
    }

    static class ContentPartInfo {
        IEditorPart editorPart;
        boolean isDefault;
        boolean activated;
        public int index = -1;

        private ContentPartInfo(IEditorPart editorPart, boolean isDefault) {
            this.editorPart = editorPart;
            this.isDefault = isDefault;
        }
    }

    private static class LOBInitializer
    implements DBRRunnableWithProgress {
        IValueController valueController;
        Object value;
        IEditorPart[] editorParts;
        IEditorPart defaultPart;
        ContentEditorInput editorInput;

        public LOBInitializer(IValueController valueController) {
            this.valueController = valueController;
            this.value = valueController.getValue();
        }

        private LOBInitializer(IValueController valueController, IEditorPart[] editorParts, IEditorPart defaultPart, @Nullable ContentEditorInput editorInput) {
            this.valueController = valueController;
            this.editorParts = editorParts;
            this.defaultPart = defaultPart;
            this.editorInput = editorInput;
        }

        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                if (this.editorParts == null) {
                    ArrayList<IEditorPart> parts = new ArrayList<IEditorPart>();
                    if (this.value instanceof String || this.valueController.getValueType().getDataKind() == DBPDataKind.STRING) {
                        TextStreamValueManager valueManager = new TextStreamValueManager();
                        this.defaultPart = valueManager.createEditorPart(this.valueController);
                        parts.add(this.defaultPart);
                    } else if (this.value instanceof DBDContent || this.valueController.getValueType().getDataKind() == DBPDataKind.CONTENT || this.valueController.getValueType().getDataKind() == DBPDataKind.BINARY) {
                        monitor.beginTask("Initialize stream value manager", 1);
                        DBDContent content = (DBDContent)this.value;
                        Map<StreamValueManagerDescriptor, IStreamValueManager.MatchType> streamManagers = ValueManagerRegistry.getInstance().getApplicableStreamManagers(monitor, this.valueController.getValueType(), content);
                        IStreamValueManager.MatchType defaultMatch = null;
                        for (Map.Entry<StreamValueManagerDescriptor, IStreamValueManager.MatchType> entry : streamManagers.entrySet()) {
                            IStreamValueManager streamValueManager = entry.getKey().getInstance();
                            try {
                                IEditorPart editorPart = streamValueManager.createEditorPart(this.valueController);
                                IStreamValueManager.MatchType matchType = entry.getValue();
                                if (this.defaultPart == null) {
                                    this.defaultPart = editorPart;
                                    defaultMatch = matchType;
                                } else {
                                    boolean setDefault = false;
                                    switch (matchType) {
                                        case EXCLUSIVE: 
                                        case PRIMARY: {
                                            setDefault = true;
                                            break;
                                        }
                                        case DEFAULT: {
                                            setDefault = defaultMatch == IStreamValueManager.MatchType.APPLIES;
                                            break;
                                        }
                                    }
                                    if (setDefault) {
                                        this.defaultPart = editorPart;
                                        defaultMatch = matchType;
                                    }
                                }
                                parts.add(editorPart);
                            }
                            catch (DBException e) {
                                log.error((Object)e);
                            }
                        }
                        monitor.done();
                    }
                    this.editorParts = parts.toArray(new IEditorPart[0]);
                }
                if (this.editorInput == null) {
                    this.editorInput = new ContentEditorInput(this.valueController, this.editorParts, this.defaultPart, monitor);
                } else {
                    this.editorInput.refreshContent(monitor, this.valueController);
                }
            }
            catch (DBException e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

