/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.Subgraph;

class NestingTree {
    List<Object> contents = new ArrayList<Object>();
    boolean isLeaf = true;
    int size;
    double sortValue;
    Node subgraph;

    NestingTree() {
    }

    private static void addToNestingTree(Map<Subgraph, NestingTree> map, Node child) {
        Subgraph subgraph = child.getParent();
        NestingTree parent = map.get(subgraph);
        if (parent == null) {
            parent = new NestingTree();
            parent.subgraph = subgraph;
            map.put(subgraph, parent);
            if (subgraph != null) {
                NestingTree.addToNestingTree(map, parent);
            }
        }
        parent.contents.add(child);
    }

    private static void addToNestingTree(Map<Subgraph, NestingTree> map, NestingTree branch) {
        Subgraph subgraph = branch.subgraph.getParent();
        NestingTree parent = map.get(subgraph);
        if (parent == null) {
            parent = new NestingTree();
            parent.subgraph = subgraph;
            map.put(subgraph, parent);
            if (subgraph != null) {
                NestingTree.addToNestingTree(map, parent);
            }
        }
        parent.contents.add(branch);
    }

    static NestingTree buildNestingTreeForRank(Rank rank) {
        HashMap<Subgraph, NestingTree> nestingMap = new HashMap<Subgraph, NestingTree>();
        int j = 0;
        while (j < rank.count()) {
            Node node = (Node)rank.get(j);
            NestingTree.addToNestingTree(nestingMap, node);
            ++j;
        }
        return (NestingTree)nestingMap.get(null);
    }

    void calculateSortValues() {
        int total = 0;
        for (Object o : this.contents) {
            if (o instanceof NestingTree) {
                NestingTree e = (NestingTree)o;
                this.isLeaf = false;
                e.calculateSortValues();
                total += (int)(e.sortValue * (double)e.size);
                this.size += e.size;
                continue;
            }
            Node n = (Node)o;
            n.sortValue = n.index;
            total += n.index;
            ++this.size;
        }
        this.sortValue = (double)total / (double)this.size;
    }

    void getSortValueFromSubgraph() {
        if (this.subgraph != null) {
            this.sortValue = this.subgraph.sortValue;
        }
        for (Object o : this.contents) {
            if (!(o instanceof NestingTree)) continue;
            ((NestingTree)o).getSortValueFromSubgraph();
        }
    }

    void recursiveSort(boolean sortLeaves) {
        if (this.isLeaf && !sortLeaves) {
            return;
        }
        boolean change = false;
        do {
            change = false;
            int i = 0;
            while (i < this.contents.size() - 1) {
                change |= this.swap(i);
                ++i;
            }
            if (!change) break;
            change = false;
            i = this.contents.size() - 2;
            while (i >= 0) {
                change |= this.swap(i);
                --i;
            }
        } while (change);
        for (Object o : this.contents) {
            if (!(o instanceof NestingTree)) continue;
            NestingTree nt = (NestingTree)o;
            nt.recursiveSort(sortLeaves);
        }
    }

    void repopulateRank(Rank r) {
        for (Object o : this.contents) {
            if (o instanceof Node) {
                Node node = (Node)o;
                r.add(node);
                continue;
            }
            ((NestingTree)o).repopulateRank(r);
        }
    }

    boolean swap(int index) {
        double iR;
        double iL;
        Object left = this.contents.get(index);
        Object right = this.contents.get(index + 1);
        if (left instanceof Node) {
            Node node = (Node)left;
            v0 = node.sortValue;
        } else {
            v0 = iL = ((NestingTree)left).sortValue;
        }
        if (right instanceof Node) {
            Node node = (Node)right;
            v1 = node.sortValue;
        } else {
            v1 = iR = ((NestingTree)right).sortValue;
        }
        if (iL <= iR) {
            return false;
        }
        this.contents.set(index, right);
        this.contents.set(index + 1, left);
        return true;
    }

    public String toString() {
        return "Nesting:" + String.valueOf(this.subgraph);
    }
}

