/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class WorkspaceConfigEventManager {
    private static final Object syncRoot = new Object();
    private static final Map<String, Set<Consumer<Object>>> listenersByConfigFile = new HashMap<String, Set<Consumer<Object>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfigChangedListener(String configFileName, Consumer<Object> listener) {
        Object object = syncRoot;
        synchronized (object) {
            listenersByConfigFile.computeIfAbsent(configFileName, x -> new LinkedHashSet()).add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConfigChangedListener(String configFileName, Consumer<Object> listener) {
        Object object = syncRoot;
        synchronized (object) {
            Set<Consumer<Object>> listeners = listenersByConfigFile.get(configFileName);
            if (listeners != null) {
                listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireConfigChangedEvent(String configFileName) {
        List<Consumer<Object>> listenersList;
        Object object = syncRoot;
        synchronized (object) {
            Set<Consumer<Object>> listeners = listenersByConfigFile.get(configFileName);
            listenersList = listeners != null ? List.copyOf(listeners) : null;
        }
        if (listenersList != null) {
            for (Consumer<Object> listener : listenersList) {
                listener.accept(null);
            }
        }
    }
}

