/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.qm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMEventAction;
import org.jkiss.dbeaver.model.qm.QMEventFilter;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.qm.DefaultEventFilter;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class QMLogFileWriter
implements QMMetaListener,
DBPPreferenceListener {
    private static final Log log = Log.getLog(QMLogFileWriter.class);
    private static final DateTimeFormatter LOG_FILENAME_FORMATTER = DateTimeFormatter.ofPattern("'dbeaver_sql_'yyyyMMdd'.log'", Locale.ENGLISH);
    private File logFile;
    private boolean enabled;
    private Writer logWriter;
    private QMEventFilter eventFilter;
    private final String lineSeparator = GeneralUtils.getDefaultLineSeparator();

    public QMLogFileWriter() {
        DBWorkbench.getPlatform().getPreferenceStore().addPropertyChangeListener(this);
        this.initLogFile();
    }

    public void dispose() {
        DBWorkbench.getPlatform().getPreferenceStore().removePropertyChangeListener(this);
    }

    private synchronized void initLogFile() {
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        this.enabled = preferences.getBoolean("qm.storeLogs");
        if (this.enabled) {
            int daysToKeepLogs = preferences.getInt("qm.historyDays");
            String logFolderPath = preferences.getString("qm.logDirectory");
            if (CommonUtils.isEmpty((String)logFolderPath)) {
                logFolderPath = GeneralUtils.getMetadataFolder().toAbsolutePath().toString();
            }
            try {
                QMLogFileWriter.purgeOldLogs(Path.of(logFolderPath, new String[0]), daysToKeepLogs);
            }
            catch (IOException e) {
                log.debug("Error purging old logs: " + e.getMessage());
            }
            File logFolder = new File(logFolderPath);
            if (!logFolder.exists() && !logFolder.mkdirs()) {
                log.error("Can't create log folder '" + logFolderPath + "'");
            }
            this.logFile = new File(logFolder, LOG_FILENAME_FORMATTER.format(LocalDate.now()));
            try {
                this.logWriter = new FileWriter(this.logFile, true);
            }
            catch (IOException e) {
                log.error("Can't open log writer", e);
            }
        } else if (this.logWriter != null) {
            ContentUtils.close(this.logWriter);
            this.logWriter = null;
        }
        this.eventFilter = new DefaultEventFilter();
    }

    private static void purgeOldLogs(@NotNull Path logDirectory, int daysToKeep) throws IOException {
        LocalDate today = LocalDate.now();
        LocalDate judgementDay = today.minusDays(daysToKeep);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<Path> list = Files.list(logDirectory);){
            list.filter(file -> {
                try {
                    LocalDate date = LOG_FILENAME_FORMATTER.parse((CharSequence)file.getFileName().toString(), LocalDate::from);
                    return judgementDay.isAfter(date);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    return false;
                }
            }).forEach(file -> {
                try {
                    Files.delete(file);
                }
                catch (IOException e) {
                    log.debug("Unable to purge the old log file '" + String.valueOf(file) + "': " + e.getMessage());
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void metaInfoChanged(@NotNull DBRProgressMonitor monitor, @NotNull List<QMMetaEvent> events) {
        if (!this.enabled || this.logWriter == null) {
            return;
        }
        StringBuilder logBuffer = new StringBuilder(4000);
        for (QMMetaEvent event : events) {
            if (!this.eventFilter.accept(event)) continue;
            this.writeEvent(logBuffer, event);
        }
        try {
            this.logWriter.write(logBuffer.toString());
            this.logWriter.flush();
        }
        catch (IOException e) {
            log.warn("IO error writing QM log. Disable log file writer", e);
            ContentUtils.close(this.logWriter);
            this.logWriter = null;
        }
    }

    @Override
    public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        if (event.getProperty().startsWith("qm.")) {
            this.initLogFile();
        }
    }

    private void writeEvent(StringBuilder buffer, QMMetaEvent event) {
        QMMObject object = event.getObject();
        QMEventAction action = event.getAction();
        if (object instanceof QMMStatementInfo || object instanceof QMMTransactionSavepointInfo || object instanceof QMMStatementExecuteInfo && action != QMEventAction.END) {
            return;
        }
        int severity = object instanceof QMMStatementExecuteInfo ? 1 : 0;
        buffer.append("!ENTRY ");
        this.appendEntryInfo(buffer, severity, object.getObjectId(), object.getOpenTime());
        buffer.append("!MESSAGE ");
        if (object instanceof QMMStatementExecuteInfo) {
            QMMStatementExecuteInfo executeInfo = (QMMStatementExecuteInfo)object;
            buffer.append(executeInfo.getQueryString());
            buffer.append(this.lineSeparator);
            buffer.append("!SUBENTRY 1 ");
            int subSeverity = executeInfo.hasError() ? 4 : severity;
            this.appendEntryInfo(buffer, subSeverity, executeInfo.getErrorCode(), object.getCloseTime());
            buffer.append("!MESSAGE ");
            if (executeInfo.hasError()) {
                buffer.append(executeInfo.getErrorMessage());
            } else {
                buffer.append("SUCCESS [").append(executeInfo.getUpdateRowCount()).append("]");
            }
        } else if (object instanceof QMMTransactionInfo) {
            QMMTransactionInfo transactionInfo = (QMMTransactionInfo)object;
            if (transactionInfo.isCommitted()) {
                buffer.append("COMMIT");
            } else {
                buffer.append("ROLLBACK");
            }
        } else if (object instanceof QMMConnectionInfo) {
            QMMConnectionInfo sessionInfo = (QMMConnectionInfo)object;
            buffer.append((Object)action).append(" SESSION [").append(sessionInfo.getContainerName()).append("]");
        }
        buffer.append(this.lineSeparator);
        buffer.append(this.lineSeparator);
    }

    private void appendEntryInfo(StringBuilder buffer, int severity, long code, long time) {
        buffer.append("org.jkiss.dbeaver.model").append(" ").append(severity).append(" ").append(code).append(" ");
        this.appendDate(buffer, time);
        buffer.append(this.lineSeparator);
    }

    private void appendDate(StringBuilder sb, long timestamp) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timestamp);
        this.appendPaddedInt(c.get(1), 4, sb).append('-');
        this.appendPaddedInt(c.get(2) + 1, 2, sb).append('-');
        this.appendPaddedInt(c.get(5), 2, sb).append(' ');
        this.appendPaddedInt(c.get(11), 2, sb).append(':');
        this.appendPaddedInt(c.get(12), 2, sb).append(':');
        this.appendPaddedInt(c.get(13), 2, sb).append('.');
        this.appendPaddedInt(c.get(14), 3, sb);
    }

    /*
     * Unable to fully structure code
     */
    private StringBuilder appendPaddedInt(int value, int pad, StringBuilder buffer) {
        if (--pad == 0) {
            return buffer.append(Integer.toString(value));
        }
        padding = (int)Math.pow(10.0, pad);
        if (value < padding) ** GOTO lbl9
        return buffer.append(Integer.toString(value));
lbl-1000:
        // 1 sources

        {
            buffer.append('0');
            padding /= 10;
lbl9:
            // 2 sources

            ** while (padding > value && padding > 1)
        }
lbl10:
        // 1 sources

        buffer.append(value);
        return buffer;
    }
}

