/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.secg;

import java.math.BigInteger;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import net.schmizz.sshj.common.SSHRuntimeException;

public class SecgUtils {
    public static ECPoint getDecoded(byte[] M, EllipticCurve curve) {
        int elementSize = SecgUtils.getElementSize(curve);
        if (M.length != 2 * elementSize + 1 || M[0] != 4) {
            throw new SSHRuntimeException("Invalid 'f' for Elliptic Curve " + curve.toString());
        }
        byte[] xBytes = new byte[elementSize];
        byte[] yBytes = new byte[elementSize];
        System.arraycopy(M, 1, xBytes, 0, elementSize);
        System.arraycopy(M, 1 + elementSize, yBytes, 0, elementSize);
        return new ECPoint(new BigInteger(1, xBytes), new BigInteger(1, yBytes));
    }

    public static byte[] getEncoded(ECPoint point, EllipticCurve curve) {
        int elementSize = SecgUtils.getElementSize(curve);
        byte[] M = new byte[2 * elementSize + 1];
        M[0] = 4;
        byte[] xBytes = SecgUtils.stripLeadingZeroes(point.getAffineX().toByteArray());
        byte[] yBytes = SecgUtils.stripLeadingZeroes(point.getAffineY().toByteArray());
        System.arraycopy(xBytes, 0, M, 1 + elementSize - xBytes.length, xBytes.length);
        System.arraycopy(yBytes, 0, M, 1 + 2 * elementSize - yBytes.length, yBytes.length);
        return M;
    }

    private static byte[] stripLeadingZeroes(byte[] bytes) {
        int start = 0;
        while (bytes[start] == 0) {
            ++start;
        }
        return Arrays.copyOfRange(bytes, start, bytes.length);
    }

    private static int getElementSize(EllipticCurve curve) {
        int fieldSize = curve.getField().getFieldSize();
        return (fieldSize + 7) / 8;
    }
}

