/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIEngineRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;

public class AISettings
implements IAdaptable {
    private boolean aiDisabled;
    private String activeEngine;
    private final Map<String, AIEngineProperties> engineConfigurations = new LinkedHashMap<String, AIEngineProperties>();
    private final Set<String> resolvedSecrets = new HashSet<String>();
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();

    public static AIEngineProperties updatePropertiesFromMap(AIEngineProperties configuration, Map<String, Object> properties) {
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map propMap = (Map)GSON.fromJson(GSON.toJson((Object)configuration), type);
        LinkedHashMap<String, Object> mergedMap = new LinkedHashMap<String, Object>(propMap);
        mergedMap.putAll(properties);
        return (AIEngineProperties)GSON.fromJson(GSON.toJsonTree(mergedMap), configuration.getClass());
    }

    public boolean isAiDisabled() {
        return this.aiDisabled;
    }

    public void setAiDisabled(boolean aiDisabled) {
        this.aiDisabled = aiDisabled;
    }

    public String activeEngine() {
        return this.activeEngine;
    }

    public void setActiveEngine(String activeEngine) {
        AIEngineDescriptor engineDescriptor = AIEngineRegistry.getInstance().getEngineDescriptor(activeEngine);
        if (engineDescriptor != null) {
            activeEngine = engineDescriptor.getId();
        }
        this.activeEngine = activeEngine;
    }

    public boolean hasConfiguration(String engineId) {
        return this.engineConfigurations.containsKey(engineId);
    }

    @NotNull
    public synchronized <T extends AIEngineProperties> T getEngineConfiguration(@NotNull String engineId) throws DBException {
        AIEngineDescriptor engineDescriptor = AIEngineRegistry.getInstance().getEngineDescriptor(engineId);
        if (engineDescriptor == null) {
            throw new DBException("AI engine " + engineId + " not found");
        }
        AIEngineProperties aiEngineSettings = this.engineConfigurations.get(engineId);
        if (aiEngineSettings == null) {
            aiEngineSettings = engineDescriptor.createPropertiesInstance();
        }
        if (aiEngineSettings != null && !AISettingsManager.saveSecretsAsPlainText() && !this.resolvedSecrets.contains(engineId)) {
            aiEngineSettings.resolveSecrets();
            this.resolvedSecrets.add(engineId);
        }
        return (T)aiEngineSettings;
    }

    public Map<String, AIEngineProperties> getEngineConfigurations() {
        return this.engineConfigurations;
    }

    public void setEngineConfiguration(@NotNull String engineId, @NotNull AIEngineProperties engineConfiguration) {
        this.engineConfigurations.put(engineId, engineConfiguration);
    }

    public void setEngineConfigurations(@NotNull Map<String, AIEngineProperties> engineConfigurations) {
        this.engineConfigurations.putAll(engineConfigurations);
    }

    public void saveSecrets() throws DBException {
        for (Map.Entry<String, AIEngineProperties> entry : this.engineConfigurations.entrySet()) {
            String engineId = entry.getKey();
            AIEngineProperties engineConfiguration = entry.getValue();
            if (!this.resolvedSecrets.contains(engineId)) continue;
            engineConfiguration.saveSecrets();
        }
    }

    public <T> T getAdapter(@NotNull Class<T> adapter) {
        return null;
    }
}

