/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.legacy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.qm.QMTranslationHistoryItem;
import org.jkiss.utils.CommonUtils;

public class InMemoryHistoryManager {
    private static final Map<String, List<QMTranslationHistoryItem>> queryHistory = new HashMap<String, List<QMTranslationHistoryItem>>();

    @NotNull
    public static List<QMTranslationHistoryItem> readTranslationHistory(@NotNull DBSLogicalDataSource dataSource) {
        List<QMTranslationHistoryItem> queries = queryHistory.get(dataSource.getDataSourceContainer().getId());
        if (!CommonUtils.isEmpty(queries)) {
            return new ArrayList<QMTranslationHistoryItem>(queries);
        }
        return Collections.emptyList();
    }

    public static void saveTranslationHistory(@NotNull DBSLogicalDataSource dataSource, @NotNull QMTranslationHistoryItem item) {
        queryHistory.computeIfAbsent(dataSource.getDataSourceContainer().getId(), s -> new ArrayList()).add(item);
    }
}

