/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.progress.IProgressConstants;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.progress.UIJob;
import org.eclipse.e4.ui.progress.internal.FinishedJobs;
import org.eclipse.e4.ui.progress.internal.GroupInfo;
import org.eclipse.e4.ui.progress.internal.IJobBusyListener;
import org.eclipse.e4.ui.progress.internal.IJobProgressManagerListener;
import org.eclipse.e4.ui.progress.internal.ImageTools;
import org.eclipse.e4.ui.progress.internal.JobInfo;
import org.eclipse.e4.ui.progress.internal.JobInfoFactory;
import org.eclipse.e4.ui.progress.internal.JobTreeElement;
import org.eclipse.e4.ui.progress.internal.Preferences;
import org.eclipse.e4.ui.progress.internal.ProgressManagerUtil;
import org.eclipse.e4.ui.progress.internal.ProgressMessages;
import org.eclipse.e4.ui.progress.internal.Services;
import org.eclipse.e4.ui.progress.internal.TaskInfo;
import org.eclipse.e4.ui.progress.internal.WorkbenchDialogBlockedHandler;
import org.eclipse.e4.ui.progress.internal.legacy.EventLoopProgressMonitor;
import org.eclipse.e4.ui.progress.internal.legacy.PlatformUI;
import org.eclipse.e4.ui.progress.internal.legacy.Policy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogBlockedHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;

public class ProgressManager
extends ProgressProvider {
    @Deprecated
    public static final QualifiedName PROPERTY_IN_DIALOG = IProgressConstants.PROPERTY_IN_DIALOG;
    private static final String ERROR_JOB = "errorstate.svg";
    static final String ERROR_JOB_KEY = "ERROR_JOB";
    private static ProgressManager singleton;
    private final Map<Job, JobInfo> jobs = Collections.synchronizedMap(new HashMap());
    final Map<Job, JobMonitor> runnableMonitors = new HashMap<Job, JobMonitor>();
    private final Map<Object, Collection<IJobBusyListener>> familyListeners = Collections.synchronizedMap(new HashMap());
    private ListenerList<IJobProgressManagerListener> listeners = new ListenerList();
    IJobChangeListener changeListener;
    static final String PROGRESS_VIEW_NAME = "org.eclipse.e4.ui.progress.ProgressView";
    static final String PROGRESS_FOLDER = "progress/";
    private static final String SLEEPING_JOB = "sleeping.svg";
    private static final String WAITING_JOB = "waiting.svg";
    private static final String BLOCKED_JOB = "lockedstate.svg";
    public static final String SLEEPING_JOB_KEY = "SLEEPING_JOB";
    public static final String WAITING_JOB_KEY = "WAITING_JOB";
    public static final String BLOCKED_JOB_KEY = "LOCKED_JOB";
    @Inject
    @Optional
    IProgressService progressService;
    @Inject
    JobInfoFactory jobInfoFactory;
    @Inject
    FinishedJobs finishedJobs;

    public static void shutdownProgressManager() {
        if (singleton == null) {
            return;
        }
        singleton.shutdown();
    }

    @PostConstruct
    protected void init(WorkbenchDialogBlockedHandler dialogBlockedHandler) {
        Dialog.setBlockedHandler((IDialogBlockedHandler)dialogBlockedHandler);
        this.setUpImages();
        this.changeListener = this.createChangeListener();
        Job.getJobManager().setProgressProvider((ProgressProvider)this);
        Job.getJobManager().addJobChangeListener(this.changeListener);
        this.addListener(this.finishedJobs.listener);
    }

    private void setUpImages() {
        ImageTools imageTools = ImageTools.getInstance();
        imageTools.putIntoRegistry(SLEEPING_JOB_KEY, "progress/sleeping.svg");
        imageTools.putIntoRegistry(WAITING_JOB_KEY, "progress/waiting.svg");
        imageTools.putIntoRegistry(BLOCKED_JOB_KEY, "progress/lockedstate.svg");
        imageTools.putIntoRegistry(ERROR_JOB_KEY, "progress/errorstate.svg");
    }

    public IProgressMonitor createMonitor(Job job) {
        return this.progressFor(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobMonitor progressFor(Job job) {
        Map<Job, JobMonitor> map = this.runnableMonitors;
        synchronized (map) {
            JobMonitor monitor = this.runnableMonitors.get(job);
            if (monitor == null) {
                monitor = new JobMonitor(job);
                this.runnableMonitors.put(job, monitor);
            }
            return monitor;
        }
    }

    public IProgressMonitor createProgressGroup() {
        return new GroupInfo(this, this.finishedJobs);
    }

    public IProgressMonitor createMonitor(Job job, IProgressMonitor group, int ticks) {
        JobMonitor monitor = this.progressFor(job);
        if (group instanceof GroupInfo) {
            GroupInfo groupInfo = (GroupInfo)group;
            JobInfo jobInfo = this.getJobInfo(job);
            jobInfo.setGroupInfo(groupInfo);
            jobInfo.setTicks(ticks);
            groupInfo.addJobInfo(jobInfo);
        }
        return monitor;
    }

    JobInfo getJobInfo(Job job) {
        JobInfo info = this.internalGetJobInfo(job);
        if (info == null) {
            info = this.jobInfoFactory.getJobInfo(job);
            this.jobs.put(job, info);
        }
        return info;
    }

    JobInfo internalGetJobInfo(Job job) {
        return this.jobs.get(job);
    }

    private IJobChangeListener createChangeListener() {
        return new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                JobInfo info = ProgressManager.this.getJobInfo(event.getJob());
                ProgressManager.this.refreshJobInfo(info);
                for (IJobBusyListener next : ProgressManager.this.busyListenersForJob(event.getJob())) {
                    next.incrementBusy(event.getJob());
                }
            }

            public void done(IJobChangeEvent event) {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                for (IJobBusyListener next : ProgressManager.this.busyListenersForJob(event.getJob())) {
                    next.decrementBusy(event.getJob());
                }
                ProgressManager.this.removeJob(event.getJob());
            }

            public void scheduled(IJobChangeEvent event) {
                boolean noDialog;
                this.updateFor(event);
                if (event.getJob().isUser() && !(noDialog = ProgressManager.this.shouldRunInBackground())) {
                    IJobChangeEvent finalEvent = event;
                    UIJob showJob = UIJob.create(ProgressMessages.ProgressManager_showInDialogName, m -> ProgressManager.this.progressService.showInDialog(null, finalEvent.getJob()));
                    showJob.setSystem(true);
                    showJob.schedule();
                }
            }

            private void updateFor(IJobChangeEvent event) {
                if (ProgressManager.this.isInfrastructureJob(event.getJob())) {
                    return;
                }
                if (ProgressManager.this.jobs.containsKey(event.getJob())) {
                    ProgressManager.this.refreshJobInfo(ProgressManager.this.getJobInfo(event.getJob()));
                } else {
                    ProgressManager.this.addJobInfo(ProgressManager.this.jobInfoFactory.getJobInfo(event.getJob()));
                }
            }

            public void awake(IJobChangeEvent event) {
                this.updateFor(event);
            }

            public void sleeping(IJobChangeEvent event) {
                if (ProgressManager.this.jobs.containsKey(event.getJob())) {
                    ProgressManager.this.sleepJobInfo(ProgressManager.this.getJobInfo(event.getJob()));
                }
            }
        };
    }

    protected void sleepJobInfo(JobInfo info) {
        if (this.isInfrastructureJob(info.getJob())) {
            return;
        }
        GroupInfo group = info.getGroupInfo();
        if (group != null) {
            this.sleepGroup(group, info);
        }
        for (IJobProgressManagerListener listener : this.listeners) {
            if (this.isNeverDisplaying(info.getJob(), listener.showsDebug())) continue;
            if (listener.showsDebug()) {
                listener.refreshJobInfo(info);
                continue;
            }
            listener.removeJob(info);
        }
    }

    public IProgressMonitor getDefaultMonitor() {
        return this.monitorFor(null);
    }

    public IProgressMonitor monitorFor(IProgressMonitor monitor) {
        Display display;
        if (PlatformUI.isWorkbenchRunning() && !PlatformUI.isWorkbenchStarting() && !(display = this.getDisplay()).isDisposed() && display.getThread() == Thread.currentThread()) {
            return new EventLoopProgressMonitor(IProgressMonitor.nullSafe((IProgressMonitor)monitor));
        }
        return IProgressMonitor.nullSafe((IProgressMonitor)monitor);
    }

    private void sleepGroup(GroupInfo group, JobInfo info) {
        for (IJobProgressManagerListener listener : this.listeners) {
            if (this.isNeverDisplaying(info.getJob(), listener.showsDebug())) continue;
            if (listener.showsDebug() || group.isActive()) {
                listener.refreshGroup(group);
                continue;
            }
            listener.removeGroup(group);
        }
    }

    void addListener(IJobProgressManagerListener listener) {
        this.listeners.add((Object)listener);
    }

    void removeListener(IJobProgressManagerListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void refreshJobInfo(JobInfo info) {
        GroupInfo group = info.getGroupInfo();
        if (group != null) {
            this.refreshGroup(group);
        }
        for (IJobProgressManagerListener listener : this.listeners) {
            if (this.isNeverDisplaying(info.getJob(), listener.showsDebug())) continue;
            listener.refreshJobInfo(info);
        }
    }

    public void refreshGroup(GroupInfo info) {
        for (IJobProgressManagerListener element : this.listeners) {
            element.refreshGroup(info);
        }
    }

    public void refreshAll() {
        this.pruneStaleJobs();
        for (IJobProgressManagerListener element : this.listeners) {
            element.refreshAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo removeJob(Job job) {
        JobInfo info;
        Map<Job, JobMonitor> map = this.runnableMonitors;
        synchronized (map) {
            info = this.getJobInfo(job);
            this.jobs.remove(job);
            this.runnableMonitors.remove(job);
        }
        for (IJobProgressManagerListener listener : this.listeners) {
            if (this.isNeverDisplaying(info.getJob(), listener.showsDebug())) continue;
            listener.removeJob(info);
        }
        return info;
    }

    @Deprecated
    public void removeJobInfo(JobInfo info) {
        this.removeJob(info.getJob());
    }

    public void removeGroup(GroupInfo group) {
        for (IJobProgressManagerListener element : this.listeners) {
            element.removeGroup(group);
        }
    }

    public void addJobInfo(JobInfo info) {
        GroupInfo group = info.getGroupInfo();
        if (group != null) {
            this.refreshGroup(group);
        }
        this.jobs.put(info.getJob(), info);
        for (IJobProgressManagerListener listener : this.listeners) {
            if (this.isCurrentDisplaying(info.getJob(), listener.showsDebug())) continue;
            listener.addJob(info);
        }
    }

    boolean isCurrentDisplaying(Job job, boolean debug) {
        return this.isNeverDisplaying(job, debug) || job.getState() == 1;
    }

    boolean isNeverDisplaying(Job job, boolean debug) {
        if (this.isInfrastructureJob(job)) {
            return true;
        }
        if (debug) {
            return false;
        }
        return job.isSystem();
    }

    private boolean isInfrastructureJob(Job job) {
        if (Policy.DEBUG_SHOW_ALL_JOBS) {
            return false;
        }
        return job.getProperty(ProgressManagerUtil.INFRASTRUCTURE_PROPERTY) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo[] getJobInfos(boolean debug) {
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            ArrayList<JobInfo> result = new ArrayList<JobInfo>();
            for (Map.Entry<Job, JobInfo> entry : this.jobs.entrySet()) {
                if (this.isCurrentDisplaying(entry.getKey(), debug)) continue;
                result.add(entry.getValue());
            }
            JobInfo[] infos = new JobInfo[result.size()];
            result.toArray(infos);
            return infos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobTreeElement[] getRootElements(boolean debug) {
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            HashSet<JobTreeElement> result = new HashSet<JobTreeElement>();
            for (Map.Entry<Job, JobInfo> entry : this.jobs.entrySet()) {
                if (this.isCurrentDisplaying(entry.getKey(), debug)) continue;
                JobInfo jobInfo = entry.getValue();
                GroupInfo group = jobInfo.getGroupInfo();
                if (group == null) {
                    result.add(jobInfo);
                    continue;
                }
                result.add(group);
            }
            JobTreeElement[] infos = new JobTreeElement[result.size()];
            result.toArray(infos);
            return infos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasJobInfos() {
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            return !this.jobs.isEmpty();
        }
    }

    Image getImage(ImageData source) {
        ImageData mask = source.getTransparencyMask();
        return new Image(null, source, mask);
    }

    ImageData[] getImageData(URL fileSystemPath, ImageLoader loader) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream stream = fileSystemPath.openStream();){
                return loader.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            ProgressManagerUtil.logException(exception);
            return null;
        }
    }

    private void shutdown() {
        this.listeners.clear();
        Job.getJobManager().setProgressProvider(null);
        Job.getJobManager().removeJobChangeListener(this.changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListenerToFamily(Object family, IJobBusyListener listener) {
        Map<Object, Collection<IJobBusyListener>> map = this.familyListeners;
        synchronized (map) {
            Collection<IJobBusyListener> currentListeners = this.familyListeners.get(family);
            if (currentListeners == null) {
                currentListeners = new HashSet<IJobBusyListener>();
                this.familyListeners.put(family, currentListeners);
            }
            currentListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(IJobBusyListener listener) {
        Map<Object, Collection<IJobBusyListener>> map = this.familyListeners;
        synchronized (map) {
            Iterator<Collection<IJobBusyListener>> familyListeners = this.familyListeners.values().iterator();
            while (familyListeners.hasNext()) {
                Collection<IJobBusyListener> currentListeners = familyListeners.next();
                currentListeners.remove(listener);
                if (!currentListeners.isEmpty()) continue;
                familyListeners.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<IJobBusyListener> busyListenersForJob(Job job) {
        if (job.isSystem()) {
            return Collections.emptyList();
        }
        Map<Object, Collection<IJobBusyListener>> map = this.familyListeners;
        synchronized (map) {
            if (this.familyListeners.isEmpty()) {
                return Collections.emptyList();
            }
            HashSet<IJobBusyListener> returnValue = new HashSet<IJobBusyListener>();
            for (Map.Entry<Object, Collection<IJobBusyListener>> entry : this.familyListeners.entrySet()) {
                if (!job.belongsTo(entry.getKey())) continue;
                Collection<IJobBusyListener> currentListeners = entry.getValue();
                returnValue.addAll(currentListeners);
            }
            return returnValue;
        }
    }

    private boolean pruneStaleJobs() {
        Object[] jobsToCheck = this.jobs.keySet().toArray();
        boolean pruned = false;
        Object[] objectArray = jobsToCheck;
        int n = jobsToCheck.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            Job job = (Job)element;
            if (this.checkForStaleness(job)) {
                pruned = true;
            }
            ++n2;
        }
        return pruned;
    }

    boolean checkForStaleness(Job job) {
        if (job.getState() == 0) {
            this.removeJob(job);
            return true;
        }
        return false;
    }

    protected boolean shouldRunInBackground() {
        return Preferences.getBoolean("RUN_IN_BACKGROUND");
    }

    protected Display getDisplay() {
        return Services.getInstance().getDisplay();
    }

    class JobMonitor
    implements IProgressMonitor {
        Job job;
        String currentTaskName;
        IProgressMonitor listener;

        JobMonitor(Job newJob) {
            this.job = newJob;
        }

        void addProgressListener(IProgressMonitor monitor) {
            this.listener = monitor;
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            TaskInfo currentTask = info.getTaskInfo();
            if (currentTask != null) {
                this.listener.beginTask(this.currentTaskName, currentTask.totalWork);
                this.listener.internalWorked(currentTask.preWork);
            }
        }

        public void beginTask(String taskName, int totalWork) {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            info.beginTask(taskName, totalWork);
            ProgressManager.this.refreshJobInfo(info);
            this.currentTaskName = taskName;
            if (this.listener != null) {
                this.listener.beginTask(taskName, totalWork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            Map<Job, JobMonitor> map = ProgressManager.this.runnableMonitors;
            synchronized (map) {
                JobInfo info = ProgressManager.this.getJobInfo(this.job);
                info.clearTaskInfo();
                info.clearChildren();
                ProgressManager.this.runnableMonitors.remove(this.job);
            }
            if (this.listener != null) {
                this.listener.done();
            }
        }

        public void internalWorked(double work) {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            if (info.hasTaskInfo()) {
                info.addWork(work);
                ProgressManager.this.refreshJobInfo(info);
            }
            if (this.listener != null) {
                this.listener.internalWorked(work);
            }
        }

        public boolean isCanceled() {
            JobInfo info = ProgressManager.this.internalGetJobInfo(this.job);
            if (info == null) {
                return false;
            }
            return info.isCanceled();
        }

        public void setCanceled(boolean value) {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            if (value && !info.isCanceled()) {
                info.cancel();
                if (this.listener != null) {
                    this.listener.setCanceled(value);
                }
            }
        }

        public void setTaskName(String taskName) {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            if (!info.hasTaskInfo()) {
                this.beginTask(taskName, 100);
                return;
            }
            info.setTaskName(taskName);
            info.clearChildren();
            ProgressManager.this.refreshJobInfo(info);
            this.currentTaskName = taskName;
            if (this.listener != null) {
                this.listener.setTaskName(taskName);
            }
        }

        public void subTask(String name) {
            if (name == null) {
                return;
            }
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            info.clearChildren();
            info.addSubTask(name);
            ProgressManager.this.refreshJobInfo(info);
            if (this.listener != null) {
                this.listener.subTask(name);
            }
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        public void clearBlocked() {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            info.setBlockedStatus(null);
            ProgressManager.this.refreshJobInfo(info);
            if (this.listener != null) {
                this.listener.clearBlocked();
            }
        }

        public void setBlocked(IStatus reason) {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            info.setBlockedStatus(reason);
            ProgressManager.this.refreshJobInfo(info);
            if (this.listener != null) {
                this.listener.setBlocked(reason);
            }
        }
    }
}

