/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.Container;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.internal.ui.palette.editparts.IPaletteStackEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.RolloverArrow;
import org.eclipse.gef.internal.ui.palette.editparts.StackMenuListener;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.actions.SetActivePaletteToolAction;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Menu;

public class PaletteStackEditPart
extends PaletteEditPart
implements IPaletteStackEditPart {
    private static final Dimension EMPTY_DIMENSION = new Dimension(0, 0);
    private final ChangeListener clickableListener = event -> {
        if (event.getPropertyName().equals("mouseover")) {
            this.arrowFigure.getModel().setMouseOver(this.activeFigure.getModel().isMouseOver());
        } else if (event.getPropertyName().equals("armed")) {
            this.arrowFigure.getModel().setArmed(this.activeFigure.getModel().isArmed());
        }
    };
    private final ChangeListener clickableArrowListener = event -> {
        if (event.getPropertyName().equals("mouseover")) {
            this.activeFigure.getModel().setMouseOver(this.arrowFigure.getModel().isMouseOver());
        }
        if (event.getPropertyName().equals("armed")) {
            this.activeFigure.getModel().setArmed(this.arrowFigure.getModel().isArmed());
        }
    };
    private final ActionListener actionListener = event -> this.openMenu();
    private final PaletteListener paletteListener = (palette, tool) -> {
        if (this.getStack().getChildren().contains(tool)) {
            if (!this.arrowFigure.getModel().isSelected()) {
                this.arrowFigure.getModel().setSelected(true);
            }
            if (!this.getStack().getActiveEntry().equals(tool)) {
                this.getStack().setActiveEntry(tool);
            }
        } else {
            this.arrowFigure.getModel().setSelected(false);
        }
    };
    private Clickable activeFigure;
    private RolloverArrow arrowFigure;
    private Figure contentsFigure;
    private Menu menu;

    public PaletteStackEditPart(PaletteStack model) {
        super(model);
    }

    @Override
    public void activate() {
        this.checkActiveEntrySync();
        this.getViewer().addPaletteListener(this.paletteListener);
        super.activate();
    }

    private void activeEntryChanged(Object oldValue, Object newValue) {
        GraphicalEditPart part = null;
        Clickable clickable = null;
        if (newValue != null) {
            part = (GraphicalEditPart)this.getViewer().getEditPartForModel(newValue);
            clickable = (Clickable)part.getFigure();
            clickable.setVisible(true);
            clickable.addChangeListener(this.clickableListener);
            this.activeFigure = clickable;
        } else {
            this.activeFigure = null;
        }
        if (oldValue != null && (part = (GraphicalEditPart)this.getViewer().getEditPartForModel(oldValue)) != null) {
            clickable = (Clickable)part.getFigure();
            clickable.setVisible(false);
            clickable.removeChangeListener(this.clickableListener);
        }
    }

    private void checkActiveEntrySync() {
        if (this.activeFigure == null) {
            this.activeEntryChanged(null, this.getStack().getActiveEntry());
        }
    }

    @Override
    public IFigure createFigure() {
        Container figure = new Container((LayoutManager)new BorderLayout()){

            public Dimension getPreferredSize(int wHint, int hHint) {
                if (PaletteStackEditPart.this.getChildren().isEmpty()) {
                    return EMPTY_DIMENSION;
                }
                return super.getPreferredSize(wHint, hHint);
            }
        };
        StackLayout stackLayout = new StackLayout();
        stackLayout.setObserveVisibility(true);
        this.contentsFigure = new Container((LayoutManager)stackLayout);
        figure.add((IFigure)this.contentsFigure, (Object)BorderLayout.CENTER);
        this.arrowFigure = new RolloverArrow();
        this.arrowFigure.addChangeListener(this.clickableArrowListener);
        this.arrowFigure.addActionListener(this.actionListener);
        figure.add((IFigure)this.arrowFigure, (Object)BorderLayout.RIGHT);
        return figure;
    }

    @Override
    public void deactivate() {
        if (this.activeFigure != null) {
            this.activeFigure.removeChangeListener(this.clickableListener);
        }
        this.arrowFigure.removeActionListener(this.actionListener);
        this.arrowFigure.removeChangeListener(this.clickableArrowListener);
        this.getViewer().removePaletteListener(this.paletteListener);
        super.deactivate();
    }

    @Override
    public void eraseTargetFeedback(Request request) {
        this.getChildren().forEach(ep -> ep.eraseTargetFeedback(request));
        super.eraseTargetFeedback(request);
    }

    @Override
    public IFigure getContentPane() {
        return this.contentsFigure;
    }

    private PaletteStack getStack() {
        return (PaletteStack)this.getModel();
    }

    @Override
    public void openMenu() {
        MenuManager menuManager = new MenuManager();
        this.getChildren().forEach(part -> {
            PaletteEntry entry = part.getModel();
            menuManager.add((IAction)new SetActivePaletteToolAction(this.getViewer(), entry.getLabel(), entry.getSmallIcon(), this.getStack().getActiveEntry().equals(entry), (ToolEntry)entry));
        });
        this.menu = menuManager.createContextMenu(this.getViewer().getControl());
        Rectangle figureBounds = this.getFigure().getBounds().getCopy();
        this.getFigure().translateToAbsolute((Translatable)figureBounds);
        Point menuLocation = this.getViewer().getControl().toDisplay(figureBounds.getBottomLeft().x, figureBounds.getBottomLeft().y);
        this.arrowFigure.getModel().setMouseOver(false);
        this.eraseTargetFeedback(new Request("selection"));
        this.menu.setLocation(menuLocation);
        this.menu.addMenuListener((MenuListener)new StackMenuListener(this.menu, this.getViewer().getControl().getDisplay()));
        this.menu.setVisible(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("Active Entry")) {
            this.activeEntryChanged(event.getOldValue(), event.getNewValue());
        } else {
            super.propertyChange(event);
        }
    }

    @Override
    protected void refreshChildren() {
        super.refreshChildren();
        this.checkActiveEntrySync();
        this.getChildren().stream().filter(ep -> !ep.getFigure().equals(this.activeFigure)).forEach(ep -> ep.getFigure().setVisible(false));
    }

    @Override
    public void showTargetFeedback(Request request) {
        if (this.menu != null && !this.menu.isDisposed() && this.menu.isVisible()) {
            return;
        }
        this.getChildren().forEach(part -> part.showTargetFeedback(request));
        super.showTargetFeedback(request);
    }

    @Override
    public PaletteEditPart getActiveEntry() {
        return (PaletteEditPart)this.getViewer().getEditPartForModel(this.getStack().getActiveEntry());
    }
}

