/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleConstants;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectStatus;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraintBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.utils.CommonUtils;

public class OracleTableConstraint
extends OracleTableConstraintBase {
    private static final Log log = Log.getLog(OracleTableConstraint.class);
    private String searchCondition;

    public OracleTableConstraint(OracleTableBase oracleTable, String name, DBSEntityConstraintType constraintType, String searchCondition, OracleObjectStatus status) {
        super(oracleTable, name, constraintType, status, false);
        this.searchCondition = searchCondition;
    }

    public OracleTableConstraint(OracleTableBase table, ResultSet dbResult) {
        super(table, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME"), OracleTableConstraint.getConstraintType(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_TYPE")), (OracleObjectStatus)((Object)CommonUtils.notNull((Object)((Object)((OracleObjectStatus)CommonUtils.valueOf(OracleObjectStatus.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"STATUS")))), (Object)((Object)OracleObjectStatus.ENABLED))), true);
        this.searchCondition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SEARCH_CONDITION");
    }

    @Property(viewable=true, editable=true, order=4)
    public String getSearchCondition() {
        return this.searchCondition;
    }

    public void setSearchCondition(String searchCondition) {
        this.searchCondition = searchCondition;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((OracleTableBase)this.getTable()).getContainer(), this.getTable(), this});
    }

    public static DBSEntityConstraintType getConstraintType(String code) {
        switch (code) {
            case "C": {
                return DBSEntityConstraintType.CHECK;
            }
            case "P": {
                return DBSEntityConstraintType.PRIMARY_KEY;
            }
            case "U": {
                return DBSEntityConstraintType.UNIQUE_KEY;
            }
            case "R": {
                return DBSEntityConstraintType.FOREIGN_KEY;
            }
            case "V": {
                return OracleConstants.CONSTRAINT_WITH_CHECK_OPTION;
            }
            case "O": {
                return OracleConstants.CONSTRAINT_WITH_READ_ONLY;
            }
            case "H": {
                return OracleConstants.CONSTRAINT_HASH_EXPRESSION;
            }
            case "F": {
                return OracleConstants.CONSTRAINT_REF_COLUMN;
            }
            case "S": {
                return OracleConstants.CONSTRAINT_SUPPLEMENTAL_LOGGING;
            }
        }
        log.debug((Object)("Unsupported Oracle constraint type: " + code));
        return DBSEntityConstraintType.CHECK;
    }
}

