/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jsch.internal.core.JSchCorePlugin;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;
import org.jkiss.dbeaver.model.net.ssh.config.SSHAuthConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.DataSourceUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class SSHUtils {
    private static final Log log = Log.getLog(SSHUtils.class);
    public static final boolean DISABLE_SESSION_SHARING = Boolean.getBoolean("dbeaver.ssh.disableSessionSharing");
    private static final String PLATFORM_SSH_PREFERENCES_NODE = "org.eclipse.jsch.core";
    private static final String PLATFORM_SSH_PREFERENCES_SSH2HOME_KEY = "SSH2HOME";
    private static final String DEFAULT_SSH_HOME_DIR_NAME = ".ssh";
    private static final String DEFAULT_SSH_HOME_DIR_NAME_WIN_OLD = "ssh";
    private static final String KNOWN_SSH_HOSTS_FILE_NAME = "known_hosts";

    static int findFreePort() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        int minPort = store.getInt("net.tunnel.port.min");
        int maxPort = store.getInt("net.tunnel.port.max");
        return IOUtils.findFreePort((int)minPort, (int)maxPort);
    }

    public static boolean isKeyFileEncrypted(@NotNull Path privKeyPath) {
        return SSHUtils.isKeyFileEncrypted(privKeyPath.toAbsolutePath().toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isKeyFileEncrypted(String privKeyPath) {
        if (privKeyPath == null) return false;
        try {
            Identity identity;
            JSch testSch = new JSch();
            testSch.addIdentity(privKeyPath);
            IdentityRepository ir = testSch.getIdentityRepository();
            Vector identities = ir.getIdentities();
            Iterator iterator = identities.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(identity = (Identity)iterator.next()).isEncrypted());
            return true;
        }
        catch (JSchException e) {
            log.debug((Object)("Can't check private key encryption: " + e.getMessage()));
        }
        return false;
    }

    public static boolean isKeyEncrypted(byte[] privKeyValue) {
        if (privKeyValue != null) {
            try {
                JSch testSch = new JSch();
                KeyPair keyPair = KeyPair.load((JSch)testSch, (byte[])privKeyValue, null);
                return keyPair.isEncrypted();
            }
            catch (JSchException e) {
                log.debug((Object)("Can't check private key encryption: " + e.getMessage()));
            }
        }
        return false;
    }

    @NotNull
    public static File getKnownSshHostsFileOrDefault() {
        return SSHUtils.getKnownSshHostsFileImpl(true);
    }

    @Nullable
    public static File getKnownSshHostsFileOrNull() {
        return SSHUtils.getKnownSshHostsFileImpl(false);
    }

    private static File getKnownSshHostsFileImpl(boolean forceFileObjectOnFail) {
        String sshHomePathString = Platform.getPreferencesService().getString(PLATFORM_SSH_PREFERENCES_NODE, PLATFORM_SSH_PREFERENCES_SSH2HOME_KEY, null, null);
        if (CommonUtils.isNotEmpty((String)sshHomePathString)) {
            try {
                return Paths.get(sshHomePathString, KNOWN_SSH_HOSTS_FILE_NAME).toFile();
            }
            catch (InvalidPathException e) {
                log.warn((Object)("Failed to resolve SSH known hosts file location at " + sshHomePathString), (Throwable)e);
                if (forceFileObjectOnFail) {
                    return new File(sshHomePathString + File.pathSeparator + KNOWN_SSH_HOSTS_FILE_NAME);
                }
                return null;
            }
        }
        return SSHUtils.resolveDefaultKnownSshHostsFile(forceFileObjectOnFail, true);
    }

    private static File resolveDefaultKnownSshHostsFile(boolean forceFileObjectOnFail, boolean updatePreferences) {
        try {
            String userHomePathString = System.getProperty("user.home");
            if (userHomePathString != null) {
                Path userHomeDirPath = Paths.get(userHomePathString, new String[0]);
                if (Files.isDirectory(userHomeDirPath, new LinkOption[0])) {
                    Path sshHomeOldDirPath;
                    Path sshHomeDirPath = userHomeDirPath.resolve(DEFAULT_SSH_HOME_DIR_NAME);
                    if (RuntimeUtils.isWindows() && (!Files.isDirectory(sshHomeDirPath, new LinkOption[0]) || Files.notExists(sshHomeDirPath, new LinkOption[0])) && Files.isDirectory(sshHomeOldDirPath = userHomeDirPath.resolve(DEFAULT_SSH_HOME_DIR_NAME_WIN_OLD), new LinkOption[0])) {
                        sshHomeDirPath = sshHomeOldDirPath;
                    }
                    if (Files.isDirectory(sshHomeDirPath, new LinkOption[0]) || Files.notExists(sshHomeDirPath, new LinkOption[0])) {
                        if (updatePreferences) {
                            Platform.getPreferencesService().getRootNode().node(PLATFORM_SSH_PREFERENCES_NODE).put(PLATFORM_SSH_PREFERENCES_SSH2HOME_KEY, sshHomeDirPath.toAbsolutePath().toString());
                        }
                        return sshHomeDirPath.resolve(KNOWN_SSH_HOSTS_FILE_NAME).toFile();
                    }
                    log.warn((Object)("Failed to resolve default SSH known hosts file location due to invalid SSH home directory " + String.valueOf(sshHomeDirPath.toAbsolutePath())));
                } else {
                    log.warn((Object)("Failed to resolve default SSH known hosts file location due to missing user home directory " + String.valueOf(userHomeDirPath.toAbsolutePath())));
                }
            } else {
                log.warn((Object)"Failed to resolve default SSH known hosts file location due to missing user home system property.");
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Failed to resolve default SSH known hosts file location.", e);
        }
        if (forceFileObjectOnFail) {
            Path forcedUserProfilePath = Paths.get(RuntimeUtils.isWindows() ? "%USERPROFILE%" : "~", new String[0]);
            return forcedUserProfilePath.resolve(DEFAULT_SSH_HOME_DIR_NAME).resolve(KNOWN_SSH_HOSTS_FILE_NAME).toFile();
        }
        return null;
    }

    public static void forcePlatformReloadKnownHostsPreferences() {
        JSchCorePlugin.getPlugin().setNeedToLoadKnownHosts(true);
        JSchCorePlugin.getPlugin().getJSch().setHostKeyRepository(null);
    }

    @NotNull
    public static SSHHostConfiguration[] loadHostConfigurations(@NotNull DBWHandlerConfiguration configuration, boolean validate) throws DBException {
        ArrayList<SSHHostConfiguration> hosts = new ArrayList<SSHHostConfiguration>();
        int i = 0;
        while (i < 5) {
            String prefix = DataSourceUtils.getJumpServerSettingsPrefix((int)i);
            if (!configuration.getBooleanProperty(prefix + "enabled")) break;
            hosts.add(SSHUtils.loadHostConfiguration(configuration, new ConfigurationKind.JumpHost(prefix, i), validate));
            ++i;
        }
        hosts.add(SSHUtils.loadHostConfiguration(configuration, new ConfigurationKind.TargetHost(), validate));
        return (SSHHostConfiguration[])hosts.toArray(SSHHostConfiguration[]::new);
    }

    @NotNull
    private static SSHHostConfiguration loadHostConfiguration(@NotNull DBWHandlerConfiguration configuration, @NotNull ConfigurationKind kind, boolean validate) throws DBException {
        String password;
        String username;
        boolean savePassword;
        String prefix = kind.configurationPrefix();
        boolean bl = savePassword = configuration.isSavePassword() || kind instanceof ConfigurationKind.JumpHost;
        if (prefix.isEmpty()) {
            username = CommonUtils.notEmpty((String)configuration.getUserName());
            password = CommonUtils.nullIfEmpty((String)configuration.getPassword());
        } else {
            username = CommonUtils.notEmpty((String)configuration.getStringProperty(prefix + "name"));
            password = CommonUtils.nullIfEmpty((String)configuration.getSecureProperty(prefix + "password"));
        }
        if (validate && CommonUtils.isEmpty((String)username)) {
            username = SSHConstants.DEFAULT_USER_NAME;
        }
        String hostname = CommonUtils.notEmpty((String)configuration.getStringProperty(prefix + "host"));
        if (validate && CommonUtils.isEmpty((String)hostname)) {
            throw new DBException(kind.formatErrorMessage("hostname is not specified"));
        }
        int port = configuration.getIntProperty(prefix + "port");
        if (port == 0) {
            if (validate) {
                throw new DBException(kind.formatErrorMessage("port is not specified"));
            }
            port = 22;
        }
        SSHConstants.AuthType authType = (SSHConstants.AuthType)CommonUtils.valueOf(SSHConstants.AuthType.class, (String)configuration.getStringProperty(prefix + "authType"), (Enum)SSHConstants.AuthType.PASSWORD);
        Record auth = switch (authType) {
            case SSHConstants.AuthType.PUBLIC_KEY -> {
                String path = configuration.getStringProperty(prefix + "keyPath");
                if (CommonUtils.isEmpty((String)path)) {
                    String privKeyValue = configuration.getSecureProperty(prefix + "keyValue");
                    if (validate && privKeyValue == null) {
                        throw new DBException(kind.formatErrorMessage("private key is not specified"));
                    }
                    yield new SSHAuthConfiguration.KeyData(SSHUtils.trimLinesInKeyData(CommonUtils.notEmpty((String)privKeyValue)), password, savePassword);
                }
                if (validate) {
                    SSHUtils.validatePathAndEnsureExists(kind, path);
                }
                yield new SSHAuthConfiguration.KeyFile(path, password, savePassword);
            }
            case SSHConstants.AuthType.PASSWORD -> new SSHAuthConfiguration.Password(password, savePassword);
            case SSHConstants.AuthType.AGENT -> new SSHAuthConfiguration.Agent();
            default -> throw new MatchException(null, null);
        };
        return new SSHHostConfiguration(username, hostname, port, (SSHAuthConfiguration)((Object)auth));
    }

    @NotNull
    public static String trimLinesInKeyData(@NotNull String keyValue) {
        CharSequence[] lines = keyValue.split("\\n");
        int i = 0;
        while (i < lines.length) {
            lines[i] = ((String)lines[i]).trim();
            ++i;
        }
        return String.join((CharSequence)"\n", lines);
    }

    public static void saveHostConfigurations(@NotNull DBWHandlerConfiguration configuration, @NotNull SSHHostConfiguration[] hosts) {
        int i = 0;
        while (i < hosts.length) {
            if (i < hosts.length - 1) {
                SSHUtils.saveHostConfiguration(configuration, hosts[i], DataSourceUtils.getJumpServerSettingsPrefix((int)i), true, true);
            } else {
                SSHUtils.saveHostConfiguration(configuration, hosts[i], "", false, false);
            }
            ++i;
        }
    }

    private static void saveHostConfiguration(@NotNull DBWHandlerConfiguration configuration, @NotNull SSHHostConfiguration host, @NotNull String prefix, boolean markEnabled, boolean forceSavePassword) {
        configuration.setProperty(prefix + "host", (Object)host.hostname());
        configuration.setProperty(prefix + "port", (Object)host.port());
        if (prefix.isEmpty()) {
            configuration.setUserName(host.username());
        } else {
            configuration.setProperty(prefix + "name", (Object)host.username());
        }
        SSHAuthConfiguration sSHAuthConfiguration = host.auth();
        if (sSHAuthConfiguration instanceof SSHAuthConfiguration.WithPassword) {
            boolean savePassword;
            SSHAuthConfiguration.WithPassword auth = (SSHAuthConfiguration.WithPassword)sSHAuthConfiguration;
            boolean bl = savePassword = forceSavePassword || auth.savePassword();
            if (prefix.isEmpty()) {
                configuration.setSavePassword(savePassword);
                configuration.setPassword(savePassword ? auth.password() : null);
            } else {
                configuration.setSecureProperty(prefix + "password", savePassword ? auth.password() : null);
            }
        }
        if (host.auth() instanceof SSHAuthConfiguration.Password) {
            configuration.setProperty(prefix + "authType", (Object)SSHConstants.AuthType.PASSWORD.name());
        } else {
            SSHAuthConfiguration sSHAuthConfiguration2 = host.auth();
            if (sSHAuthConfiguration2 instanceof SSHAuthConfiguration.KeyFile) {
                SSHAuthConfiguration.KeyFile auth = (SSHAuthConfiguration.KeyFile)sSHAuthConfiguration2;
                configuration.setProperty(prefix + "authType", (Object)SSHConstants.AuthType.PUBLIC_KEY.name());
                configuration.setProperty(prefix + "keyPath", (Object)auth.path());
            } else {
                SSHAuthConfiguration sSHAuthConfiguration3 = host.auth();
                if (sSHAuthConfiguration3 instanceof SSHAuthConfiguration.KeyData) {
                    SSHAuthConfiguration.KeyData auth = (SSHAuthConfiguration.KeyData)sSHAuthConfiguration3;
                    configuration.setProperty(prefix + "authType", (Object)SSHConstants.AuthType.PUBLIC_KEY.name());
                    configuration.setSecureProperty(prefix + "keyValue", auth.data());
                } else if (host.auth() instanceof SSHAuthConfiguration.Agent) {
                    configuration.setProperty(prefix + "authType", (Object)SSHConstants.AuthType.AGENT.name());
                }
            }
        }
        if (markEnabled) {
            configuration.setProperty(prefix + "enabled", (Object)true);
        }
    }

    private static void validatePathAndEnsureExists(@NotNull ConfigurationKind kind, @NotNull String string) throws DBException {
        Path path;
        try {
            path = Path.of(string, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            throw new DBException(kind.formatErrorMessage("invalid private key path: " + string));
        }
        if (Files.notExists(path, new LinkOption[0])) {
            throw new DBException(kind.formatErrorMessage("private key file does not exist: " + string));
        }
    }

    private static sealed interface ConfigurationKind {
        @NotNull
        public String configurationPrefix();

        @NotNull
        public String formatErrorMessage(@NotNull String var1);

        public record JumpHost(@NotNull String configurationPrefix, int index) implements ConfigurationKind
        {
            @Override
            @NotNull
            public String formatErrorMessage(@NotNull String message) {
                return "Can't load configuration for the jump host #" + (this.index + 1) + ": " + message;
            }
        }

        public record TargetHost() implements ConfigurationKind
        {
            @Override
            @NotNull
            public String configurationPrefix() {
                return "";
            }

            @Override
            @NotNull
            public String formatErrorMessage(@NotNull String message) {
                return "Can't load configuration for the target host: " + message;
            }
        }
    }
}

