/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.generator.SQLGenerator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SQLGeneratorInnerJoin
extends SQLGenerator<DBSEntity> {
    @Override
    public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
        StringBuilder sql = new StringBuilder(100);
        SQLDialect sqlDialect = ((DBSEntity)this.objects.get(0)).getDataSource().getSQLDialect();
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            sql.append("SELECT ");
            int i = 0;
            while (i < this.objects.size()) {
                if (i > 0) {
                    sql.append(", ");
                }
                String alias = SQLUtils.generateEntityAlias((DBSEntity)((DBSEntity)this.objects.get(i)), s -> sqlDialect.getKeywordType(s) != null || aliases.contains(s));
                sql.append(alias).append(".*");
                aliases.add(alias);
                ++i;
            }
            sql.append(this.getLineSeparator()).append("FROM ");
            sql.append(this.getEntityName((DBSEntity)this.objects.get(0))).append(" ").append((String)aliases.get(0));
            i = 1;
            while (i < this.objects.size()) {
                boolean foundJoin = false;
                int k = 0;
                while (k < i) {
                    String tableJoin = SQLUtils.generateTableJoin((DBRProgressMonitor)monitor, (DBSEntity)((DBSEntity)this.objects.get(k)), (String)((String)aliases.get(k)), (DBSEntity)((DBSEntity)this.objects.get(i)), (String)((String)aliases.get(i)));
                    if (tableJoin != null) {
                        sql.append(this.getLineSeparator()).append("\tJOIN ").append(this.objects.get(i)).append(" ").append((String)aliases.get(i)).append(" ON ");
                        sql.append(tableJoin);
                        foundJoin = true;
                        break;
                    }
                    ++k;
                }
                if (!foundJoin) {
                    sql.append("\n-- Can't determine condition to join table ").append(DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)this.objects.get(i))));
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        this.result = sql.toString();
    }

    @Override
    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSEntity object) {
    }
}

