/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.dml;

import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryDMLStatementModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryInsertModel
extends SQLQueryDMLStatementModel {
    @Nullable
    private final List<SQLQuerySymbolEntry> columnNames;
    @Nullable
    private final SQLQueryRowsSourceModel valuesRows;
    @Nullable
    private final SQLQueryLexicalScope columnsScope;

    @NotNull
    public static SQLQueryModelContent recognize(@NotNull SQLQueryModelRecognizer recognizer, @NotNull STMTreeNode node) {
        SQLQueryLexicalScope insertColumnsScope;
        SQLQueryRowsSourceModel valuesRows;
        List<SQLQuerySymbolEntry> columnNames;
        STMTreeNode tableNameNode = node.findFirstChildOfName(STMKnownRuleNames.tableName);
        SQLQueryRowsTableDataModel tableModel = tableNameNode == null ? null : recognizer.collectTableReference(tableNameNode, false);
        STMTreeNode insertColumnsAndSource = node.findFirstChildOfName(STMKnownRuleNames.insertColumnsAndSource);
        if (insertColumnsAndSource != null) {
            STMTreeNode insertColumnList = insertColumnsAndSource.findFirstChildOfName(STMKnownRuleNames.insertColumnList);
            columnNames = insertColumnList == null ? null : recognizer.collectColumnNameList(insertColumnList);
            STMTreeNode valuesNode = insertColumnsAndSource.findFirstChildOfName(STMKnownRuleNames.queryExpression);
            valuesRows = valuesNode == null ? null : recognizer.collectQueryExpression(valuesNode);
            int columnsScopeFrom = insertColumnsAndSource.getRealInterval().a;
            int columnsScopeTo = valuesNode == null ? insertColumnsAndSource.getRealInterval().b : valuesNode.getRealInterval().a;
            insertColumnsScope = new SQLQueryLexicalScope();
            insertColumnsScope.setInterval(Interval.of((int)columnsScopeFrom, (int)columnsScopeTo));
        } else {
            columnNames = Collections.emptyList();
            valuesRows = null;
            insertColumnsScope = null;
        }
        return new SQLQueryInsertModel(node, tableModel, columnNames, valuesRows, insertColumnsScope);
    }

    private SQLQueryInsertModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryRowsTableDataModel tableModel, @Nullable List<SQLQuerySymbolEntry> columnNames, @Nullable SQLQueryRowsSourceModel valuesRows, @Nullable SQLQueryLexicalScope columnsScope) {
        super(syntaxNode, tableModel);
        this.columnNames = columnNames;
        this.valuesRows = valuesRows;
        this.columnsScope = columnsScope;
        if (columnsScope != null) {
            this.registerLexicalScope(columnsScope);
        }
    }

    @Nullable
    public List<SQLQuerySymbolEntry> getColumnNames() {
        return this.columnNames;
    }

    @Nullable
    public SQLQueryRowsSourceModel getValuesRows() {
        return this.valuesRows;
    }

    @Override
    protected void resolveRowsReferencesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.valuesRows != null) {
            this.valuesRows.resolveRowSources(context, statistics);
        }
    }

    @Override
    public void resolveValueRelations(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.getTableModel() != null) {
            this.getTableModel().resolveValueRelations(context, statistics);
            SQLQueryRowsDataContext columnsContext = this.getTableModel().getRowsDataContext();
            SQLQuerySymbolOrigin.ColumnNameFromRowsData origin = new SQLQuerySymbolOrigin.ColumnNameFromRowsData(columnsContext);
            if (this.columnsScope != null) {
                this.columnsScope.setSymbolsOrigin(origin);
            }
            if (this.columnNames != null) {
                for (SQLQuerySymbolEntry columnName : this.columnNames) {
                    SQLQueryResultColumn column;
                    if (!columnName.isNotClassified() || (column = columnsContext.resolveColumn(statistics.getMonitor(), columnName.getName())) == null && columnsContext.getRowsSources().hasUnresolvedSource()) continue;
                    SQLQuerySemanticUtils.propagateColumnDefinition(columnName, column, statistics, origin);
                }
            }
            if (this.valuesRows != null) {
                this.valuesRows.resolveValueRelations(context, statistics);
            }
        }
    }

    @Override
    @Nullable
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitTableStatementInsert(this, arg);
    }
}

