/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.control;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.WorkspaceConfigEventManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardListControl;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardViewItem;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfigurationList;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardGroupContainer;
import org.jkiss.dbeaver.ui.dashboard.view.catalogpanel.DashboardCatalogPanel;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DashboardListViewer
extends StructuredViewer
implements DBPDataSourceContainerProvider,
DashboardContainer {
    @NotNull
    private final IWorkbenchSite site;
    @Nullable
    private final IWorkbenchPart part;
    @NotNull
    private final DashboardConfigurationList configuration;
    @NotNull
    private final DashboardConfiguration viewConfiguration;
    private volatile boolean useSeparateConnection;
    @Nullable
    private volatile DBCExecutionContext isolatedContext;
    private DashboardListControl dashContainer;
    private boolean singleChartMode;
    private final Consumer<Object> dashboardsConfigChangedListener = a -> UIUtils.asyncExec(() -> {
        this.dashContainer.setRedraw(false);
        this.dashContainer.clear();
        this.dashContainer.createDefaultDashboards();
        this.dashContainer.layout(true, true);
        this.dashContainer.setRedraw(true);
    });
    private SashForm dashDivider;
    private DashboardCatalogPanel catalogPanel;
    private boolean isCatalogPanelVisible;

    public DashboardListViewer(@NotNull IWorkbenchSite site, @Nullable IWorkbenchPart part, @NotNull DashboardConfigurationList configuration, @NotNull DashboardConfiguration viewConfiguration) {
        this.site = site;
        this.part = part;
        this.configuration = configuration;
        this.viewConfiguration = viewConfiguration;
        this.initConnection();
    }

    public void dispose() {
        WorkspaceConfigEventManager.removeConfigChangedListener((String)"dashboards.xml", this.dashboardsConfigChangedListener);
        DBCExecutionContext context = this.isolatedContext;
        if (context != null) {
            if (context.isConnected()) {
                context.close();
            }
            this.isolatedContext = null;
        }
    }

    @Override
    @NotNull
    public DashboardConfigurationList getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isSingleChartMode() {
        return this.singleChartMode;
    }

    public void setSingleChartMode(boolean singleChartMode) {
        this.singleChartMode = singleChartMode;
    }

    public void createControl(Composite parent) {
        this.dashDivider = UIUtils.createPartDivider((IWorkbenchPart)this.part, (Composite)parent, (int)256);
        this.dashContainer = new DashboardListControl(this.site, (Composite)this.dashDivider, this);
        this.catalogPanel = new DashboardCatalogPanel((Composite)this.dashDivider, this.viewConfiguration.getProject(), this.viewConfiguration.getDataSourceContainer(), item -> this.viewConfiguration.getItemConfig(item.getId()) != null, true){

            @Override
            protected void handleChartSelected() {
            }

            @Override
            protected void handleChartSelectedFinal() {
                DashboardListViewer.this.dashContainer.addItem(this.getSelectedDashboard());
            }
        };
        this.dashDivider.setWeights(new int[]{650, 350});
        this.dashDivider.setMaximizedControl((Control)this.dashContainer);
        this.updateStatus();
    }

    public ISelection getSelection() {
        return this.getStructuredSelection();
    }

    public IStructuredSelection getStructuredSelection() {
        DashboardViewItem selectedItem = this.dashContainer.getSelectedItem();
        return selectedItem == null ? new StructuredSelection() : new StructuredSelection((Object)selectedItem);
    }

    public void createDashboardsFromConfiguration() {
        if (this.viewConfiguration.getDashboardItemConfigs().isEmpty()) {
            this.dashContainer.createDefaultDashboards();
            WorkspaceConfigEventManager.addConfigChangedListener((String)"dashboards.xml", this.dashboardsConfigChangedListener);
        } else {
            this.dashContainer.createDashboardsFromConfiguration();
        }
        if (this.viewConfiguration.getDashboardItemConfigs().isEmpty()) {
            this.dashDivider.setMaximizedControl(null);
        }
    }

    private void updateStatus() {
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.configuration.getDataSourceContainer();
    }

    @Override
    public List<? extends DashboardGroupContainer> getGroups() {
        return this.dashContainer == null ? Collections.emptyList() : Collections.singletonList(this.dashContainer);
    }

    @Override
    public DBCExecutionContext getExecutionContext() {
        if (this.useSeparateConnection && this.isolatedContext != null) {
            return this.isolatedContext;
        }
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        if (dataSourceContainer == null) {
            return null;
        }
        return DBUtils.getDefaultContext((DBSObject)dataSourceContainer.getDataSource().getDefaultInstance(), (boolean)true);
    }

    @Override
    @NotNull
    public DashboardConfiguration getViewConfiguration() {
        return this.viewConfiguration;
    }

    @Override
    @NotNull
    public IWorkbenchSite getWorkbenchSite() {
        return this.site;
    }

    @Override
    @Nullable
    public IWorkbenchPart getWorkbenchPart() {
        return this.part;
    }

    @Override
    public void updateSelection() {
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    @Override
    public void showChartCatalog() {
        if (this.dashDivider.getMaximizedControl() != null) {
            this.dashDivider.setMaximizedControl(null);
        } else if (this.dashDivider.getWeights()[1] == 0) {
            this.dashDivider.setWeights(new int[]{650, 350});
        }
        this.catalogPanel.setFocus();
        this.isCatalogPanelVisible = true;
    }

    @Override
    public void hideChartCatalog() {
        if (this.dashDivider.getMaximizedControl() != null) {
            this.dashDivider.setMaximizedControl(null);
        } else {
            this.dashDivider.setWeights(new int[]{100, 0});
        }
        this.isCatalogPanelVisible = false;
    }

    @Override
    public void saveChanges() {
        try {
            this.configuration.saveConfiguration();
        }
        catch (IOException e) {
            DBWorkbench.getPlatformUI().showError("Save error", null, (Throwable)e);
        }
    }

    protected DashboardViewItem doFindInputItem(Object element) {
        return null;
    }

    protected DashboardViewItem doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected List<?> getSelectionFromWidget() {
        DashboardViewItem selectedItem = this.dashContainer.getSelectedItem();
        return selectedItem == null ? Collections.emptyList() : Collections.singletonList(selectedItem);
    }

    protected void internalRefresh(Object element) {
    }

    public void reveal(Object element) {
        DashboardViewItem item = this.doFindItem(element);
        if (item != null) {
            this.dashContainer.showItem(item);
        }
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        if (l.isEmpty()) {
            this.dashContainer.setSelection(null);
        } else {
            DashboardViewItem item = this.doFindItem(l.get(0));
            if (item != null) {
                this.dashContainer.setSelection(item);
            }
        }
    }

    public Control getControl() {
        return this.dashContainer;
    }

    public DashboardGroupContainer getDefaultGroup() {
        return this.dashContainer;
    }

    private void initConnection() {
        this.useSeparateConnection = this.viewConfiguration.isUseSeparateConnection();
        if (this.viewConfiguration.isOpenConnectionOnActivate()) {
            DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
            if (dataSourceContainer != null && !dataSourceContainer.isConnected()) {
                UIServiceConnections serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class);
                if (serviceConnections != null) {
                    serviceConnections.connectDataSource(dataSourceContainer, status -> {
                        if (this.useSeparateConnection) {
                            this.openSeparateContext();
                        }
                    });
                }
            } else if (this.useSeparateConnection) {
                this.openSeparateContext();
            }
        } else if (this.useSeparateConnection) {
            this.openSeparateContext();
        }
    }

    private void openSeparateContext() {
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        if (dataSourceContainer == null) {
            return;
        }
        final DBPDataSource dataSource = dataSourceContainer.getDataSource();
        if (dataSource == null) {
            return;
        }
        new AbstractJob("Open connection for dashboard"){

            protected IStatus run(DBRProgressMonitor monitor) {
                DBSInstance instance = DBUtils.getObjectOwnerInstance((DBSObject)dataSource);
                if (instance != null) {
                    try {
                        DashboardListViewer.this.isolatedContext = instance.openIsolatedContext(monitor, "Dashboard connection", null);
                    }
                    catch (DBException e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public boolean isVisible() {
        return this.isCatalogPanelVisible;
    }
}

