/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.ui.config;

import java.util.ArrayList;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKeyColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.ui.config.ExasolCreateForeignKeyDialog;
import org.jkiss.dbeaver.ext.exasol.ui.internal.ExasolMessages;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;

public class ExasolForeignKeyConfigurator
implements DBEObjectConfigurator<ExasolTableForeignKey> {
    protected static final Log log = Log.getLog(ExasolForeignKeyConfigurator.class);

    public ExasolTableForeignKey configureObject(@NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object container, @NotNull ExasolTableForeignKey foreignKey, @NotNull Map<String, Object> options) {
        return (ExasolTableForeignKey)UITask.run(() -> {
            ExasolCreateForeignKeyDialog editPage = new ExasolCreateForeignKeyDialog(ExasolMessages.dialog_create_foreign_key_title, foreignKey, options);
            if (!editPage.edit()) {
                return null;
            }
            foreignKey.setName(editPage.getName());
            foreignKey.setReferencedConstraint((ExasolTableUniqueKey)editPage.getUniqueConstraint());
            foreignKey.setEnabled(Boolean.valueOf(editPage.isEnabled()));
            ArrayList<ExasolTableForeignKeyColumn> columns = new ArrayList<ExasolTableForeignKeyColumn>();
            int cnt = 0;
            for (EditForeignKeyPage.FKColumnInfo column : editPage.getColumns()) {
                try {
                    ExasolTable refTable = foreignKey.getReferencedConstraint().getTable();
                    columns.add(new ExasolTableForeignKeyColumn(foreignKey, (ExasolTableColumn)column.getOrCreateOwnColumn(monitor, commandContext, (DBSEntity)foreignKey.getTable()), refTable.getAttribute(monitor, column.getRefColumn().getName()), Integer.valueOf(++cnt)));
                }
                catch (DBException dBException) {
                    log.error((Object)"Could not get Attribute Information from Table");
                    return null;
                }
            }
            foreignKey.setAttributeReferences(columns);
            SQLForeignKeyManager.updateForeignKeyName((DBRProgressMonitor)monitor, (AbstractTableConstraint)foreignKey);
            return foreignKey;
        });
    }
}

