/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.math.BigDecimal;
import java.util.Locale;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class CustomNumberCellEditor
extends TextCellEditor {
    private final Class<?> valueType;

    public CustomNumberCellEditor(Composite parent, Class<?> valueType) {
        this.valueType = valueType;
        this.create(parent);
    }

    protected Control createControl(Composite parent) {
        super.createControl(parent);
        if (this.valueType == Float.class || this.valueType == Float.TYPE || this.valueType == Double.class || this.valueType == Double.TYPE || this.valueType == BigDecimal.class) {
            this.text.addVerifyListener(UIUtils.getNumberVerifyListener(Locale.getDefault()));
        } else {
            this.text.addVerifyListener(UIUtils.getIntegerVerifyListener(Locale.getDefault()));
        }
        return this.text;
    }

    protected Object doGetValue() {
        return GeneralUtils.convertString((String)((String)super.doGetValue()), this.valueType);
    }

    protected void doSetValue(Object value) {
        super.doSetValue((Object)CommonUtils.toString((Object)value));
    }

    protected int getDoubleClickTimeout() {
        return 0;
    }
}

